/**** Copyright (c) AvantCom Corp 2003 - 2004 ***/
/**** All rights reserved ***/
/*__________________________________________________________________
  |                                                                |
  |         Copyright 2003 - 2004  -  AvantCom Corporation         |
  |                                                                |
  |    This material is the exclusive confidential property of     |
  |    AvantCom Corporation. All rights, including copyrights      |
  |    and patent rights, are reserved. No copies of any portion   |
  |    are to be made by any means without the express written     |
  |    permission of AvantCom Corporation.                         |
  |                                                                |
  |________________________________________________________________|
*/ 
/****************************************************************************
*                                                                           *
*  File Name:           avc802dot11.h                                       *
*  Used By:                                                                 *
*                                                                           *
*  Operating System:                                                        *
*  Purpose:                                                                 *
*                                                                           *
*  Comments:                                                                *
*                                                                           *
*  Author:              Larry Simmons                                       *
*                       lsimmons@avantcom.com                               *
*                       www.avantcom.com                                    *
*                                                                           *
*  Creation Date:       09/24/03                                            *
*                                                                           *
*   Ver    Date   Inits Modification                                        *
*  ----- -------- ----- ------------                                        *
*  0.0.1 09/24/03  LRS  created                                             *
****************************************************************************/
/* This file was generated by mib2c and is intended for use as a mib module
  for the ucd-snmp snmpd agent. */
#ifndef _MIBGROUP_AVC802DOT11_H
#define _MIBGROUP_AVC802DOT11_H
/* we may use header_generic and header_simple_table from the util_funcs module */

/****************************************************************************
*                               Includes                                    *
****************************************************************************/
#include <sys/queue.h>

/****************************************************************************
*                             Linked List Defines                           *
****************************************************************************/
// here are some Linked List MACROS I wanted to use, 
// but curiously were not in /usr/includes/sys/queue.h

#ifndef LIST_EMPTY
  #define	LIST_EMPTY(head)	((head)->lh_first == NULL)
#endif

#ifndef LIST_NEXT
  #define	LIST_NEXT(elm, field)	((elm)->field.le_next)
#endif

#ifndef LIST_INSERT_BEFORE
  #define	LIST_INSERT_BEFORE(listelm, elm, field) do {			\
	  (elm)->field.le_prev = (listelm)->field.le_prev;		\
	  LIST_NEXT((elm), field) = (listelm);				\
	  *(listelm)->field.le_prev = (elm);				\
	  (listelm)->field.le_prev = &LIST_NEXT((elm), field);		\
  } while (0)
#endif

#ifndef LIST_FIRST
  #define	LIST_FIRST(head)	((head)->lh_first)
#endif

/****************************************************************************
*                             802.11 MIB Defines                            *
****************************************************************************/
#define MAXRADIOS 16

#define IFINDEX_LEN                          4
#define IFNAME_LEN                          16
#define MACADDR_LEN                        ( 6 * 2 ) + 5

#define PRAC_UID_LEN    IFINDEX_LEN + 1 + MACADDR_LEN
#define ATHMAC_UID_LEN  IFINDEX_LEN
#define ATHPHY_UID_LEN  IFINDEX_LEN

/****************************************************************************
*                             Prism HostAP Defines                          *
****************************************************************************/
#define AP                          "AP="
#define STA                         "STA="
#define USERS                       "users="
#define AID                         "aid="
#define FLAGS                       "flags="
#define AUTH                        "AUTH"
#define ASSOC                       "ASSOC"
#define CAPABILITY                  "capability="
#define LISTENINTERVAL              "listen_interval="
#define MBPS1                       "1Mbps"
#define MBPS2                       "2Mbps"
#define MBPS5                       "5.5Mbps"
#define MBPS11                      "11Mbps"
#define JIFFIES                     "jiffies="
#define LASTAUTH                    "last_auth="
#define LASTASSOC                   "last_assoc="
#define LASTRX                      "last_rx="
#define LASTTX                      "last_tx="
#define RXPACKETS                   "rx_packets="
#define TXPACKETS                   "tx_packets="
#define RXBYTES                     "rx_bytes="
#define TXBYTES                     "tx_bytes="
#define BFRCNT                      "buffer_count="
#define SILENCE                     "silence="
#define SIGNAL                      "signal="
#define RATE                        "rate="
#define FLOW                        "flow="
#define TXRATE                      "tx_rate="
#define TX1M                        "tx[1M]="
#define TX2M                        "tx[2M]="
#define TX5M                        "tx[5.5M]="
#define TX11M                       "tx[11M]="
#define RX1M                        "rx[1M]="
#define RX2M                        "rx[2M]="
#define RX5M                        "rx[5.5M]="
#define RX11M                       "rx[11M]="

/****************************************************************************
*                          Atheros MadWiFi Defines                          *
****************************************************************************/
#define WATCHDOG                    "watchdog="
#define HARDWARE                    "hardware="
#define BMISS                       "bmiss="
#define RXORN                       "rxorn="
#define RXEOL                       "rxeol="
#define TXURN                       "txurn="
#define TX_MGMT                     "tx_mgmt="
#define TX_DISCARD                  "tx_discard="
#define TX_INVALID                  "tx_invalid="
#define TX_QSTOP                    "tx_qstop="
#define TX_ENCAP                    "tx_encap="
#define TX_NONODE                   "tx_nonode="
#define TX_NOBUF                    "tx_nobuf="
#define TX_NOBUFMGT                 "tx_nobufmgt="
#define TX_XRETRIES                 "tx_xretries="
#define TX_FIFOERR                  "tx_fifoerr="
#define TX_FILTERED                 "tx_filtered="
#define TX_SHORTRETRY               "tx_shortretry="
#define TX_LONGRETRY                "tx_longretry="
#define TX_BADRATE                  "tx_badrate="
#define TX_NOACK                    "tx_noack="
#define TX_RTS                      "tx_rts="
#define TX_CTS                      "tx_cts="
#define TX_SHORTPRE                 "tx_shortpre="
#define TX_RSSI                     "tx_rssi="
#define TX_RSSIDELTA                "tx_rssidelta="
#define RX_ORN                      "rx_orn="
#define RX_TOOSHORT                 "rx_tooshort="
#define RX_CRCERR                   "rx_crcerr="
#define RX_FIFOERR                  "rx_fifoerr="
#define RX_BADCRYPT                 "rx_badcrypt="
#define RX_PHYERR                   "rx_phyerr="
#define RX_NOBUF                    "rx_nobufr="
#define RX_RSSI                     "rx_rssi="
#define RX_RSSIDELTA                "rx_rssidelta="
#define BE_NOBUF                    "be_nobuf="
#define PER_CAL                     "per_cal="
#define PER_CALFAIL                 "per_calfail="
#define PER_RFGAIN                  "per_rfgain="
#define RATE_CALLS                  "rate_calls="
#define RATE_RAISE                  "rate_raise="
#define RATE_DROP                   "rate_drop="

#define PHYERR_UNDERRUN             "PHYERR_UNDERRUN="
#define PHYERR_TIMING               "PHYERR_TIMING="
#define PHYERR_PARITY               "PHYERR_PARITY="
#define PHYERR_RATE                 "PHYERR_RATE="
#define PHYERR_LENGTH               "PHYERR_LENGTH="
#define PHYERR_RADAR                "PHYERR_RADAR="
#define PHYERR_SERVICE              "PHYERR_SERVICE="
#define PHYERR_TOR                  "PHYERR_TOR="

// these are specific to the 5212 
#define PHYERR_OFDM_TIMING          "PHYERR_OFDM_TIMING="
#define PHYERR_OFDM_SIGNAL_PARITY   "PHYERR_OFDM_SIGNAL_PARITY="
#define PHYERR_OFDM_RATE_ILLEGAL    "PHYERR_OFDM_RATE_ILLEGAL="
#define PHYERR_OFDM_LENGTH_ILLEGAL  "PHYERR_OFDM_LENGTH_ILLEGAL="
#define PHYERR_OFDM_POWER_DROP      "PHYERR_OFDM_POWER_DROP="
#define PHYERR_OFDM_SERVICE         "PHYERR_OFDM_SERVICE="
#define PHYERR_OFDM_RESTART         "PHYERR_OFDM_RESTART="
#define PHYERR_CCK_TIMING           "PHYERR_CCK_TIMING="
#define PHYERR_CCK_HEADER_CRC       "PHYERR_CCK_HEADER_CRC="
#define PHYERR_CCK_RATE_ILLEGAL     "PHYERR_CCK_RATE_ILLEGAL="
#define PHYERR_CCK_SERVICE          "PHYERR_CCK_SERVICE="
#define PHYERR_CCK_RESTART          "PHYERR_CCK_RESTART="

/****************************************************************************
*                           Linked List Structure                           *
****************************************************************************/
static struct avc802dot11Node {  
  LIST_ENTRY ( avc802dot11Node ) nodes; 
  char *data;                                 // pointer to data
} *avc802dot11np;;

typedef LIST_HEAD ( , avc802dot11Node ) avc802dot11List_t;

/****************************************************************************
*                           Prism MIB structures                            *
****************************************************************************/
/****************************************************************************
*                   Prism Associated Clients MIB structure                  *
****************************************************************************/
static struct prAcTbl_data {

  char  UID         [ PRAC_UID_LEN + 1 ];
  char  ifName      [ IFNAME_LEN   + 1 ];    // ifName of card

  long  ifIndex;                             // ifindex of card
  char  macAddress  [ MACADDR_LEN  + 1 ];    // MacAddr

  long  stationType;
  long  listenInterval;
  long  supports1Mbps;
  long  supports2Mbps;
  long  supports5Mbps;
  long  supports11Mbps;
  long  jiffies;
  long  lastAuth;
  long  lastAssoc;
  long  lastRx;
  long  lastTx;
  long  rxPackets;
  long  txPackets;
  long  rxBytes;
  long  txBytes;
  long  bfrCnt;
  long  lastRxSilence;
  long  lastRxSignal;
  long  lastRxRate;
  long  lastRxFlow;
  long  txRate;
  long  tx1Mbps;
  long  tx2Mbps;
  long  tx5Mbps;
  long  tx11Mbps;
  long  rx1Mbps;
  long  rx2Mbps;
  long  rx5Mbps;
  long  rx11Mbps;

} nPrAc, *prAc = &nPrAc;

static avc802dot11List_t prAcList;

/****************************************************************************
*                          Atheros MIB structures                           *
****************************************************************************/
/****************************************************************************
*                        Atheros MAC Counters Table                         *
****************************************************************************/
static struct athMacTbl_data {

  char  UID         [ ATHMAC_UID_LEN + 1 ];
  char  ifName      [ IFNAME_LEN     + 1 ];  // ifName of card
  long  ifIndex;                             // ifindex of card

  long  watchDog;
  long  fatalHwInterrupt;
  long  missedBeacons;
  long  rxOverRun;
  long  rxEol;
  long  txUnderRun;
  long  txMgmtFrames;
  long  txDiscards;
  long  txInvalid;
  long  txQueueStopped;
  long  txEncapFailed;
  long  txNoNode;
  long  txNoDataBuffer;
  long  txNoMgmtBuffer;
  long  txExcessiveRetries;
  long  txFifoUnderRun;
  long  txFiltered;
  long  txShortRetries;
  long  txLongRetries;
  long  txBadRate;
  long  txNoAck;
  long  txRts;
  long  txCts;
  long  txShortPreamble;
  long  txRssi;
  long  txRssiDelta;
  long  rxDescOverRun;
  long  rxFrameTooShort;
  long  rxCrcError;
  long  rxFifoOverRun;
  long  rxCryptFailure;
  long  rxNoSkBuffer;
  long  rxRssi;
  long  rxRssiDelta;
  long  noBeaconBuffer;
  long  calibrations;
  long  failedCalibrations;
  long  rfGainResets;
  long  rateControlChecks;
  long  rateControlRaise;
  long  rateControlDrop;

} nAthMac, *athMac = &nAthMac;

static avc802dot11List_t athMacList;

/****************************************************************************
*                        Atheros PHY Counters Table                         *
****************************************************************************/
static struct athPhyTbl_data {

  char  UID         [ ATHPHY_UID_LEN + 1 ];
  char  ifName      [ IFNAME_LEN     + 1 ];  // ifName of card
  long  ifIndex;                             // ifindex of card

  long  totalPhyErrors;
  long  txUnderRun;
  long  timingErrors;
  long  parityErrors;
  long  invalidRate;
  long  invalidLength;
  long  radarDetected;
  long  invalidService;
  long  txOverrideRx;
  long  OfdmTiming;
  long  OfdmSignalParity;
  long  OfdmInvalidRate;
  long  OfdmInvalidLength;
  long  OfdmPowerDrop;
  long  OfdmService;
  long  OfdmRestart;
  long  CckTiming;
  long  CckHeaderCrc;
  long  CckInvalidRate;
  long  CckService;
  long  CckRestart;

} nAthPhy, *athPhy = &nAthPhy;

static avc802dot11List_t athPhyList;

/****************************************************************************
*                                                                           *
****************************************************************************/
config_require(util_funcs)

/* function prototypes */

void   init_avc802dot11(void);
FindVarMethod var_avc802dot11;
FindVarMethod var_prAssociatedClientsTable;
FindVarMethod var_athMacCountersTable;
FindVarMethod var_athPhyCountersTable;

#endif /* _MIBGROUP_AVC802DOT11_H */
