/*  Copyright 2005 Sveasoft Inc.
**  
**     Licensed under the Apache License, Version 2.0 (the "License")
**     with the following addendum:
**     
**     ADDENDUM
**     
**     10. This code may not be used, distributed, aggregated, or 
**     relicensed under any other license that restricts its use 
**     further than the stipulations of the Apache License, Version 2.0.
**     Specifically this code may not be relicensed under any version of 
**     the GPL or LGPL licenses. 
**     
**     The Apache License, Version 2.0 will apply to the entire work for
**     any derived, aggregated, compiled, or other works, in source or 
**     binary form, of this source code when combined with source code or  
**     binary compilationslicensed under a more restrictive license, such 
**     as the GPL or LGPL.
**     
**     END OF ADDENDUM
**     
**     You may not use this file except in compliance with the License.
**     You may obtain a copy of the License at
**  
**         http://www.apache.org/licenses/LICENSE-2.0
**  
**     Unless required by applicable law or agreed to in writing, software
**     distributed under the License is distributed on an "AS IS" BASIS,
**     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
**     See the License for the specific language governing permissions and
**     limitations under the License.
*/ 

#ifndef __MATRIXSSL_XFACE_H__
#define __MATRIXSSL_XFACE_H__

#include <stdio.h>
#include <matrixSsl.h>

//#define DEBUG_MATRIXSSL 1

typedef struct  {
	int   fp;
	ssl_t *ssl;
	char* ssl_recv_buf;
	int   ssl_recv_buflen;
	int   ssl_recv_cur;
	char* ssl_send_buf;
	int   ssl_send_buflen;
	int   ssl_send_cur;
} matrixssl_buf;

#define msslAssert(C)		if (C) ; else {fprintf(stderr, "%s:%d myAssert(%s)\n",\
						__FILE__, __LINE__, #C); abort(); }

void   matrixssl_init(void);
void   matrixssl_new_session(int fp);
char * matrixssl_gets(FILE* fp, char* buf, int len);
int    matrixssl_puts(FILE* fp, char* buf);
int    matrixssl_putc(FILE* fp, char buf);
int    matrixssl_printf(FILE* fp, char* fmt, char* buf);
int    matrixssl_write(FILE* fp, char* buf , int size);
int    matrixssl_read(FILE* fp, char* buf , int size);
int    matrixssl_flush(FILE* fp);
int    matrixssl_free_session(FILE* fp);
int    do_matrixssl_recv(FILE* fp);
int    do_matrixssl_send(FILE* fp);

#endif /* __MATRIXSSL_XFACE_H__ */

