/*  Copyright 2005 Sveasoft Inc.
**  
**     Licensed under the Apache License, Version 2.0 (the "License")
**     with the following addendum:
**     
**     ADDENDUM
**     
**     10. This code may not be used, distributed, aggregated, or 
**     relicensed under any other license that restricts its use 
**     further than the stipulations of the Apache License, Version 2.0.
**     Specifically this code may not be relicensed under any version of 
**     the GPL or LGPL licenses. 
**     
**     The Apache License, Version 2.0 will apply to the entire work for
**     any derived, aggregated, compiled, or other works, in source or 
**     binary form, of this source code when combined with source code or  
**     binary compilationslicensed under a more restrictive license, such 
**     as the GPL or LGPL.
**     
**     END OF ADDENDUM
**     
**     You may not use this file except in compliance with the License.
**     You may obtain a copy of the License at
**  
**         http://www.apache.org/licenses/LICENSE-2.0
**  
**     Unless required by applicable law or agreed to in writing, software
**     distributed under the License is distributed on an "AS IS" BASIS,
**     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
**     See the License for the specific language governing permissions and
**     limitations under the License.
*/  

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <utils.h>
#include <bcmnvram.h>


#define HOME_DIR	"/tmp/root"
#define PASSWD_DIR	"/tmp/etc"
#define SSH_DIR		"/tmp/root/.ssh"
#define PASSWD_FILE	"/tmp/etc/passwd"
#define GROUP_FILE	"/tmp/etc/group"


void to64(char *s, long v, int n)
{

  unsigned char itoa64[] = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

  while (--n >= 0)
  {
	*s++ = itoa64[v&0x3f];
        v >>= 6;
  }
}

char *zencrypt (char *passwd)
{
	char salt[6];
	struct timeval tv;
	char *crypt (const char *, const char *);

	gettimeofday(&tv,0);

	to64(&salt[0], random(), 3);
	to64(&salt[3], tv.tv_usec, 3);
	salt[5] = '\0';

	return crypt (passwd, salt);
}


int mkfiles(void)
{
	FILE *fp ;
        struct stat buf;
        char *http_passwd = nvram_safe_get("http_passwd");
        char *cp ;

	if( stat(HOME_DIR, &buf) != 0 ){
		mkdir(HOME_DIR, 0700);
	}

#ifdef HAVE_SSHD
	if( stat(SSH_DIR, &buf) != 0 ){
		mkdir(SSH_DIR, 0700);
	}
#endif

	/* Create password's and group's database directory */
	if( stat(PASSWD_DIR, &buf) != 0 ){
		mkdir(PASSWD_DIR, 0700);
	}

	cp = (char *) zencrypt(http_passwd); /* encrypt password*/
	/* Write password file with username root and password */
	if (!(fp = fopen(PASSWD_FILE, "w"))) {
		perror(PASSWD_FILE);
		return errno;
	}
	fprintf(fp, "root:%s:0:0:Root User,,,:/tmp/root:/bin/sh\n",cp) ;
	fclose (fp) ;

	/* Write group file with group 'root' */
	if (!(fp = fopen(GROUP_FILE, "w"))) {
		perror(GROUP_FILE);
		return errno;
	}
	fprintf(fp, "root:x:0:\n") ;
	fclose (fp) ;

	system("/bin/mkdir /var/spool");
	system("/bin/mkdir /var/spool/cron");
	system("/bin/mkdir /var/spool/cron/crontabs");
	system("/bin/touch /var/spool/cron/crontabs/root");

	system("/bin/mkdir /var/log");
	system("/bin/touch /var/log/messages");

#ifdef HAVE_SNMP
	system("/bin/mkdir /var/snmp");
#endif
	system("/bin/chmod 0777 /tmp");
	
	dns_to_resolv();
	
	return 0;
}
