/*  Copyright 2005 Sveasoft Inc.
**  
**     Licensed under the Apache License, Version 2.0 (the "License")
**     with the following addendum:
**     
**     ADDENDUM
**     
**     10. This code may not be used, distributed, aggregated, or 
**     relicensed under any other license that restricts its use 
**     further than the stipulations of the Apache License, Version 2.0.
**     Specifically this code may not be relicensed under any version of 
**     the GPL or LGPL licenses. 
**     
**     The Apache License, Version 2.0 will apply to the entire work for
**     any derived, aggregated, compiled, or other works, in source or 
**     binary form, of this source code when combined with source code or  
**     binary compilationslicensed under a more restrictive license, such 
**     as the GPL or LGPL.
**     
**     END OF ADDENDUM
**     
**     You may not use this file except in compliance with the License.
**     You may obtain a copy of the License at
**  
**         http://www.apache.org/licenses/LICENSE-2.0
**  
**     Unless required by applicable law or agreed to in writing, software
**     distributed under the License is distributed on an "AS IS" BASIS,
**     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
**     See the License for the specific language governing permissions and
**     limitations under the License.
*/

#ifdef HAVE_SNMP

#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <bcmnvram.h>
#include <shutils.h>
#include <snmp.h>

int start_snmp(void)
{
	int ret = 0;
	pid_t pid;

	char fname[] = "/var/snmp/snmpd.conf";
	char *snmpd_argv[] = { "/usr/sbin/snmpd", "-c", fname, NULL};
	FILE *fp = NULL;

	stop_snmp();

	if (!nvram_invmatch("snmpd_enable", "0"))
		return 0;

	fp = fopen(fname, "w");
	if(NULL == fp)
		return -1;

	/* if smnpd_conf is defined and not the default use the contents as the config file */
	if(strlen(nvram_safe_get("snmpd_conf")) > 0 && strcmp(nvram_safe_get("snmpd_conf"), "See http://www.net-snmp.org for expert snmpd.conf options"))
		fprintf(fp, "%s", nvram_safe_get("snmpd_conf"));
	else{
		if (strlen(nvram_safe_get("snmpd_syslocation")) > 0)
			fprintf(fp,"syslocation %s\n", nvram_safe_get("snmpd_syslocation"));
		if (strlen(nvram_safe_get("snmpd_syscontact")) > 0)
			fprintf(fp,"syscontact %s\n", nvram_safe_get("snmpd_syscontact"));
		if (strlen(nvram_safe_get("snmpd_sysname")) > 0)
			fprintf(fp,"sysname %s\n", nvram_safe_get("snmpd_sysname"));
		if (strlen(nvram_safe_get("snmpd_rocommunity")) > 0)
			fprintf(fp,"rocommunity %s\n", nvram_safe_get("snmpd_rocommunity"));
		if (strlen(nvram_safe_get("snmpd_rwcommunity")) > 0)
			fprintf(fp,"rwcommunity %s\n", nvram_safe_get("snmpd_rwcommunity"));
	}
	
	fclose(fp);

	ret = _eval(snmpd_argv, NULL, 0, &pid);

	dprintf("done\n");

	return ret;
}

int stop_snmp(void)
{
	int ret;

        ret = eval("killall","-9","snmpd");

	dprintf("done\n");

	return ret ;
}
#endif
