/*  Copyright 2005 Sveasoft Inc.
**  
**     Licensed under the Apache License, Version 2.0 (the "License")
**     with the following addendum:
**     
**     ADDENDUM
**     
**     10. This code may not be used, distributed, aggregated, or 
**     relicensed under any other license that restricts its use 
**     further than the stipulations of the Apache License, Version 2.0.
**     Specifically this code may not be relicensed under any version of 
**     the GPL or LGPL licenses. 
**     
**     The Apache License, Version 2.0 will apply to the entire work for
**     any derived, aggregated, compiled, or other works, in source or 
**     binary form, of this source code when combined with source code or  
**     binary compilationslicensed under a more restrictive license, such 
**     as the GPL or LGPL.
**     
**     END OF ADDENDUM
**     
**     You may not use this file except in compliance with the License.
**     You may obtain a copy of the License at
**  
**         http://www.apache.org/licenses/LICENSE-2.0
**  
**     Unless required by applicable law or agreed to in writing, software
**     distributed under the License is distributed on an "AS IS" BASIS,
**     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
**     See the License for the specific language governing permissions and
**     limitations under the License.
*/ 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <sys/time.h>
#include <syslog.h>
#include <wait.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <wlutils.h>
#include <wlioctl.h>
#include <rc.h>

#include <cy_conf.h>
#include <bcmutils.h>
#include <utils.h>
#include <nvparse.h>
#include <sveasoft.h>

#define WLAND_INTERVAL 15

#define sin_addr(s) (((struct sockaddr_in *)(s))->sin_addr)

static char* get_wdev()
{
	if(check_hw_type() == BCM4702_CHIP)
	  return "eth2";
	else
	  return "eth1";

}

static int
notify_wdsnas(char *type, char *ifname, char *action)
{
	char *argv[] = {"nas4not", type, ifname, action,
			NULL,	/* role */
			NULL,	/* crypto */
			NULL,	/* auth */
			NULL,	/* passphrase */
			NULL,	/* ssid */
			NULL};
	char *str = NULL;
	int retries = 10;
	char tmp[100], prefix[] = "wlXXXXXXXXXX_";
	int unit;
	char remote[ETHER_ADDR_LEN];
	char ssid[48], pass[80], auth[16], crypto[16], role[8];
	int i;

	/* the wireless interface must be configured to do WPA */
	wl_ioctl(ifname, WLC_GET_INSTANCE, &unit, sizeof(unit));
	snprintf(prefix, sizeof(prefix), "wl%d_", unit);
	if (nvram_match(strcat_r(prefix, "auth_mode", tmp), "open") ||
	    nvram_match(strcat_r(prefix, "auth_mode", tmp), "shared"))
		return 0;

	/* find WDS link configuration */
	wl_ioctl(ifname, WLC_WDS_GET_REMOTE_HWADDR, remote, ETHER_ADDR_LEN);
	for (i = 0; i < MAX_NVPARSE; i ++) {
		char mac[ETHER_ADDR_STR_LEN];
		uint8 ea[ETHER_ADDR_LEN];

		if (get_wds_wsec(unit, i, mac, role, crypto, auth, ssid, pass) &&
		    ether_atoe(mac, ea) && !bcmp(ea, remote, ETHER_ADDR_LEN)) {
			argv[4] = role;
			argv[5] = crypto;
			argv[6] = auth;
			argv[7] = pass;
			argv[8] = ssid;
			break;
		}
	}

	/* did not find WDS link configuration, use wireless' */
	if (i == MAX_NVPARSE) {
		/* role */
		argv[4] = "auto";
		/* crypto */
		argv[5] = nvram_safe_get(strcat_r(prefix, "crypto", tmp));
		/* auth mode */
		argv[6] = nvram_safe_get(strcat_r(prefix, "auth_mode", tmp));
		/* passphrase */
		argv[7] = nvram_safe_get(strcat_r(prefix, "wpa_psk", tmp));
		/* ssid */
		argv[8] = nvram_safe_get(strcat_r(prefix, "ssid", tmp));
	}

	/* wait till nas is started */
	while (retries -- > 0 && !(str = file2str("/tmp/nas.lan.pid")))
		sleep(1);
	if (str) {
		int pid;
		free(str);
		return _eval(argv, ">/dev/console", 0, &pid);
	}
	return -1;

}

static int do_wds_check(void)
{
	int s=0;

	/* Sveasoft - Bring up and configure wds interfaces */
	/* logic - if separate ip defined bring it up */
	/*         else if flagged for br1 and br1 is enabled add to br1 */
	/*         else add it to the br0 bridge */
	for(s=1;s<=MAX_WDS_DEVS;s++)
	{
		char wdsvarname[32] = {0};
		char wdsdevname[32] = {0};
		char *dev;
		struct ifreq ifr;


		sprintf(wdsvarname, "wl_wds%d_enable", s);
		sprintf(wdsdevname, "wl_wds%d_if", s);
		dev = nvram_safe_get(wdsdevname);

		if(nvram_invmatch(wdsvarname, "1"))
		  continue;

    		memset(&ifr, 0, sizeof(struct ifreq));

    		snprintf(ifr.ifr_name, IFNAMSIZ, wdsdevname);
    		ioctl(s, SIOCGIFFLAGS, &ifr);

		if( (ifr.ifr_flags & (IFF_RUNNING | IFF_UP)) == (IFF_RUNNING | IFF_UP))
		  continue;

		/* P2P WDS type */
		if(nvram_match(wdsvarname, "1") ){
			char wdsip[32] 	    = {0};
			char wdsbc[32] 	    = {0};
			char wdsnm[32] 	    = {0};

			snprintf(wdsip, 31,"wl_wds%d_ipaddr", s);
			snprintf(wdsnm, 31, "wl_wds%d_netmask", s);

			snprintf(wdsbc,31, "%s", nvram_safe_get(wdsip));
			get_broadcast(wdsbc, nvram_safe_get(wdsnm));
			eval("ifconfig", dev, nvram_safe_get(wdsip), "broadcast", wdsbc, "netmask", nvram_safe_get(wdsnm), "up");
		}
		/* Subnet WDS type */
		else if(nvram_match(wdsvarname, "2") && nvram_match("wl_br1_enable", "1")){
			eval("ifconfig", dev, "up");
			eval("/usr/sbin/brctl", "addif", "br1", dev);
		}
		/* LAN WDS type */
		else if(nvram_match(wdsvarname, "3")){
			eval("ifconfig", dev, "up");
			eval("/usr/sbin/brctl", "addif", "br0", dev);
		}

	}

	if (nvram_match("router_disable", "1") || nvram_match("lan_stp", "0"))
		system("/usr/sbin/brctl stp br0 disable stp");

	return 0;
}


static int do_ap_watchdog(void)
{

  /* AP Watchdog - experimental check and fix for hung AP */

  struct stat s;
  static time_t last;
  int interval = atoi(nvram_safe_get("apwatchdog_interval")) > WLAND_INTERVAL ? atoi(nvram_safe_get("apwatchdog_interval")) : WLAND_INTERVAL;

  system("/usr/sbin/wl assoclist 2>&1 > /tmp/.assoclist");
  stat("/tmp/.assoclist", &s);
  unlink("/tmp/.assoclist");

  if( 	s.st_size <= 0 &&
  	time(NULL) - last > interval &&
  	nvram_match("apwatchdog_enable", "1") &&
	nvram_invmatch("wl_net_mode", "disabled")){

	int val = 0;

	time(&last);
	cprintf("resetting ap radio\n");
	eval("/usr/sbin/wlconf", get_wdev(), "down");

	val = atoi(nvram_safe_get("wl0_channel")) + 1;
	if(val <=2 || val >= 14)
	 val = 2;

	wl_ioctl(get_wdev(), WLC_SET_CHANNEL, &val, sizeof(val));
	wl_ioctl(get_wdev(), WLC_UP, NULL, 0);

	eval("/usr/sbin/wlconf", get_wdev(), "down");
	eval("/usr/sbin/wlconf", get_wdev(), "up");

  }

  return 0;

}

static int do_ap_check(void)
{

  if(nvram_match("apwatchdog_enable", "1"))
    do_ap_watchdog();

  // possible bug in Alchemy-6.0rc5a, we wait for Talisman to debug this
  //do_wds_check();

  return 0;
}

/* for Client/Wet mode */
/* be nice to rewrite this to use sta_info_t if we had proper Broadcom API specs */
static int do_client_check(void)
{
	FILE *fp=NULL;
	char buf[1024];
	int  len;

	system("/usr/sbin/wl assoc 2>&1 > /tmp/.xassocx");
	if( (fp = fopen("/tmp/.xassocx", "r")) == NULL)
		return -1;

	len = fread(buf, 1, 1023, fp);

	buf[len] = 0;

	if(len > 0 && strstr(buf, "Not associated.")){
	  /* let wl do this for us (no use in reinventing the wheel) */

	eval("/usr/sbin/wlconf", get_wdev(), "down");
	eval("/usr/sbin/wlconf", get_wdev(), "up");
	
	}
	
	fclose(fp);
	unlink("/tmp/.xassocx");

	return 0;
}

static void do_wlan_check(void)
{

  if(nvram_invmatch("wl0_mode", "ap"))
    do_client_check();
  else
    do_ap_check();


}


int wland_main(int argc, char **argv)
{
	/* Run it in the background */
	switch (fork()) {
	case -1:
		// can't fork
		exit(0);
		break;
	case 0:
		/* child process */
		// fork ok
		(void) setsid();
		break;
	default:
		/* parent process should just die */
		_exit(0);
	}

	/* Most of time it goes to sleep */
	while(1)
	{
	  do_wlan_check();

	  sleep(WLAND_INTERVAL);
	}

	return 0;
} // end main

int stop_wland(void)
{
        int ret = eval("killall","-9", "wland");

        dprintf("done\n");
        return ret;
}

int start_wland(void)
{
	int ret;
	pid_t pid;
	char *wland_argv[] = { "/sbin/wland",
		                NULL
		              };

	stop_wland();

//	if( nvram_match("apwatchdog_enable", "0") )
//	    return 0;

        ret = _eval(wland_argv, NULL, 0, &pid);
        dprintf("done\n");
        return ret;
}



