
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <matrixssl_xface.h>

ssl_t *ssl;
sslKeys_t *keys;

void matrixssl_new_session(void)
{

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_new_session\n");
#endif
    ssl = matrixSslNewSession(keys, SSL_FLAGS_SERVER);
    msslAssert(ssl);
}

char * matrixssl_gets(FILE* fp, char* buf, int len)
{
  int   size=0;

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_gets %s\n", buf);
#endif

  if ((size=do_matrixssl_recv(fp, buf, len)) <= 0)
    return NULL;

  buf[size]=0;

  return buf;
}

int matrixssl_puts(FILE* fp, char* buf)
{
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_puts\n");
#endif

    if((void*)0 == buf || strlen(buf) <=0)
      return -1;

    return do_matrixssl_send(fp, buf, strlen(buf));
}

int matrixssl_printf(FILE* fp, char* fmt, char* inbuf)
{
  char buf[1024];
  int size=0;

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_printf\n");
#endif

  size = snprintf(buf, 1024, fmt, inbuf);

  return do_matrixssl_send(fp, buf, size);

}

int matrixssl_write(FILE* fp, char* buf , int size)
{
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_write\n");
#endif
  return do_matrixssl_send(fp, buf, size);
}

int matrixssl_read(FILE* fp, char* buf, int len)
{
  int size=0;
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_read size=%d\n",size);
#endif

  return do_matrixssl_recv(fp, buf, len);

}

int matrixssl_flush(FILE* fp)
{
  sslBuf_t out;
  char outbuf[SSL_MAX_RECORD_SIZE];
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_flush\n");
#endif

  out.size = SSL_MAX_RECORD_SIZE;
  out.buf = out.start = out.end = outbuf;

  matrixSslEncodeClosureAlert(ssl, &out);

  if (send((int)fp, out.buf, (int)(out.end - out.buf), 0) > 0){
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_flush - sent closure\n");
#endif
    return 0;
  }

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_flush - Error in closure\n");
#endif

  return -1;
}

int matrixssl_free_all(FILE* fp)
{
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_free_all\n");
#endif
  matrixSslDeleteSession(ssl);

  ssl = (void*)0;
  
  close((int)fp);

  return 0;
}

int do_matrixssl_recv(FILE* fp, char* buf, int bufsize)
{
  int rc = -1, ret=-1;
  sslBuf_t in, out;
  unsigned char error=0, alertLevel=0, alertDescription=0;

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_recv\n");
#endif

//  if(bufsize == (void*)0 || *bufsize <= 0){
#ifdef DEBUG_MATRIXSSL
//fprintf(stderr, "matrixssl_recv returing -1\n");
#endif
//    return -1;
//  }

//  memset(&in, 0x0, sizeof(sslBuf_t));
//  memset(&out, 0x0, sizeof(sslBuf_t));

  if(!ssl)
    matrixssl_new_session();
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_recv - before recv socket=%d\n", (int)fp);
#endif

  in.size = SSL_MAX_RECORD_SIZE;
  in.buf = in.start = in.end = malloc(SSL_MAX_RECORD_SIZE);
  memset(in.buf,0,SSL_MAX_RECORD_SIZE);

  if((void*)0 == in.buf)
    return -1;

  while(1)
  {

    ret = recv((int)fp, in.start, in.size, 0);

    if(ret <= 0){
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_recv - error in recv()\n");
#endif
      return -1;
    }

    in.end = in.start + ret;
    in.start = in.buf;

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_recv - matrixSslDecode size=%d\n", ret);
#endif

    memset(buf, 0, bufsize);
    out.buf = out.start = out.end = buf;
    out.size = bufsize;

    rc = matrixSslDecode(ssl, &in, &out, &error, &alertLevel, &alertDescription);

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_recv - after matrixSslDecode rc = %d\n", rc);
#endif

    switch (rc)
    {
/*
	Successfully decoded an application data record, and placed in out buf
*/
    case SSL_PROCESS_DATA:
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_recv - SSL_PROCESS_DATA rc=%d\n", rc);
#endif
      ret = out.size;
      goto matrixssl_recv_done;
/*
	We've decoded a record that requires a response
	The out buffer contains the encoded response that we must send back
	before decoding any more data
*/
    case SSL_SEND_RESPONSE:
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_recv - SSL_SEND_RESPONSE %d bytes\n", out.end - out.buf);
#endif
      send((int)fp, out.buf, out.end - out.start, 0);
      in.start = in.end = in.buf;
      in.size = SSL_MAX_RECORD_SIZE;
      continue;
/*
	We have a partial record, need to read more data from socket and
	try decoding again.
*/
      case SSL_PARTIAL:
        in.start = in.end;
	in.size = SSL_MAX_RECORD_SIZE - (in.start - in.buf);
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_recv - SSL_PARTIAL\n");
#endif

	continue;
/*
	There was an error decoding the data, or encoding the out buffer.
	There may be a response data in the out buffer, so try to send.
	We try a single hail-mary send of the data, and then close the socket.
	Since we're closing on error, we don't worry too much about a clean flush.
*/
    case SSL_ERROR:

#ifdef DEBUG_MATRIXSSL
if(rc == SSL_ERROR)
fprintf(stderr, "matrixssl_recv - SSL_ERROR rc=%d\n", rc);
#endif
/*
	We've decoded an alert.  The level and description passed into
	matrixSslDecode are filled in with the specifics.
*/
    case SSL_ALERT:
#ifdef DEBUG_MATRIXSSL
if(rc == SSL_ALERT)
fprintf(stderr, "matrixssl_recv - SSL_ALERT rc=%d\n", rc);
#endif
/*
	The out buffer is too small to fit the decoded or response
	data.  Increase the size of the buffer and call decode again
*/
    case SSL_FULL:
#ifdef DEBUG_MATRIXSSL
if(rc == SSL_FULL)
fprintf(stderr, "matrixssl_recv - SSL_FULL rc=%d\n", rc);
#endif

    default:

#ifdef DEBUG_MATRIXSSL
//if(rc != SSL_PARTIAL && rc != SSL_ERROR && rc != SSL_ALERT && rc != SSL_FULL)
fprintf(stderr, "matrixssl_recv - SSL_UNKOWN rc=%d\n", rc);
#endif

      matrixssl_flush(fp);
      ret=-1;
      goto matrixssl_recv_done;
  }

  }

matrixssl_recv_done:

  free(in.buf);

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "returing from matrixssl_recv %d bytes %s\n", out.end - out.start, buf);
#endif

  return ret;

}

int do_matrixssl_send(FILE* fp, char* buf, int size)
{
	sslBuf_t out;
	int bytes=-1;
	char outbuf[SSL_MAX_RECORD_SIZE];

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_send - %d bytes submitted %s\n", size, buf);
#endif

	if(size <= 0)
	  return -1;

  	memset(&out, 0x0, sizeof(sslBuf_t));

  	out.size = SSL_MAX_RECORD_SIZE;
  	out.buf = out.start = out.end = outbuf;

	if(matrixSslEncode(ssl, buf, size, &out) <0){
#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_send - error in matrixSslEncode, returning\n");
if(!ssl)
  fprintf(stderr, "What the fuck? ssl is NULL!!!\n");

#endif
	   return -1;
        }

	do
	{
	  out.start += bytes;
	  bytes = send((int)fp, out.start, (int)(out.end - out.start), 0);

	} while(bytes>0);

#ifdef DEBUG_MATRIXSSL
fprintf(stderr, "matrixssl_send returning - sent %d bytes\n", out.end-out.buf);
#endif

	return out.end - out.buf;
}
