
/*
 *********************************************************
 *   Copyright 2003, CyberTAN  Inc.  All Rights Reserved *
 *********************************************************

 This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
 the contents of this file may not be disclosed to third parties,
 copied or duplicated in any form without the prior written
 permission of CyberTAN Inc.

 This software should be used as a reference only, and it not
 intended for production use!


 THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

/*
 * Network services
 *
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 *
 * $Id: network.c,v 1.47 2004/01/06 10:41:05 honor Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <syslog.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if_arp.h>
#include <sys/sysinfo.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <code_pattern.h>
#include <wlutils.h>
#include <utils.h>
#include <rc.h>
#include <cy_conf.h>
#include <cymac.h>
#include <sveasoft.h>

#define IFUP (IFF_UP | IFF_RUNNING | IFF_BROADCAST | IFF_MULTICAST)
#define sin_addr(s) (((struct sockaddr_in *)(s))->sin_addr)

static int notify_nas(char *type, char *ifname, char *action);
static int notify_wdsnas(char *type, char *ifname, char *action);

void
start_lan(void)
{
	char *lan_ifname = strdup (nvram_safe_get("lan_ifname"));
	char *lan_ifnames = strdup (nvram_safe_get("lan_ifnames"));
	char name[80], *next;
	int s;
	struct ifreq ifr;
	char wl_face[10];

	dprintf("%s\n", lan_ifname);

	if ((s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
		return;

 	/* Bring up bridged interfaces */
	if (strncmp(lan_ifname, "br0", 3) == 0) {
		eval("brctl", "addbr", lan_ifname);
		eval("brctl", "setfd", lan_ifname, "0");
		if (nvram_match("router_disable", "1") || nvram_match("wl0_mode", "wet") || nvram_match("lan_stp", "0"))
			eval("brctl", "stp", lan_ifname, "dis");
		foreach(name, lan_ifnames, next) {
			dprintf("name=[%s] lan_ifname=[%s]\n", name, lan_ifname);

			if(check_hw_type() == BCM4702_CHIP)
				strcpy(wl_face, "eth2");
			else
				strcpy(wl_face, "eth1");

			/* Write wireless mac , add by honor 2003-10-27 */
			if(!strcmp(name, wl_face)){
				unsigned char mac[20]; ;

				if(nvram_match("wl_gmode", "-1")){
					dprintf("Disable wireless interface\n");
					continue;
				}

				dprintf("Write wireless mac\n");
				strcpy(mac, nvram_safe_get("et0macaddr"));
				MAC_ADD(mac);
				MAC_ADD(mac);	// The wireless mac equal lan mac add 2
				ether_atoe(mac, ifr.ifr_hwaddr.sa_data);
				ifr.ifr_hwaddr.sa_family = ARPHRD_ETHER;
				strncpy(ifr.ifr_name, wl_face, IFNAMSIZ);
				if (ioctl(s, SIOCSIFHWADDR, &ifr) == -1)
					perror("Write wireless mac fail : ");
				else
					dprintf("Write wireless mac successfully\n");
			}

			/* Bring up interface */
			if (ifconfig(name, IFUP, "0.0.0.0", NULL))
				continue;

			/* Set the logical bridge address to that of the first interface */
			strncpy(ifr.ifr_name, lan_ifname, IFNAMSIZ);
			if (ioctl(s, SIOCGIFHWADDR, &ifr) == 0 &&
			    memcmp(ifr.ifr_hwaddr.sa_data, "\0\0\0\0\0\0", ETHER_ADDR_LEN) == 0) {
				strncpy(ifr.ifr_name, name, IFNAMSIZ);
				if (ioctl(s, SIOCGIFHWADDR, &ifr) == 0) {
					strncpy(ifr.ifr_name, lan_ifname, IFNAMSIZ);
					ifr.ifr_hwaddr.sa_family = ARPHRD_ETHER;
					ioctl(s, SIOCSIFHWADDR, &ifr);
					dprintf("=====> set %s hwaddr to %s\n",lan_ifname,name);
				}
				else
					perror(lan_ifname);
			}
			else
				perror(lan_ifname);
			/* If not a wl i/f then simply add it to the bridge */
			if (eval("wlconf", name, "up"))
				eval("brctl", "addif", lan_ifname, name);
			else {
				/* get the instance number of the wl i/f */
				char wl_name[] = "wlXXXXXXXXXX_mode";
				int unit;
				wl_ioctl(name, WLC_GET_INSTANCE, &unit, sizeof(unit));
				snprintf(wl_name, sizeof(wl_name), "wl%d_mode", unit);
				/* Receive all multicast frames in WET mode */
				if (nvram_match(wl_name, "wet"))
					ifconfig(name, IFUP | IFF_ALLMULTI, NULL, NULL);
				/* Do not attach the main wl i/f if in wds mode */
				if (nvram_invmatch(wl_name, "wds"))
					eval("brctl", "addif", lan_ifname, name);
			}
		}
	}
	/* specific non-bridged lan i/f */
	else if (strcmp(lan_ifname, "")) {	// FIXME
		/* Bring up interface */
		ifconfig(lan_ifname, IFUP, NULL, NULL);
		/* config wireless i/f */
		if (!eval("wlconf", lan_ifname, "up")) {
			char tmp[100], prefix[] = "wanXXXXXXXXXX_";
			int unit;
			/* get the instance number of the wl i/f */
			wl_ioctl(lan_ifname, WLC_GET_INSTANCE, &unit, sizeof(unit));
			snprintf(prefix, sizeof(prefix), "wl%d_", unit);
			/* Receive all multicast frames in WET mode */
			if (nvram_match(strcat_r(prefix, "mode", tmp), "wet"))
				ifconfig(lan_ifname, IFUP | IFF_ALLMULTI, NULL, NULL);
		}
	}

	/* Bring up and configure LAN interface */
	ifconfig(lan_ifname, IFUP,
		 nvram_safe_get("lan_ipaddr"), nvram_safe_get("lan_netmask"));

	/* Get current LAN hardware address */
	strncpy(ifr.ifr_name, lan_ifname, IFNAMSIZ);
	if (ioctl(s, SIOCGIFHWADDR, &ifr) == 0) {
		char eabuf[32];
		nvram_set("lan_hwaddr", ether_etoa(ifr.ifr_hwaddr.sa_data, eabuf));
	}

	close(s);
	dprintf("%s %s\n",
		nvram_safe_get("lan_ipaddr"),
		nvram_safe_get("lan_netmask"));

	/* Sveasoft - create separate WDS bridge if enabled */
	if( nvram_match("wl_br1_enable", "1") ){
		eval("brctl", "addbr", "br1");
		eval("brctl", "setfd", "br1", "0");
		if (nvram_match("router_disable", "1"))/* || nvram_match("lan_stp", "0"))*/
			eval("brctl", "stp", "br1", "dis");

		/* Bring up and configure br1 interface */
		if(nvram_invmatch("wl_br1_ipaddr", "0.0.0.0") ){
		  	ifconfig("br1", IFUP, nvram_safe_get("wl_br1_ipaddr"), nvram_safe_get("wl_br1_netmask"));

			/* FORWARD and NAT from br1 to br0, protecting br0 */
			if (nvram_match("wl_br1_nat", "1")){
				eval("/usr/sbin/iptables -I FORWARD 1 -i br0 -o br1 -j ACCEPT");
				eval("/usr/sbin/iptables -I FORWARD 1 -o br0 -i br1 -m state --state ESTABLISHED,RELATED -j ACCEPT");
				eval("/usr/sbin/iptables -t nat -I POSTROUTING 1 -o br1 -j MASQUERADE");
			}

			/* FORWARD and NAT from br0 to br1, protecting br1 */
			else if (nvram_match("wl_br1_nat", "2")){
				eval("/usr/sbin/iptables -I FORWARD 1 -o br0 -i br1 -j ACCEPT");
				eval("/usr/sbin/iptables -I FORWARD 1 -i br0 -o br1 -m state --state ESTABLISHED,RELATED -j ACCEPT");
				eval("/usr/sbin/iptables -t nat -I POSTROUTING 1 -o br0 -j MASQUERADE");
			}
			notify_nas("lan", "br1", "up");
		}

	}

	/* Sveasoft - Bring up and configure wds interfaces */
	/* logic - if separate ip defined bring it up */
	/*         else if flagged for br1 and br1 is enabled add to br1 */
	/*         else add it to the br0 bridge */
	for(s=1;s<=MAX_WDS_DEVS;s++)
	{
		char wdsvarname[32] = {0};
		char wdsdevname[32] = {0};
		char *dev;

		sprintf(wdsvarname, "wl_wds%d_enable", s);
		sprintf(wdsdevname, "wl_wds%d_if", s);
		dev = nvram_safe_get(wdsdevname);

		eval("ifconfig", dev, "down");
		if(nvram_match(wdsvarname, "1") ){
			char wdsip[32] 	    = {0};
			char wdsbc[32] 	    = {0};
			char wdsnm[32] 	    = {0};

			snprintf(wdsip, 31,"wl_wds%d_ipaddr", s);
			snprintf(wdsnm, 31, "wl_wds%d_netmask", s);

			snprintf(wdsbc,31, "%s", nvram_safe_get(wdsip));
			get_broadcast(wdsbc, nvram_safe_get(wdsnm));
			eval("ifconfig", dev, nvram_safe_get(wdsip), "broadcast", wdsbc, "netmask", nvram_safe_get(wdsnm), "up");
			notify_wdsnas("lan", dev, "up");
		}
		else if(nvram_match(wdsvarname, "2") && nvram_match("wl_br1_enable", "1")){
			eval("ifconfig", dev, "up");
			eval("brctl", "addif", "br1", dev);
		}
		else if(nvram_match(wdsvarname, "3")){
			eval("ifconfig", dev, "up");
			eval("brctl", "addif", "br0", dev);
		}
	}


	/* Sveasoft - set default IP gateway defined */
	if( strcmp(nvram_safe_get("lan_gateway"), "0.0.0.0") )
	   eval("/usr/sbin/ip", "ro", "add", "default", "via", nvram_safe_get("lan_gateway"), "dev", "br0");

	/* Bring up local host interface */
	config_loopback();

	/* Set additional lan static routes if need */
	set_routes();

	//eval("wl", "radio", nvram_invmatch("wl_gmode", "-1") ? "on" : "off");

	/* Disable wireless will cause diag led blink, so we want to stop it. */
	if(check_hw_type() == BCM4712_CHIP){
		diag_led(DIAG, STOP_LED);
		/* Light or go out the DMZ led even if there is no wan ip. */
		if(nvram_invmatch("dmz_ipaddr", "")  && nvram_invmatch("dmz_ipaddr", "0"))
			diag_led(DMZ, START_LED);
		else
			diag_led(DMZ, STOP_LED);
	}

	// Sveasoft - cleanup of Cybertan code (is this really necessary, doesn't wlconf do this ???)
	eval("wl", "afterburner_override", nvram_safe_get("wl_afterburner_override"));

	free(lan_ifnames);
	free(lan_ifname);
}

void
stop_lan(void)
{
	char *lan_ifname = nvram_safe_get("lan_ifname");
	char name[80], *next;

	dprintf("%s\n", lan_ifname);
	/* Bring down LAN interface */
	ifconfig(lan_ifname, 0, NULL, NULL);

	/* Bring down bridged interfaces */
	if (strncmp(lan_ifname, "br", 2) == 0) {
		foreach(name, nvram_safe_get("lan_ifnames"), next) {
			eval("wlconf", name, "down");
			ifconfig(name, 0, NULL, NULL);
			eval("brctl", "delif", lan_ifname, name);
		}
		eval("brctl", "delbr", lan_ifname);
	}
	/* Bring down specific interface */
	else if (strcmp(lan_ifname, ""))
		eval("wlconf", lan_ifname, "down");
	dprintf("done\n");
}

#define sin_addr(s) (((struct sockaddr_in *)(s))->sin_addr)

void
start_wan(int status)
{

	char *wan_ifname = nvram_safe_get("wan_ifname");
	char *wan_proto = nvram_safe_get("wan_proto");
	int s;
	struct ifreq ifr;
	pid_t pid;

	dprintf("%s %s\n", wan_ifname, wan_proto);

	if (nvram_match("router_disable", "1") || strcmp(wan_proto, "disabled") == 0) {
		start_wan_done(wan_ifname);
		return;
	}

	if ((s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
		return;
	strncpy(ifr.ifr_name, wan_ifname, IFNAMSIZ);

	/* Set WAN hardware address before bringing interface up */
	memset(ifr.ifr_hwaddr.sa_data, 0, ETHER_ADDR_LEN);

        if(nvram_match("mac_clone_enable","1") &&
	   nvram_invmatch("def_hwaddr", "00:00:00:00:00:00") &&
	   nvram_invmatch("def_hwaddr", "")){
		ether_atoe(nvram_safe_get("def_hwaddr"), ifr.ifr_hwaddr.sa_data);
	}                                                              
	else{
		unsigned char mac[20];
		strcpy(mac, nvram_safe_get("et0macaddr"));
		MAC_ADD(mac);	// The wan mac equal lan mac add 1
		ether_atoe(mac, ifr.ifr_hwaddr.sa_data);
	}

	if (memcmp(ifr.ifr_hwaddr.sa_data, "\0\0\0\0\0\0", ETHER_ADDR_LEN)) {
		ifr.ifr_hwaddr.sa_family = ARPHRD_ETHER;
		ioctl(s, SIOCSIFHWADDR, &ifr);
	}

	/* Set MTU */
        init_mtu(wan_proto);    // add by honor 2002/12/27

        strcpy(ifr.ifr_name, nvram_safe_get("wan_ifname"));
        ifr.ifr_mtu =  atoi(nvram_safe_get("wan_mtu"));
        ioctl(s, SIOCSIFMTU, &ifr);

	/* Bring up WAN interface */
	ifconfig(wan_ifname, IFUP, NULL, NULL);
	/* Configure WAN interface */
	if (strcmp(wan_proto, "pppoe") == 0) {
		char username[80], passwd[80];
		char idletime[20], retry_num[20];

		snprintf(idletime, sizeof(idletime), "%d", atoi(nvram_safe_get("ppp_idletime"))*60);
		snprintf(retry_num, sizeof(retry_num), "%d", (atoi(nvram_safe_get("ppp_redialperiod"))/5)-1);

		if(nvram_match("aol_block_traffic","0")){
	                snprintf(username, sizeof(username), "%s", nvram_safe_get("ppp_username"));
	                snprintf(passwd, sizeof(passwd), "%s", nvram_safe_get("ppp_passwd"));
	        }
	        else{
	                if(!strcmp(nvram_safe_get("aol_username"),"")){
	                        snprintf(username, sizeof(username), "%s", nvram_safe_get("ppp_username"));
	                        snprintf(passwd, sizeof(passwd), "%s", nvram_safe_get("ppp_passwd"));
	                }
	                else{
	                        snprintf(username, sizeof(username), "%s", nvram_safe_get("aol_username"));
	                        snprintf(passwd, sizeof(passwd), "%s", nvram_safe_get("aol_passwd"));
	                }
	        }

		char *pppoe_argv[] = { "pppoecd",
				       wan_ifname,
				       "-u", username,
				       "-p", passwd,
				       "-r", atoi(nvram_safe_get("wan_mru")) > 0 ? nvram_safe_get("wan_mru") : nvram_safe_get("wan_mtu"),
				       "-t", nvram_safe_get("wan_mtu"),
				       "-i", nvram_match("ppp_demand", "1") ? idletime : "0",
				       "-I", "30",      // Send an LCP echo-request frame to the server every 30 seconds
	                               "-T", "3",       // pppd will presume the server to be dead if 5 LCP echo-requests are sent without receiving a valid LCP echo-reply
				       "-N", retry_num,	// To avoid kill pppd when pppd has been connecting.
				       NULL, NULL,	/* pppoe_service */
				       NULL, NULL,	/* pppoe_ac */
				       NULL,		/* pppoe_keepalive */
				       NULL, NULL,	/* Assign local IP */
				       NULL
		}, **arg;
		int timeout = 5;

		/* Add optional arguments */
		for (arg = pppoe_argv; *arg; arg++);
		if (nvram_invmatch("ppp_service", "")) {
			*arg++ = "-s";
			*arg++ = nvram_safe_get("ppp_service");
		}
		if (nvram_invmatch("ppp_ac", "")) {
			*arg++ = "-a";
			*arg++ = nvram_safe_get("ppp_ac");
		}
		if (nvram_match("ppp_static", "1")) {
			*arg++ = "-L";
			*arg++ = nvram_safe_get("ppp_static_ip");
		}
		//if (nvram_match("pppoe_demand", "1") || nvram_match("pppoe_keepalive", "1"))
			*arg++ = "-k";

		mkdir("/tmp/ppp", 0777);
		symlink("/sbin/rc", "/tmp/ppp/ip-up");
		symlink("/sbin/rc", "/tmp/ppp/ip-down");
		unlink("/tmp/ppp/log");

		stop_dhcpc();
		stop_pptp();

		_eval(pppoe_argv, NULL, 0, &pid);


		/* Pretend that the WAN interface is up */
		if (nvram_match("ppp_demand", "1")) {
			/* Wait for ppp0 to be created */
			while (ifconfig("ppp0", IFUP, NULL, NULL) && timeout--)
				sleep(1);
			strncpy(ifr.ifr_name, "ppp0", IFNAMSIZ);

			/* Set temporary IP address */
			timeout = 3;
			while (ioctl(s, SIOCGIFADDR, &ifr) && timeout--){
				perror("ppp0");
				printf("Wait ppp inteface to init (1) ...\n");
				sleep(1);
			};
			nvram_set("wan_ipaddr", inet_ntoa(sin_addr(&ifr.ifr_addr)));
			nvram_set("wan_netmask", "255.255.255.255");

			/* Set temporary P-t-P address */
			timeout = 3;
			while (ioctl(s, SIOCGIFDSTADDR, &ifr) && timeout--){
				perror("ppp0");
				printf("Wait ppp inteface to init (2) ...\n");
				sleep(1);
			}
			nvram_set("wan_gateway", inet_ntoa(sin_addr(&ifr.ifr_dstaddr)));

			start_wan_done("ppp0");

			// if user press Connect" button from web, we must force to dial
			if(nvram_match("action_service","start_pppoe")){
				sleep(3);
				force_to_dial();
				nvram_set("action_service","");
			}
		}
		else{
			if(status != REDIAL){
				start_redial();
			}
		}

	} else if (strcmp(wan_proto, "dhcp") == 0) {
		char *wan_hostname = nvram_get("wan_hostname");
		char *dhcp_argv[] = { "udhcpc",
				      "-i", wan_ifname,
				      "-p", "/var/run/udhcpc.pid",
				      "-s", "/tmp/udhcpc",
				      wan_hostname && *wan_hostname ? "-H" : NULL,
				      wan_hostname && *wan_hostname ? wan_hostname : NULL,
				      NULL
		};

		symlink("/sbin/rc", "/tmp/udhcpc");

		nvram_set("wan_get_dns","");

		_eval(dhcp_argv, NULL, 0, &pid);

	} else if (strcmp(wan_proto, "pptp") == 0) {
		start_pptp(status);

	} else if (strcmp(wan_proto, "heartbeat") == 0) {
		char *wan_hostname = nvram_get("wan_hostname");
		char *dhcp_argv[] = { "udhcpc",
				      "-i", wan_ifname,
				      "-p", "/var/run/udhcpc.pid",
				      "-s", "/tmp/udhcpc",
				      wan_hostname && *wan_hostname ? "-H" : NULL,
				      wan_hostname && *wan_hostname ? wan_hostname : NULL,
				      NULL
		};

		symlink("/sbin/rc", "/tmp/udhcpc");

		nvram_set("wan_get_dns","");

		_eval(dhcp_argv, NULL, 0, &pid);

	} else {
		ifconfig(wan_ifname, IFUP,
			 nvram_safe_get("wan_ipaddr"), nvram_safe_get("wan_netmask"));
		start_wan_done(wan_ifname);
	}

	/* Get current WAN hardware address */
	strncpy(ifr.ifr_name, wan_ifname, IFNAMSIZ);
	if (ioctl(s, SIOCGIFHWADDR, &ifr) == 0) {
		char eabuf[32];
		nvram_set("wan_hwaddr", ether_etoa(ifr.ifr_hwaddr.sa_data, eabuf));
	}

	close(s);

	dprintf("%s %s\n",
		nvram_safe_get("wan_ipaddr"),
		nvram_safe_get("wan_netmask"));
}


void
start_wan_service(void)
{
	//stop_ntp();
	stop_ddns();
	//start_ntp();
	start_ddns();
}


void
start_wan_done(char *wan_ifname)
{
	int timeout = 5;
	dprintf("%s %s\n", wan_ifname, nvram_safe_get("wan_proto"));

	/* Delete all default routes */
	while (route_del(wan_ifname, 0, NULL, NULL, NULL) == 0);

	/* Set default route to gateway if specified */
	while (strcmp(nvram_safe_get("wan_proto"), "disabled") && route_add(wan_ifname, 0, "0.0.0.0", nvram_safe_get("wan_gateway"), "0.0.0.0") && timeout-- ){
		if (nvram_match("wan_proto", "pppoe") && nvram_match("ppp_demand", "1")) {
			printf("Wait ppp interface to init (3) ...\n");
			sleep(1);
		}
	}


	/* save dns to resolv.conf */
        dns_to_resolv();

	/* Restart DHCP server */
	stop_dhcpd();
	start_dhcpd();

	/* Restart DNS proxy */
	stop_dns();
	start_dns();

	/* Start firewall */
	start_firewall();

	/* Set additional wan static routes if need */
	set_routes();
	if(nvram_match("wan_proto","pppoe") || nvram_match("wan_proto","pptp")){
                if(nvram_match("ppp_demand","1")){      // ntp and ddns will trigger DOD, so we must stop them when wan is unavaile.
			FILE *fp;
                        if ((fp = fopen("/tmp/ppp/link", "r"))) {
                                start_wan_service();
                                fclose(fp);
                        }
                }
		else{
			start_wan_service();
		}
        }
        else{
               start_wan_service();
        }
	stop_process_monitor();
	start_process_monitor();

	stop_zebra();
        start_zebra();

        stop_upnp();
        start_upnp();

	stop_cron();
	start_cron();

	// QoS must be restarted *after* pppoe is up if using the pppoe WAN ppp0 port
	stop_wshaper();
	start_wshaper();

	dprintf("done\n");
}

void
stop_wan(void)
{
	char *wan_ifname = nvram_safe_get("wan_ifname");

	dprintf("%s %s\n", wan_ifname, nvram_safe_get("wan_proto"));


	/* Stop firewall */
	stop_firewall();

	/* Kill any WAN client daemons or callbacks */
	stop_pppoe();
	stop_dhcpc();
	stop_heartbeat();
	stop_pptp();
	stop_ntp();
	stop_redial();
	nvram_set("wan_get_dns", "");

	/* Bring down WAN interfaces */
	ifconfig(wan_ifname, 0, NULL, NULL);

	dprintf("done\n");
}

int
set_routes(void)
{
	char word[80], *tmp;
	char *ipaddr, *netmask, *gateway, *metric, *ifname;

	foreach(word, nvram_safe_get("static_route"), tmp) {
		netmask = word;
		ipaddr = strsep(&netmask, ":");
		if (!ipaddr || !netmask)
			continue;
		gateway = netmask;
		netmask = strsep(&gateway, ":");
		if (!netmask || !gateway)
			continue;
		metric = gateway;
		gateway = strsep(&metric, ":");
		if (!gateway || !metric)
			continue;
		ifname = metric;
		metric = strsep(&ifname, ":");
		if (!metric || !ifname)
			continue;

		route_add(ifname, atoi(metric) + 1, ipaddr, gateway, netmask);
	}

	return 0;
}

int
del_routes(char *route)
{
	char word[80], *tmp;
	char *ipaddr, *netmask, *gateway, *metric, *ifname;

	foreach(word, route, tmp) {
		netmask = word;
		ipaddr = strsep(&netmask, ":");
		if (!ipaddr || !netmask)
			continue;
		gateway = netmask;
		netmask = strsep(&gateway, ":");
		if (!netmask || !gateway)
			continue;
		metric = gateway;
		gateway = strsep(&metric, ":");
		if (!gateway || !metric)
			continue;
		ifname = metric;
		metric = strsep(&ifname, ":");
		if (!metric || !ifname)
			continue;

		route_del(ifname, atoi(metric) + 1, ipaddr, gateway, netmask);
	}

	return 0;
}

static int
notify_nas(char *type, char *ifname, char *action)
{
	char *argv[] = {"nas4not", type, ifname, action, NULL};
	char *str = NULL;
	int pid;
	int retries = 10;
	char tmp[100], prefix[] = "wlXXXXXXXXXX_";
	int unit;
	wl_ioctl(ifname, WLC_GET_INSTANCE, &unit, sizeof(unit));
	snprintf(prefix, sizeof(prefix), "wl%d_", unit);
	if (nvram_match(strcat_r(prefix, "auth_mode", tmp), "disabled"))
		return 0;
	while (retries -- > 0 && !(str = file2str("/tmp/nas.lan.pid")))
		sleep(1);
	if (str) {
		free(str);
		return _eval(argv, ">/dev/console", 0, &pid);
	}
	return -1;
}

static int
notify_wdsnas(char *type, char *ifname, char *action)
{
	char *argv[] = {"nas4wds", type, ifname, action, NULL};
	char *str = NULL;
	int pid;
	int retries = 10;
	int unit;

	if (nvram_match("wl0_auth_mode", "disabled") || !nvram_invmatch("nas_enable", "0"))
		return 0;

	while (retries -- > 0 && !(str = file2str("/tmp/nas.lan.pid")))
		sleep(1);
	if (str) {
		free(str);
		return _eval(argv, ">/dev/console", 0, &pid);
	}
	return -1;
}


int
hotplug_net(void)
{
	char *lan_ifname = nvram_safe_get("lan_ifname");
	char *interface, *action;

	if (!(interface = getenv("INTERFACE")) ||
	    !(action = getenv("ACTION")))
		return EINVAL;

//	if (strncmp(interface, "wds", 3))
//		return 0;

	if (!strcmp(action, "register")) {
		/* Bring up the interface and add to the bridge */
		ifconfig(interface, IFUP, NULL, NULL);

		/* Bridge WDS interfaces */
//		if (!strncmp(lan_ifname, "br", 2) &&
//		    eval("brctl", "addif", lan_ifname, interface))
//		    return 0;

		/* Notify NAS of adding the interface */
		notify_nas("lan", interface, "up");
	}

	return 0;
}

int
init_mtu(char *wan_proto){
	if (strcmp(wan_proto, "pppoe") == 0) {		// 576 < mtu < 1454(linksys japan) | 1492(other)
                if(nvram_match("mtu_enable","0")) {	// Auto
                        nvram_set("mtu_enable","1");
#if COUNTRY == JAPAN
                        nvram_set("wan_mtu","1454");	// set max value
#else
                        nvram_set("wan_mtu","1492");	// set max value
#endif


                }
                else{					// Manual
#if COUNTRY == JAPAN
                        if(atoi(nvram_safe_get("wan_mtu")) > 1454){
                                nvram_set("wan_mtu","1454");
			}
#else
                        if(atoi(nvram_safe_get("wan_mtu")) > 1492){
                                nvram_set("wan_mtu","1492");
			}
#endif
                        if(atoi(nvram_safe_get("wan_mtu")) < 576){
                                nvram_set("wan_mtu","576");
			}
                }
	}
	else if (strcmp(wan_proto, "pptp") == 0) {	// 1200 < mtu < 1400 (1460)
                if(nvram_match("mtu_enable","0")) {	// Auto
                        nvram_set("mtu_enable","1");
                        nvram_set("wan_mtu","1460");	// set max value (linksys request to set to 1460) 2003/06/23
                }
                else{					// Manual
                        if(atoi(nvram_safe_get("wan_mtu")) > 1460){
                                nvram_set("wan_mtu","1460");
			}
                        if(atoi(nvram_safe_get("wan_mtu")) < 1200){
                                nvram_set("wan_mtu","1200");
			}
                }
	}
	else{						// 576 < mtu < 1500
                if(nvram_match("mtu_enable","0")) {	// Auto
                        nvram_set("wan_mtu","1500");	// set max value
		}
		else{					// Manual
                        if(atoi(nvram_safe_get("wan_mtu")) > 1500){
                                nvram_set("wan_mtu","1500");
			}
                        if(atoi(nvram_safe_get("wan_mtu")) < 576){
                                nvram_set("wan_mtu","576");
			}
		}
	}
	return 0;
}


/* Trigger Connect On Demand */
int
force_to_dial(void){
	int ret = 0;

	char *ping_argv[] = { "ping",
			     "-c", "5",
			     "1.1.1.1",
			     NULL
	};
	sleep(1);
	_eval(ping_argv, NULL, 3, NULL);
	
	return ret;
}
