/*
 * ppp scripts
 *
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 * 
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 *
 * $Id: ppp.c,v 1.14 2003/12/17 12:49:25 honor Exp $
 */

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <net/route.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <rc.h>

#include <code_pattern.h>
#include <cy_conf.h>
#include <utils.h>

#define IFUP (IFF_UP | IFF_RUNNING | IFF_BROADCAST | IFF_MULTICAST)

/*
 * Called when link comes up
 */
int
ipup_main(int argc, char **argv)
{
	FILE *fp;
	char *wan_ifname = safe_getenv("IFNAME");
	char *wan_proto = nvram_safe_get("wan_proto");
	char *value;
	char buf[256];

	dprintf("%s\n", argv[0]);

	eval("killall", "-9", "listen");

	if(check_action() != ACT_IDLE)
                return -1;

	/* ipup will receive bellow six arguments */
	/* interface-name  tty-device  speed  local-IP-address   remote-IP-address ipparam */
	/* Touch connection file */
	if (!(fp = fopen("/tmp/ppp/link", "a"))) {
		perror("/tmp/ppp/link");
		return errno;
	}
	fprintf(fp, "%s", argv[1]);
	fclose(fp);

	if(nvram_match("wan_proto","pppoe"))
	    nvram_set("pppoe_ifname",argv[1]);

	if ((value = getenv("IPLOCAL"))) {
		ifconfig(wan_ifname, IFUP,
			 value, "255.255.255.255");
		if(!strcmp(wan_proto, "pppoe")){
                        nvram_set("wan_ipaddr_buf", nvram_safe_get("wan_ipaddr"));	//Store last ip address
                        nvram_set("wan_ipaddr", value);
                        nvram_set("wan_netmask", "255.255.255.255");
                }
                else if(!strcmp(wan_proto, "pptp")){
                        nvram_set("wan_ipaddr_buf", nvram_safe_get("pptp_get_ip"));	// Store last ip address
                        nvram_set("pptp_get_ip", value);
                }
	}

        if ((value = getenv("IPREMOTE")))
		nvram_set("wan_gateway", value);
	strcpy(buf, "");
	if (getenv("DNS1"))
		sprintf(buf, "%s", getenv("DNS1"));
	if (getenv("DNS2"))
		sprintf(buf + strlen(buf), "%s%s", strlen(buf) ? " " : "", getenv("DNS2"));
	nvram_set("wan_get_dns", buf);
	
        if ((value = getenv("AC_NAME")))
		nvram_set("ppp_get_ac", value);
        if ((value = getenv("SRV_NAME")))
		nvram_set("ppp_get_srv", value);

	start_wan_done(wan_ifname);

	dprintf("done\n");
	return 0;
}

/*
 * Called when link goes down
 */
int
ipdown_main(int argc, char **argv)
{
	if(check_action() != ACT_IDLE)
                return -1;
	
	stop_ddns();    // Aviod to trigger DOD
        stop_ntp();
	unlink("/tmp/ppp/link");

	nvram_set("pppoe_ifname","");	

	if(nvram_match("ppp_demand", "1") && nvram_match("wan_proto", "pptp")){
		eval("killall", "-9", "listen");
		eval("listen", nvram_safe_get("lan_ifname"));
	}	
		
	return 1;
}
