
/*
 *********************************************************
 *   Copyright 2003, CyberTAN  Inc.  All Rights Reserved *
 *********************************************************

 This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
 the contents of this file may not be disclosed to third parties,
 copied or duplicated in any form without the prior written
 permission of CyberTAN Inc.

 This software should be used as a reference only, and it not
 intended for production use!


 THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <broadcom.h>
#include <cy_conf.h>
#include <sveasoft.h>


/* Example:
 * name:[on|off]:[tcp|udp|both]:8000:80>100
 */

void
validate_forward_proto(webs_t wp, char *value, struct variable *v)
{
	int i, error = 0;
	char buf[1000] = "", *cur = buf;
	struct variable forward_proto_variables[] = {
		{ longname: "Port Forward Application name", argv: ARGV("12") },
		{ longname: "Port Forward from WAN Port", argv: ARGV("0", "65535") },
		{ longname: "Port Forward to LAN Port", argv: ARGV("0", "65535") },
		{ longname: "Port Forward Protocol",NULL },
	}, *which;

	for (i = 0; i < FORWARDING_NUM; i++) {

		char forward_name[] = "nameXXX";
                char forward_from[] = "fromXXX";
                char forward_to[] = "toXXX";
                char forward_ip[] = "ipXXX";
                char forward_tcp[] = "tcpXXX";	// for checkbox
                char forward_udp[] = "udpXXX";	// for checkbox
                char forward_pro[] = "proXXX";	// for select, cisco style UI
                char forward_enable[] = "enableXXX";
                char *name="", new_name[200]="", *from="", *to="", *ip="", *tcp="", *udp="", *enable="", proto[10], *pro="";

                snprintf(forward_name, sizeof(forward_name), "name%d", i);
                snprintf(forward_from, sizeof(forward_from), "from%d", i);
                snprintf(forward_to, sizeof(forward_to), "to%d", i);
                snprintf(forward_ip, sizeof(forward_ip), "ip%d", i);
                snprintf(forward_tcp, sizeof(forward_tcp), "tcp%d", i);
                snprintf(forward_udp, sizeof(forward_udp), "udp%d", i);
                snprintf(forward_enable, sizeof(forward_enable), "enable%d", i);
                snprintf(forward_pro, sizeof(forward_pro), "pro%d", i);

		name = websGetVar(wp, forward_name, "");
		from = websGetVar(wp, forward_from, "0");
		to = websGetVar(wp, forward_to, "0");
		ip = websGetVar(wp, forward_ip, "0");
		tcp = websGetVar(wp, forward_tcp, NULL);	// for checkbox
		udp = websGetVar(wp, forward_udp, NULL);	// for checkbox
		pro = websGetVar(wp, forward_pro, NULL);	// for select option
		enable = websGetVar(wp, forward_enable, "off");

		which = &forward_proto_variables[0];


		if(!*from && !*to && !*ip)
			continue;
		if(!strcmp(ip,"0") || !strcmp(ip,""))
			continue;
		if((!strcmp(from,"0") || !strcmp(from,"")) &&
		   (!strcmp(to,"0") || !strcmp(to,"")) && 
		   (!strcmp(ip,"0") || !strcmp(ip,"")))	{
			continue;
		}

		/* check name */
		if(strcmp(name,"")){
			if(!valid_name(wp, name, &which[0])){
				error_value = 1;
				continue;
			}
			else{
				filter_name(name, new_name, sizeof(new_name), SET);
			}
		}

		if (!strcmp(from,"")) from = to;
		if (!strcmp(to,"")) to = from;

		if(atoi(from) > atoi(to)){
			SWAP(from, to);
		}

		if(!valid_range(wp, from, &which[1]) || !valid_range(wp, to, &which[2])){
			error_value = 1;
			continue;
		}


		if(pro){	// use select option
			strcpy(proto, pro);
		}
		else{		// use checkbox
			if(tcp && udp)
				strcpy(proto,"both");
			else if(tcp && !udp)
				strcpy(proto,"tcp");
			else if(!tcp && udp)
				strcpy(proto,"udp");
		}
		/* check ip address */

		if(!*ip){
			error = 1;
		//	websWrite(wp, "Invalid <b>%s</b> : must specify a ip<br>",which[4].longname);
                        continue;
		}

		/* Sveasoft add - new format allows full IP address */
		if (sv_valid_ipaddr(ip)){
			cur += snprintf(cur, buf + sizeof(buf) - cur, "%s%s:%s:%s:%d:%d>%s",
					cur == buf ? "" : " ", new_name, enable, proto, atoi(from), atoi(to), ip);
		cprintf("done\n");
		}
		/* Sveasoft - for backwords compatability allow single number */
		else if (sv_valid_range(ip, 0, 254)){
			char fullip[16]={0};
			int  f_ip[4];

		cprintf("setting forward for single number...");
			sscanf(nvram_safe_get("lan_ipaddr"),"%d.%d.%d.%d",&f_ip[0],&f_ip[1],&f_ip[2],&f_ip[3]);
			snprintf(fullip, 15, "%d.%d.%d.%d",f_ip[0],f_ip[1],f_ip[2],atoi(ip));
			cur += snprintf(cur, buf + sizeof(buf) - cur, "%s%s:%s:%s:%d:%d>%s",
					cur == buf ? "" : " ", new_name, enable, proto, atoi(from), atoi(to), fullip);
		cprintf("done\n");

		}
		else{
			error = 1;
			continue;
		}

	}
	if(!error)
		nvram_set(v->name, buf);
}




/* Example:
 * name:[on|off]:[tcp|udp|both]:8000:80>100
 */

int
ej_port_forward_table(int eid, webs_t wp, int argc, char_t **argv)
{
	char *type;
	int  which;

	static char word[256];
	char *next, *wordlist;
	char *name, *from, *to, *proto, *ip ,*enable;
	static char new_name[200];
	int temp;

        if (ejArgs(argc, argv, "%s %d", &type, &which) < 2) {
             websError(wp, 400, "Insufficient args\n");
             return -1;
        }

	wordlist = nvram_safe_get("forward_port");
	temp = which;

	foreach(word, wordlist, next) {
		if (which-- == 0) {
			enable = word;
			name = strsep(&enable, ":");
		 	if (!name || !enable)
                                continue;
			proto = enable;
			enable = strsep(&proto, ":");
			if (!enable || !proto)
				continue;
			from = proto;
			proto = strsep(&from, ":");
			if (!proto || !from)
				continue;
			to = from;
			from = strsep(&to, ":");
			if (!to || !from)
				continue;
			ip = to;
			to = strsep(&ip, ">");
			if (!ip || !to)
				continue;

			if (!strcmp(type, "name")){
				filter_name(name, new_name, sizeof(new_name), GET);
				return websWrite(wp,"%s",new_name);
			}
			else if (!strcmp(type, "from"))
				return websWrite(wp,"%s",from);
			else if (!strcmp(type, "to"))
				return websWrite(wp,"%s",to);
			else if (!strcmp(type, "tcp")){		// use checkbox
				if(!strcmp(proto, "udp"))
					return websWrite(wp,"");
				else
					return websWrite(wp,"checked");
			}
			else if (!strcmp(type, "udp")){		//use checkbox
				if(!strcmp(proto, "tcp"))
					return websWrite(wp,"");
				else
					return websWrite(wp,"checked");
			}
			else if (!strcmp(type, "sel_tcp")){		// use select
				if(!strcmp(proto, "udp"))
					return websWrite(wp,"");
				else
					return websWrite(wp,"selected");
			}
			else if (!strcmp(type, "sel_udp")){		//use select
				if(!strcmp(proto, "tcp"))
					return websWrite(wp,"");
				else
					return websWrite(wp,"selected");
			}
			else if (!strcmp(type, "sel_both")){		//use select
				if(!strcmp(proto, "both"))
					return websWrite(wp,"selected");
				else
					return websWrite(wp,"");
			}
			else if (!strcmp(type, "ip"))
				return websWrite(wp,"%s",ip);
			else if (!strcmp(type, "enable")){
				if(!strcmp(enable, "on"))
					return websWrite(wp,"checked");
				else
					return websWrite(wp,"");
			}
		}
	}
 	if( !strcmp(type, "from") || !strcmp(type, "to") || !strcmp(type, "ip"))
		return websWrite(wp,"0");
	else if (!strcmp(type, "sel_both"))
		return websWrite(wp,"selected");
	else
		return websWrite(wp,"");
}




