/*
 *********************************************************
 *   Copyright 2004 Sveasoft AB  All Rights Reserved *
 *********************************************************

 This is PUBLISHED SOURCE CODE of Sveasoft AB
 the contents of this file may be disclosed to third parties,
 copied or duplicated in any form without the prior written
 permission of Sveasoft AB

 This software should be used as a reference only, and it not
 intended for production use!

 THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <broadcom.h>
#include <cymac.h>
#include <wlutils.h>
#include <sveasoft.h>


void validate_wds(webs_t wp, char *value, struct variable *v)
{
	int h,i, devcount=2;
	struct variable wds_variables[] = {
		{ longname: "WDS Mac", argv: NULL },
		{ longname: "WDS IP Address", argv: NULL },
		{ longname: "WDS Subnet Mask", argv: NULL },
		{ longname: "WDS Gateway", argv: NULL },
	};

	char* val=NULL;
	char  wds[32]="";
	char  wdsif_var[32]="";
	char  enabled_var[32];
	char  hwaddr_var[32]="";
	char  ipaddr_var[32]="";
	char  netmask_var[32]="";
	char  hwaddr[18]="";
	char  ipaddr[16]="";
	char  netmask[16]="";
	char  wds_if[32]={0};
	char  wds_list[199]="";


	nvram_set("wl0_wds", "");
	snprintf(wds, 31, "wl_br1");
	snprintf(enabled_var, 31, "%s_enable", wds);

	/* validate separate br1 bridge params */
	if(nvram_match(enabled_var, "1")){

		memset(ipaddr, 0, sizeof(ipaddr));
		memset(netmask, 0, sizeof(netmask));

		// disable until validated
 		nvram_set(enabled_var, "0");

		// subnet params validation
     		for(i=0 ; i<4 ; i++)
	  	{

                	snprintf(ipaddr_var, 31,"%s_%s%d", wds, "ipaddr",i);
                	val = websGetVar(wp, ipaddr_var, NULL);
                	if(val){
                        	strcat(ipaddr,val);
                        	if(i<3) strcat(ipaddr,".");
                	}
                	else
                   	  break;

	        	snprintf(netmask_var,31,"%s_%s%d", wds, "netmask",i);
                	val = websGetVar(wp, netmask_var , NULL);
                	if(val){
                        	strcat(netmask,val);

                        	if(i<3)
			  		strcat(netmask,".");
                	}
                	else
                   	  break;
	  	}

	  	if (!valid_ipaddr(wp, ipaddr, &wds_variables[1]) ||
	      	    !valid_netmask(wp, netmask, &wds_variables[2]))
	      		return;

	  	snprintf(ipaddr_var, 31,"%s_%s", wds, "ipaddr");
	  	snprintf(netmask_var, 31,"%s_%s", wds, "netmask");

          	nvram_set(enabled_var, "1");
	  	nvram_set(ipaddr_var, ipaddr);
	  	nvram_set(netmask_var, netmask);
       }
       else
       	 nvram_set(enabled_var, "0");


	for(h=1; h<=MAX_WDS_DEVS;h++)
	{
	  memset(hwaddr, 0, sizeof(hwaddr));
	  snprintf(wds, 31, "wl_wds%d", h);
	  snprintf(enabled_var, 31, "%s_enable", wds);

          for(i=0 ; i<6 ; i++)
	  {

                snprintf(hwaddr_var, 31,"%s_%s%d", wds, "hwaddr",i);
                val = websGetVar(wp, hwaddr_var, NULL);

                if(val){
                        strcat(hwaddr,val);
                        if(i<5) strcat(hwaddr,":");
                }
	  }

	  if(!valid_hwaddr(wp, hwaddr, &wds_variables[0])){
	    return;
	  }

	  snprintf(hwaddr_var, 31,"%s_%s", wds, "hwaddr");
	  nvram_set(hwaddr_var, hwaddr);

	  if(strcmp(hwaddr, "00:00:00:00:00:00") && nvram_invmatch(enabled_var, "0")){
	    snprintf(wds_list, 199, "%s %s", wds_list, hwaddr);
  	  }

	  if(nvram_match(enabled_var, "1")){

		memset(ipaddr, 0, sizeof(ipaddr));
		memset(netmask, 0, sizeof(netmask));

		// disable until validated
 		nvram_set(enabled_var, "0");

		// subnet params validation
     		for(i=0 ; i<4 ; i++)
	  	{

                	snprintf(ipaddr_var, 31,"%s_%s%d", wds, "ipaddr",i);
                	val = websGetVar(wp, ipaddr_var, NULL);
                	if(val){
                        	strcat(ipaddr,val);
                        	if(i<3) strcat(ipaddr,".");
                	}
                	else
                   	  break;

	        	snprintf(netmask_var,31,"%s_%s%d", wds, "netmask",i);
                	val = websGetVar(wp, netmask_var , NULL);
                	if(val){
                        	strcat(netmask,val);

                        	if(i<3)
			  		strcat(netmask,".");
                	}
                	else
                   	  break;
	  	}

	  	if (!valid_ipaddr(wp, ipaddr, &wds_variables[1]) ||
	      	    !valid_netmask(wp, netmask, &wds_variables[2]))
	      		return;

	  	snprintf(ipaddr_var, 31,"%s_%s", wds, "ipaddr");
	  	snprintf(netmask_var, 31,"%s_%s", wds, "netmask");

          	nvram_set(enabled_var, "1");
	  	nvram_set(ipaddr_var, ipaddr);
	  	nvram_set(netmask_var, netmask);

	  }

	  /* keep the wds devices in sync w enabled entries */
	  snprintf(wdsif_var, 31, "%s_if", wds);
	  if(!nvram_match(enabled_var, "0")){
	  	snprintf(wds_if, 31, "wds0.%d", devcount++);
		nvram_set(wdsif_var, wds_if);
	  }
	  else
	   	nvram_unset(wdsif_var);

	}

       nvram_set("wl0_wds", wds_list);
}

int ej_get_wds_mac(int eid, webs_t wp, int argc, char_t **argv)
{
	int mac=-1, wds_idx=-1, mac_idx=-1, ret=0;
	char *c, wds_var[32]="";


	if (ejArgs(argc, argv, "%d %d", &wds_idx, &mac_idx) < 2) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	else if(wds_idx < 1 || wds_idx > MAX_WDS_DEVS)
	  return -1;
	else if(mac_idx < 0 || mac_idx > 5)
	  return -1;

	snprintf(wds_var, 31, "wl_wds%d_hwaddr", wds_idx);

	c = nvram_safe_get(wds_var);

	if(c){
		mac = get_single_mac(c, mac_idx);
		ret += websWrite(wp, "%02X", mac);
	}
	else
		ret += websWrite(wp, "00");

	return ret;

}

int ej_get_wds_ip(int eid, webs_t wp, int argc, char_t **argv)
{
	int ip=-1, wds_idx=-1, ip_idx=-1, ret=0;
	char *c, wds_var[32]="";


	if (ejArgs(argc, argv, "%d %d", &wds_idx, &ip_idx) < 2) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	else if(wds_idx < 1 || wds_idx > MAX_WDS_DEVS)
	  return -1;
	else if(ip_idx < 0 || ip_idx > 3)
	  return -1;

	snprintf(wds_var, 31, "wl_wds%d_ipaddr", wds_idx);

	c = nvram_safe_get(wds_var);

	if(c){
		ip = get_single_ip(c, ip_idx);
		ret += websWrite(wp, "%d", ip);
	}
	else
		ret += websWrite(wp, "0");

	return ret;

}

int ej_get_wds_netmask(int eid, webs_t wp, int argc, char_t **argv)
{
	int nm=-1, wds_idx=-1, nm_idx=-1, ret=0;
	char *c, wds_var[32]="";


	if (ejArgs(argc, argv, "%d %d", &wds_idx, &nm_idx) < 2) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	else if(wds_idx < 1 || wds_idx > 6)
	  return -1;
	else if(nm_idx < 0 || nm_idx > 3)
	  return -1;

	snprintf(wds_var, 31, "wl_wds%d_netmask", wds_idx);

	c = nvram_safe_get(wds_var);

	if(c){
		nm = get_single_ip(c, nm_idx);
		ret += websWrite(wp, "%d", nm);
	}
	else
		ret += websWrite(wp, "255");

	return ret;

}


int ej_get_wds_gw(int eid, webs_t wp, int argc, char_t **argv)
{
	int gw=-1, wds_idx=-1, gw_idx=-1, ret=0;
	char *c, wds_var[32]="";


	if (ejArgs(argc, argv, "%d %d", &wds_idx, &gw_idx) < 2) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	else if(wds_idx < 1 || wds_idx > MAX_WDS_DEVS)
	  return -1;
	else if(gw_idx < 0 || gw_idx > 3)
	  return -1;

	snprintf(wds_var, 31, "wl_wds%d_gw", wds_idx);

	c = nvram_safe_get(wds_var);

	if(c){
		gw = get_single_ip(c, gw_idx);
		ret += websWrite(wp, "%d", gw);
	}
	else
		ret += websWrite(wp, "0");

	return ret;

}

int ej_get_br1_ip(int eid, webs_t wp, int argc, char_t **argv)
{
	int ip=-1, ip_idx=-1, ret=0;
	char *c;


	if (ejArgs(argc, argv, "%d", &ip_idx) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}
	else if(ip_idx < 0 || ip_idx > 3)
	  return -1;

	c = nvram_safe_get("wl_br1_ipaddr");

	if(c){
		ip = get_single_ip(c, ip_idx);
		ret += websWrite(wp, "%d", ip);
	}
	else
		ret += websWrite(wp, "0");

	return ret;

}

int ej_get_br1_netmask(int eid, webs_t wp, int argc, char_t **argv)
{
	int nm=-1, nm_idx=-1, ret=0;
	char *c;


	if (ejArgs(argc, argv, "%d", &nm_idx) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}
	else if(nm_idx < 0 || nm_idx > 3)
	  return -1;

	c = nvram_safe_get("get_br1_netmask2");

	if(c){
		nm = get_single_ip(c, nm_idx);
		ret += websWrite(wp, "%d", nm);
	}
	else
		ret += websWrite(wp, "255");

	return ret;

}

int ej_get_currate(int eid, webs_t wp, int argc, char_t **argv)
{
	char *dev=NULL;
	int ret=0, rate=0;

	if(check_hw_type() == BCM4702_CHIP)
	  dev = "eth2";
	else
	  dev = "eth1";

	wl_ioctl(dev, WLC_GET_RATE, &rate, sizeof(rate));

	if(rate>0){
		ret += websWrite(wp, "%d", rate/2);
	}
	else
		ret += websWrite(wp, "unknown");

	return ret;

}

#define UPTIME_TMP	"/tmp/.uptime"
int ej_get_uptime(int eid, webs_t wp, int argc, char_t **argv)
{
	char uptime[255] = {0}, cmd[255] = {0};
	FILE *fp;
	int ret = -1;

	unlink(UPTIME_TMP);

	snprintf(cmd, 254, "uptime 2>&1 > %s", UPTIME_TMP);
	system(cmd);

	if ((fp = fopen(UPTIME_TMP, "r")) != NULL)
		fgets(uptime, sizeof(uptime), fp);
	else
		return -1;

	ret = websWrite(wp, "%s", uptime);

	fclose(fp);

	unlink(UPTIME_TMP);

	return ret;

}


int ej_get_curchannel(int eid, webs_t wp, int argc, char_t **argv)
{
	char *dev=NULL;
	int ret=0;
	channel_info_t ci;

	if(check_hw_type() == BCM4702_CHIP)
	  dev = "eth2";
	else
	  dev = "eth1";

	wl_ioctl(dev, WLC_GET_CHANNEL, &ci, sizeof(ci));
	if(ci.target_channel>0){
		ret += websWrite(wp, "%d", ci.target_channel);
	}
	else
		ret += websWrite(wp, "0");

	return ret;

}

#define ASSOCLIST_TMP	"/tmp/.wl_assoclist"
#define RSSI_TMP	"/tmp/.rssi"
#define ASSOCLIST_CMD	"wl assoclist"
#define RSSI_CMD	"wl rssi"
#define NOISE_CMD	"wl noise"

int ej_active_wireless(int eid, webs_t wp, int argc, char_t **argv)
{
	int  rssi=0, noise=0;
	FILE *fp, *fp2;
	char *mode;
	char mac[30];
	char list[2][30];
	char line[80];
	char cmd[80];
	char title[20];

	unlink(ASSOCLIST_TMP);
	unlink(RSSI_TMP);

	mode = nvram_safe_get("wl0_mode");
	snprintf(cmd,sizeof(cmd),"%s > %s", ASSOCLIST_CMD, ASSOCLIST_TMP);
	system(cmd);		// get active wireless mac

	if(strcmp(mode, "ap") != 0)
	  strcpy(title, "AP Signal:");
	else
	  strcpy(title, "Clients:");

	if ((fp = fopen(ASSOCLIST_TMP, "r"))) {
		while( fgets(line, sizeof(line), fp) != NULL ) {
			if(sscanf(line,"%s %s",list[0], mac) != 2)	// assoclist 00:11:22:33:44:55
				continue;

			if(strcmp(list[0],"assoclist"))
				break;

			rssi = 0;
			noise = 0;

			// get rssi value
			if(strcmp(mode, "ap"))
			  snprintf(cmd,sizeof(cmd),"%s > %s", RSSI_CMD, RSSI_TMP);
			else
			  snprintf(cmd,sizeof(cmd),"%s \"%s\" > %s", RSSI_CMD, mac, RSSI_TMP);
			system(cmd);

			// get noise value if not ap mode
			if(strcmp(mode, "ap"))
			  snprintf(cmd,sizeof(cmd),"%s >> %s", NOISE_CMD, RSSI_TMP);

		  	system(cmd);		// get RSSI value for mac

			fp2 = fopen(RSSI_TMP, "r");
			if(fgets(line, sizeof(line), fp2) != NULL){

				// get rssi
				if(sscanf(line,"%s %s %d", list[0], list[1], &rssi) != 3)
			     		continue;

				// get noise for client/wet mode
				if (strcmp(mode, "ap") &&
			    	    fgets(line, sizeof(line), fp2) != NULL &&
			    	    sscanf(line,"%s %s %d", list[0], list[1], &noise) != 3)
			     		continue;

				fclose(fp2);
			}
			if( strcmp(mode,"ap") != 0){
			  websWrite(wp, "\
 <TR> \n\
  <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25>&nbsp;</TD> \n\
  <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>\n\
  <TD colSpan=3 height=25>&nbsp;</TD>\n\
  <TD height=25><font style=\"font-size: 8pt\">%s</font></TD>\n\
         <TD height=25><FONT style=\"FONT-SIZE: 8pt\"><B>&nbsp;%s rssi %d noise %d</B></FONT></TD>\n\
  <TD width=13 height=25>&nbsp;</TD>\n\
  <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD>\n\
 </TR>\n",title, mac, rssi, noise);
 			}
 			else{
			  websWrite(wp, "\
 <TR> \n\
  <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25>&nbsp;</TD> \n\
  <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>\n\
  <TD colSpan=3 height=25>&nbsp;</TD>\n\
  <TD height=25><font style=\"font-size: 8pt\">%s</font></TD>\n\
         <TD height=25><FONT style=\"FONT-SIZE: 8pt\"><B>&nbsp;%s rssi %d</B></FONT></TD>\n\
  <TD width=13 height=25>&nbsp;</TD>\n\
  <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD>\n\
 </TR>\n",title, mac, rssi);
 			}
 			title[0] = 0;
		}
	}

	unlink(ASSOCLIST_TMP);
	unlink(RSSI_TMP);

	return 0;
}

#define WDS_LIST_TMP	"/tmp/.wl_wdslist"
#define WDS_RSSI_TMP	"/tmp/.rssi"
#define WDS_CMD	"wl wds"

int ej_active_wds(int eid, webs_t wp, int argc, char_t **argv)
{
	int  rssi=0;
	FILE *fp, *fp2;
	char *mode;
	char mac[30];
	char list[2][30];
	char line[80];
	char cmd[80];
	char title[20];

	unlink(WDS_LIST_TMP);
	unlink(WDS_RSSI_TMP);

	mode = nvram_safe_get("wl0_mode");
	snprintf(cmd,sizeof(cmd),"%s > %s", WDS_CMD, WDS_LIST_TMP);
	system(cmd);		// get active wireless mac

	if(strcmp(mode, "ap") == 0)
	  strcpy(title, "WDS Signal:");
	else
	  return -1;

	if ((fp = fopen(WDS_LIST_TMP, "r"))) {
		while( fgets(line, sizeof(line), fp) != NULL ) {
			if(sscanf(line,"%s %s",list[0], mac) != 2)	// "XX:XX:XX:XX:XX:XX XX:XX:XX:XX:XX:XX" etc
				continue;

			if(strcmp(list[0],"wds"))
				break;

			rssi = 0;

		  	snprintf(cmd,sizeof(cmd),"%s \"%s\" > %s", RSSI_CMD, mac, RSSI_TMP);
			system(cmd);

			fp2 = fopen(RSSI_TMP, "r");
			if(fgets(line, sizeof(line), fp2) != NULL){

				// get rssi
				if(sscanf(line,"%s %s %d", list[0], list[1], &rssi) != 3)
   		     		  continue;

				fclose(fp2);
			}
		  	websWrite(wp, "\
 <TR> \n\
  <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25>&nbsp;</TD> \n\
  <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>\n\
  <TD colSpan=3 height=25>&nbsp;</TD>\n\
  <TD height=25><font style=\"font-size: 8pt\">%s</font></TD>\n\
         <TD height=25><FONT style=\"FONT-SIZE: 8pt\"><B>&nbsp;%s rssi %d</B></FONT></TD>\n\
  <TD width=13 height=25>&nbsp;</TD>\n\
  <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD>\n\
 </TR>\n",title, mac, rssi);
 			title[0] = 0;
		}
	}

	unlink(WDS_LIST_TMP);
	unlink(WDS_RSSI_TMP);

	return 0;
}

int ej_get_wdsp2p(int eid, webs_t wp, int argc, char_t **argv)
{
	int index=-1, ip[4]={0,0,0,0}, netmask[4]={0,0,0,0};
	char nvramvar[32]={0};

        if (ejArgs(argc, argv, "%d", &index) < 1) {
                websError(wp, 400, "Insufficient args\n");
                return -1;
        }

	snprintf(nvramvar, 31, "wl_wds%d_ipaddr", index);
	sscanf(nvram_safe_get(nvramvar),"%d.%d.%d.%d",&ip[0],&ip[1],&ip[2],&ip[3]);
	snprintf(nvramvar, 31, "wl_wds%d_netmask", index);
	sscanf(nvram_safe_get(nvramvar),"%d.%d.%d.%d",&netmask[0],&netmask[1],&netmask[2],&netmask[3]);
	snprintf(nvramvar, 31, "wl_wds%d_enable", index);

	// set netmask to a suggested default if blank
	if(netmask[0] == 0 &&
	   netmask[1] == 0 &&
	   netmask[2] == 0 &&
	   netmask[3] == 0){
	   netmask[0] = 255;
	   netmask[1] = 255;
	   netmask[2] = 255;
	   netmask[3] = 252;
	   }

	if(nvram_match(nvramvar, "1") ){

	websWrite(wp, "\
	<tr>\n\
          <td width=156 bgColor=#e7e7e7 colSpan=3 height=25>&nbsp;</td>\n\
          <td width=8 background=image/UI_04.gif height=25>&nbsp;</td>\n\
          <td colSpan=3 height=25>&nbsp;</td>\n\
          <td width=101 height=25>&nbsp;IP Address:</td>\n\
          <td width=296 height=25>&nbsp;\n\
	          <input type=hidden name=wl_wds%d_ipaddr value=4>\n\
	          <input size=3 maxlength=3 name=wl_wds%d_ipaddr0 value=\"%d\" onBlur=valid_range(this,0,255,\"IP\") class=num>\n\
                  <input size=3 maxlength=3 name=wl_wds%d_ipaddr1 value=\"%d\" onBlur=valid_range(this,0,255,\"IP\") class=num>\n\
                  <input size=3 maxlength=3 name=wl_wds%d_ipaddr2 value=\"%d\" onBlur=valid_range(this,0,255,\"IP\") class=num>\n\
                  <input size=3 maxlength=3 name=wl_wds%d_ipaddr3 value=\"%d\" onBlur=valid_range(this,1,254,\"IP\") class=num></td>\n\
          <td width=13 height=25>&nbsp;</td>\n\
          <td width=15 background=image/UI_05.gif height=25>&nbsp;</td>\n\
       </tr>\n", index, index, ip[0], index, ip[1], index, ip[2], index, ip[3], index);

	websWrite(wp, "\
        <TR>\n\
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25>&nbsp;</TD>\n\
          <TD width=8 background=image/UI_04.gif height=24>&nbsp;</TD>\n\
          <TD colSpan=3 height=25>&nbsp;</TD>\n\
          <TD width=101 height=24><FONT style=\"FONT-SIZE: 8pt\"><SPAN>Subnet Mask:</SPAN></FONT></TD>\n\
          <TD width=296 height=24>&nbsp;\n\
	  <input type=\"hidden\" name=\"wl_wds%d_netmask\" value=\"4\">\n\
	  <input name=\"wl_wds%d_netmask0\" value=\"%d\" size=\"3\" maxlength=\"3\" onBlur=valid_range(this,0,255,\"IP\") class=num>\n\
	  <input name=\"wl_wds%d_netmask1\" value=\"%d\" size=\"3\" maxlength=\"3\" onBlur=valid_range(this,0,255,\"IP\") class=num>\n\
	  <input name=\"wl_wds%d_netmask2\" value=\"%d\" size=\"3\" maxlength=\"3\" onBlur=valid_range(this,0,255,\"IP\") class=num>\n\
	  <input name=\"wl_wds%d_netmask3\" value=\"%d\" size=\"3\" maxlength=\"3\" onBlur=valid_range(this,0,255,\"IP\") class=num>\n\
	  </TD>\n\
          <TD width=13 height=24>&nbsp;</TD>\n\
          <TD width=15 background=image/UI_05.gif height=24>&nbsp;</TD>\n\
       </TR>\n", index, index, netmask[0], index, netmask[1], index, netmask[2], index, netmask[3]);

	websWrite(wp, "\
        <TR>\n\
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25>&nbsp;</TD>\n\
          <TD width=8 background=image/UI_04.gif height=24>&nbsp;</TD>\n\
          <TD colSpan=3 height=25>&nbsp;</TD>\n\
          <TD width=101 height=24>&nbsp;</TD>\n\
          <TD width=296 height=24><HR>\n</TD>\n\
          <TD width=13 height=24>&nbsp;</TD>\n\
          <TD width=15 background=image/UI_05.gif height=24>&nbsp;</TD>\n\
       </TR>");

       }

       return 0;

}

int save_wds(webs_t wp)
{
	char *wds_enable_val, wds_enable_var[32]={0};
	int  h=0;


	for(h=1; h<=MAX_WDS_DEVS;h++)
	{
		sprintf(wds_enable_var, "wl_wds%d_enable", h);
		wds_enable_val = websGetVar(wp, wds_enable_var, NULL);
		nvram_set(wds_enable_var, wds_enable_val);
	}

	wds_enable_val = websGetVar(wp, "wl_br1_enable", NULL);
	nvram_set("wl_br1_enable", wds_enable_val);

	return 0;
}

int ej_get_qossvcs(int eid, webs_t wp, int argc, char_t **argv)
{
	char *qos_svcs = nvram_safe_get("svqos_svcs");
	char name[32], type[32], data[32], level[32];
	int  no_svcs = 0, i = 0, ret = -1;


	// calc # of services
//	no_svcs = strspn(qos_svcs,"|");

	while((qos_svcs=strpbrk(qos_svcs,"|")))
	{
		no_svcs++;
		qos_svcs++;
	}

	// write HTML data

	websWrite(wp, "<input type=hidden name='svqos_nosvcs' value='%d'>", no_svcs);

	qos_svcs = nvram_safe_get("svqos_svcs");

	/* services format is "name type data level | name type data level |" ..etc */
	for(i=0;i<no_svcs && qos_svcs && qos_svcs[0];i++)
	{
		if (sscanf(qos_svcs, "%31s %31s %31s %31s ", name, type, data, level) < 4)
			break;

		ret = websWrite( wp,
		          "<TR>\n\
			   <TD align=right bgColor=#e7e7e7 height=5></TD>\n\
			   <TD width=8 background=image/UI_04.gif height=5></TD>\n\
			   <TD height=5></TD>\n\
			   <TD colSpan=2>\n\
		           <TABLE>\n\
			   <TR>\n\
			   <TD width=100 height=5><input type=checkbox name=\"svqos_svcdel%d\"></TD>\n\
			   <TD width=297 height=25>\n\
		           <TABLE>\n\
		           <TR>\n\
			   <CENTER>\n\
			   <input type=hidden name=\"svqos_svcname%d\" value=\"%s\">\n\
			   <input type=hidden name=\"svqos_svctype%d\" value=\"%s\">\n\
			   <TD align=middle width=80><B>%s</B></TD>\n\
			   <TD align=middle width=80>\n\
			   <SELECT name=\"svqos_svcprio%d\"> \n\
			   <option value=\"10\" %s>Premium</option>\n\
		           <option value=\"20\" %s>Express</option>\n\
			   <option value=\"30\" %s>Standard</option>\n\
		           <option value=\"40\" %s>Bulk</option>\n\
			   </SELECT>\n\
		           </TD>\n\
			   <TD align=middle width=80><B>&nbsp;</B></TD>\n\
			   </CENTER>\n\
			   </TR>\n\
			   </TABLE>\n\
			   </TD>\n\
			   </TR>\n\
		           </TABLE>\n\
			   </TD>\n\
			   </TR>\n",
			   i, i, name, i, type, name,  i,	strcmp(level,"10") == 0 ? "selected" : "",
			   					strcmp(level,"20") == 0 ? "selected" : "",
						   		strcmp(level,"30") == 0 ? "selected" : "",
						   		strcmp(level,"40") == 0 ? "selected" : "");

		qos_svcs = strpbrk(++qos_svcs,"|");
		qos_svcs++;

   	}

	return ret;
}

int ej_get_qosips(int eid, webs_t wp, int argc, char_t **argv)
{
	char *qos_ips = nvram_safe_get("svqos_ips");
	char ip[32], level[32];
	int  no_ips = 0, i = 0, ret = -1;

	// calc # of ips
	while((qos_ips=strpbrk(qos_ips,"|")))
	{
		no_ips++;
		qos_ips++;
	}

	// write HTML data

	websWrite(wp, "<input type=hidden name='svqos_noips' value='%d'>", no_ips);

	qos_ips = nvram_safe_get("svqos_ips");

	/* IP format is "data level | data level |" ..etc */
	for(i=0;i<no_ips && qos_ips && qos_ips[0];i++)
	{
		if (sscanf(qos_ips, "%31s %31s ", ip, level) < 2)
			break;

		ret = websWrite( wp,
		          "<TR>\n\
			   <TD align=right bgColor=#e7e7e7 height=5></TD>\n\
			   <TD width=8 background=image/UI_04.gif height=5></TD>\n\
			   <TD height=5></TD>\n\
			   <TD colSpan=2>\n\
		           <TABLE>\n\
			   <TR>\n\
			   <TD width=90 height=5><input type=checkbox name=\"svqos_ipdel%d\"></TD>\n\
			   <input type=hidden name=\"svqos_ip%d\" value=\"%s\">\n\
			   <TD width=297 height=25>\n\
		           <TABLE>\n\
		           <TR>\n\
			   <CENTER>\n\
			   <TD align=middle width=90><B>%s</B></TD>\n\
			   <TD align=middle width=80>\n\
			   <SELECT name=\"svqos_ipprio%d\"> \n\
			   <option value=\"10\" %s>Premium</option>\n\
		           <option value=\"20\" %s>Express</option>\n\
			   <option value=\"30\" %s>Standard</option>\n\
		           <option value=\"40\" %s>Bulk</option>\n\
			   </SELECT>\n\
		           </TD>\n\
			   <TD align=middle width=80><B>&nbsp;</B></TD>\n\
			   </CENTER>\n\
			   </TR>\n\
			   </TABLE>\n\
			   </TD>\n\
			   </TR>\n\
		           </TABLE>\n\
			   </TD>\n\
			   </TR>\n",
			   i, i, ip, ip, i,	strcmp(level,"10") == 0 ? "selected" : "",
			   			strcmp(level,"20") == 0 ? "selected" : "",
						strcmp(level,"30") == 0 ? "selected" : "",
						strcmp(level,"40") == 0 ? "selected" : "");

		qos_ips = strpbrk(++qos_ips,"|");
		qos_ips++;

   	}

	return ret;
}


int ej_get_qosmacs(int eid, webs_t wp, int argc, char_t **argv)
{
	char *qos_macs = nvram_safe_get("svqos_macs");
	char mac[32], level[32];
	int  no_macs = 0, i = 0, ret = -1;


	// calc # of ips
	while((qos_macs=strpbrk(qos_macs,"|")))
	{
		no_macs++;
		qos_macs++;
	}

	// write HTML data
	websWrite(wp, "<input type=hidden name='svqos_nomacs' value='%d'>", no_macs);

	qos_macs = nvram_safe_get("svqos_macs");

	/* IP format is "data level | data level |" ..etc */
	for(i=0;i<no_macs && qos_macs && qos_macs[0];i++)
	{
		if (sscanf(qos_macs, "%31s %31s ", mac, level) < 2)
			break;

		ret = websWrite( wp,
		          "<TR>\n\
			   <TD align=right bgColor=#e7e7e7 height=5></TD>\n\
			   <TD width=8 background=image/UI_04.gif height=5></TD>\n\
			   <TD height=5></TD>\n\
			   <TD colSpan=2>\n\
		           <TABLE>\n\
			   <TR>\n\
			   <TD width=100 height=5><input type=checkbox name=\"svqos_macdel%d\"></TD>\n\
			   <input type=hidden name=\"svqos_mac%d\" value=\"%s\">\n\
			   <TD width=297 height=25>\n\
		           <TABLE>\n\
		           <TR>\n\
			   <CENTER>\n\
			   <TD align=middle width=80><B>%s</B></TD>\n\
			   <TD align=middle width=80>\n\
			   <SELECT name=\"svqos_macprio%d\"> \n\
			   <option value=\"10\" %s>Premium</option>\n\
		           <option value=\"20\" %s>Express</option>\n\
			   <option value=\"30\" %s>Standard</option>\n\
		           <option value=\"40\" %s>Bulk</option>\n\
			   </SELECT>\n\
		           </TD>\n\
			   <TD align=middle width=80><B>&nbsp;</B></TD>\n\
			   </CENTER>\n\
			   </TR>\n\
			   </TABLE>\n\
			   </TD>\n\
			   </TR>\n\
		           </TABLE>\n\
			   </TD>\n\
			   </TR>\n",
			   i, i, mac, mac, i,	strcmp(level,"10") == 0 ? "selected" : "",
			   			strcmp(level,"20") == 0 ? "selected" : "",
						strcmp(level,"30") == 0 ? "selected" : "",
						strcmp(level,"40") == 0 ? "selected" : "");

		qos_macs = strpbrk(++qos_macs,"|");
		qos_macs++;

   	}

	return ret;
}



int
ej_get_services_options(int eid, webs_t wp, int argc, char_t **argv)
{
	int ret = 0;
	char word[1024], *next, *services;
	char delim[] = "<&nbsp;>";

	services = nvram_safe_get("filter_services");
	split(word, services, next, delim) {
		int len = 0;
		char *name, *prot, *port;
		char protocol[100], ports[100];
		int from = 0, to = 0;
		//int proto;

		if ((name=strstr(word, "$NAME:")) == NULL ||
	    	    (prot=strstr(word, "$PROT:")) == NULL ||
		    (port=strstr(word, "$PORT:")) == NULL)
			continue;

		/* $NAME */
		if (sscanf(name, "$NAME:%3d:", &len) != 1)
			continue;

		strncpy(name, name + sizeof("$NAME:nnn:") - 1, len);
  		name[len] = '\0';

		/* $PROT */
		if (sscanf(prot, "$PROT:%3d:", &len) != 1)
			continue;

		strncpy(protocol, prot + sizeof("$PROT:nnn:") - 1, len);
		protocol[len] = '\0';

		/* $PORT */
		if (sscanf(port, "$PORT:%3d:", &len) != 1)
			continue;

		strncpy(ports, port + sizeof("$PORT:nnn:") - 1, len);
		ports[len] = '\0';

		if (sscanf(ports, "%d:%d", &from, &to) != 2)
			continue;

		//cprintf("match:: name=%s, protocol=%s, ports=%s\n",
		//	word, protocol, ports);

		ret = websWrite(wp, "<option value=\"%s\">%s</option>", name, name);

	}

	return ret;
}

int get_svc(char* svc, char* protocol, char* ports)
{
	char word[1024], *next, *services;
	char delim[] = "<&nbsp;>";

	services = nvram_safe_get("filter_services");
	split(word, services, next, delim) {
		int len = 0;
		char *name, *prot, *port;
		int from = 0, to = 0;

		if ((name=strstr(word, "$NAME:")) == NULL ||
	    	    (prot=strstr(word, "$PROT:")) == NULL ||
		    (port=strstr(word, "$PORT:")) == NULL)
			continue;

		/* $NAME */
		if (sscanf(name, "$NAME:%3d:", &len) != 1)
			return -1;

		strncpy(name, name + sizeof("$NAME:nnn:") - 1, len);
  		name[len] = '\0';

		if(strcasecmp(svc, name))
			continue;

		/* $PROT */
		if (sscanf(prot, "$PROT:%3d:", &len) != 1)
			return -1;

		strncpy(protocol, prot + sizeof("$PROT:nnn:") - 1, len);
		protocol[len] = '\0';

		/* $PORT */
		if (sscanf(port, "$PORT:%3d:", &len) != 1)
			return -1;

		strncpy(ports, port + sizeof("$PORT:nnn:") - 1, len);
		ports[len] = '\0';

		if (sscanf(ports, "%d:%d", &from, &to) != 2)
			return -1;


		if(strcasecmp(svc, name) == 0)
			return 0;
	}

	return -1;
}

int qos_add_svc(webs_t wp)
{
	char  protocol[100] = {0}, ports[100] = {0};
	char* add_svc = websGetVar(wp, "add_svc", NULL);
	char* svqos_svcs = nvram_safe_get("svqos_svcs");
	char  new_svcs[4096] = {0};
	int   i=0;

	if(get_svc(add_svc, protocol, ports))
		return -1;

	if(strcmp(protocol,"l7") == 0){
		for(i=0;i<strlen(add_svc);i++)
			add_svc[i] = tolower(add_svc[i]);
	}

	/* if this service exists, return an error */
	if(strstr(svqos_svcs, add_svc))
		return -1;

	if(strlen(svqos_svcs) > 0)
		snprintf(new_svcs, 4095, "%s %s %s %s 40 |", svqos_svcs, add_svc, protocol, ports);
	else
		snprintf(new_svcs, 4095, "%s %s %s 40 |",add_svc, protocol, ports);

	nvram_set("svqos_svcs", new_svcs);
	nvram_commit();

	return 0;
}

int qos_add_ip(webs_t wp)
{
	char* add_ip0 = websGetVar(wp, "svqos_ipaddr0", NULL);
	char* add_ip1 = websGetVar(wp, "svqos_ipaddr1", NULL);
	char* add_ip2 = websGetVar(wp, "svqos_ipaddr2", NULL);
	char* add_ip3 = websGetVar(wp, "svqos_ipaddr3", NULL);
	char* add_nm  = websGetVar(wp, "svqos_netmask", NULL);
	char  add_ip[19] = {0};
	char* svqos_ips = nvram_safe_get("svqos_ips");
	char  new_ip[4096] = {0};

	snprintf(add_ip, 18, "%s.%s.%s.%s/%s", add_ip0, add_ip1, add_ip2, add_ip3, add_nm);

	/* if this ip exists, return an error */
	if(strstr(svqos_ips, add_ip))
		return -1;

	snprintf(new_ip, 4095, "%s %s 40 |", svqos_ips, add_ip);

	nvram_set("svqos_ips", new_ip);
	nvram_commit();

	return 0;
}

int qos_add_mac(webs_t wp)
{
	char* add_mac0 = websGetVar(wp, "svqos_hwaddr0", NULL);
	char* add_mac1 = websGetVar(wp, "svqos_hwaddr1", NULL);
	char* add_mac2 = websGetVar(wp, "svqos_hwaddr2", NULL);
	char* add_mac3 = websGetVar(wp, "svqos_hwaddr3", NULL);
	char* add_mac4 = websGetVar(wp, "svqos_hwaddr4", NULL);
	char* add_mac5 = websGetVar(wp, "svqos_hwaddr5", NULL);
	char  add_mac[19] = {0};
	char* svqos_macs = nvram_safe_get("svqos_macs");
	char  new_mac[4096] = {0};


	snprintf(add_mac, 18, "%s:%s:%s:%s:%s:%s", add_mac0, add_mac1, add_mac2, add_mac3, add_mac4, add_mac5);

	/* if this mac exists, return an error */
	if(strstr(svqos_macs, add_mac))
		return -1;

	snprintf(new_mac, 4095, "%s %s 40 |", svqos_macs, add_mac);

	nvram_set("svqos_macs", new_mac);
	nvram_commit();

	return 0;
}

int qos_save(webs_t wp)
{
	char svqos_var[4096] = {0};
	char field[32] = {0};
	char *name, *data, *level, *delete;
	int  no_svcs = atoi(websGetVar(wp, "svqos_nosvcs", NULL));
	int  no_ips  = atoi(websGetVar(wp, "svqos_noips", NULL));
	int  no_macs = atoi(websGetVar(wp, "svqos_nomacs", NULL));
	int  i = 0, j = 0;

	/* resued wshaper fields - see src/router/rc/wshaper.c */
	snprintf(field, 31, "wshaper_enable");
	data = websGetVar(wp, field, NULL);
	nvram_set("wshaper_enable", data);
	
	if(strcmp(data, "0") == 0)
		return -1;

	snprintf(field, 31, "wshaper_downlink");
	data = websGetVar(wp, field, NULL);
	nvram_set("wshaper_downlink", data);

	snprintf(field, 31, "wshaper_uplink");
	data = websGetVar(wp, field, NULL);
	nvram_set("wshaper_uplink", data);

	snprintf(field, 31, "wshaper_dev");
	data = websGetVar(wp, field, NULL);
	nvram_set("wshaper_dev", data);

	/* services priorities */
	for(i=0; i < no_svcs; i++)
	{
		char protocol[100], ports[100];

		memset(protocol, 0, 100);
		memset(ports, 0, 10);

		snprintf(field, 31, "svqos_svcdel%d", i);
		delete = websGetVar(wp, field, NULL);

		if(delete && strlen(delete) > 0)
			continue;

		snprintf(field, 31, "svqos_svcname%d", i);
		name = websGetVar(wp, field, NULL);

		snprintf(field, 31, "svqos_svcprio%d", i);
		level = websGetVar(wp, field, NULL);

		if(get_svc(name, protocol, ports))
			continue;

		if(strcmp(protocol,"l7") == 0){
			for(j=0;j<strlen(name);j++)
				name[j] = tolower(name[j]);
		}

		if(strlen(svqos_var) > 0)
			sprintf(svqos_var, "%s %s %s %s %s |", svqos_var, name, protocol, ports, level);
		else
			sprintf(svqos_var, "%s %s %s %s |", name, protocol, ports, level);

	}

	nvram_set("svqos_svcs", svqos_var);
	svqos_var[0] = 0;

	/* IP priorities */
	for(i=0; i < no_ips; i++)
	{

		snprintf(field, 31, "svqos_ipdel%d", i);
		delete = websGetVar(wp, field, NULL);

		if(delete && strlen(delete) > 0)
			continue;

		snprintf(field, 31, "svqos_ip%d", i);
		data = websGetVar(wp, field, NULL);

		snprintf(field, 31, "svqos_ipprio%d", i);
		level = websGetVar(wp, field, NULL);

		if(strlen(svqos_var) > 0)
			sprintf(svqos_var, "%s %s %s |", svqos_var, data, level);
		else
			sprintf(svqos_var, "%s %s |", data, level);

	}

	nvram_set("svqos_ips", svqos_var);
	svqos_var[0] = 0;

	/* MAC priorities */
	for(i=0; i < no_macs; i++)
	{
		snprintf(field, 31, "svqos_macdel%d", i);
		delete = websGetVar(wp, field, NULL);

		if(delete && strlen(delete) > 0)
			continue;

		snprintf(field, 31, "svqos_mac%d", i);
		data = websGetVar(wp, field, NULL);

		snprintf(field, 31, "svqos_macprio%d", i);
		level = websGetVar(wp, field, NULL);

		if(strlen(svqos_var) > 0)
			sprintf(svqos_var, "%s %s %s |", svqos_var, data, level);
		else
			sprintf(svqos_var, "%s %s |", data, level);

	}

	nvram_set("svqos_macs", svqos_var);

	/* adm6996 LAN port priorities */
	nvram_set("svqos_port1prio", websGetVar(wp, "svqos_port1prio", NULL));
	nvram_set("svqos_port2prio", websGetVar(wp, "svqos_port2prio", NULL));
	nvram_set("svqos_port3prio", websGetVar(wp, "svqos_port3prio", NULL));
	nvram_set("svqos_port4prio", websGetVar(wp, "svqos_port4prio", NULL));

	nvram_set("svqos_port1bw", websGetVar(wp, "svqos_port1bw", NULL));
	nvram_set("svqos_port2bw", websGetVar(wp, "svqos_port2bw", NULL));
	nvram_set("svqos_port3bw", websGetVar(wp, "svqos_port3bw", NULL));
	nvram_set("svqos_port4bw", websGetVar(wp, "svqos_port4bw", NULL));

	return 0;
}

