 /*
 * Remaining issues:
 *   + stats support
 *   + multicast support
 *   + media sense
 *   + half/full duplex
 *   - random MAC addr.
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/pci.h>
#include <linux/init.h>
#include <linux/ioport.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/ethtool.h>
#include <linux/mii.h>
#include <asm/io.h>

#include <linux/sysctl.h>

#define MODULE_NAME "port_based_qos_mod"
#define DEVICE_NAME "qos"
#define MODULE_VERSION "0.0.1"

struct port_qos_t{
//	char *option_name;
	int addr;
	int content_mask;
	int *content_set; 
};

void WriteDataToRegister_(unsigned short reg_idx, unsigned short content_idx);
extern void write_eeprom(short,short *,int);
extern void ReadDataFromRegister(unsigned short addr, unsigned short *hidata, unsigned short *lodata,int select_count);

#define PORT_CONFIG_1	0x3
#define PORT_CONFIG_2	0x5
#define PORT_CONFIG_3	0x7
#define PORT_CONFIG_4	0x8
#define BANDWIDTH_CTL_123	0x31
#define BANDWIDTH_CTL_4	0x32
#define BANDWIDTH_CTL_ENABLE	0x33
#define DISCARD_MODE	0x10

#define PRIORITY_MASK	0xfc7f
#define PRIORITY_DISABLE_MASK	0xfc7e
#define FLOW_CTL_MASK	0xfffe
#define RATE_LIMIT_MASK_14	0xff8f
#define RATE_LIMIT_MASK_2	0xf8ff
#define RATE_LIMIT_MASK_3	0x8fff
#define BANDWIDTH_CTL_MASK	0xff2b
#define DISCARD_MASK	0xf0ff

static int disable_content[] = {0x0};
static int enable_content[] = {0xd4, 0x0cff};//bit 7,6,4,2; Q1=11(50%),Q0=00(0%)
static int port_priority_content[] = {0x180,0x080};//Q1,Q0
static int port_flow_ctl_content[] = {0x0,0x1};
static int port_rate_limit_content_14[] = {0x00,0x10,0x20,0x30,0x40,0x50,0x60,0x70};
static int port_rate_limit_content_2[] = {0x000,0x100,0x200,0x300,0x400,0x500,0x600,0x700};
static int port_rate_limit_content_3[] = {0x0000,0x1000,0x2000,0x3000,0x4000,0x5000,0x6000,0x7000};

static struct port_qos_t port_mii_disable[] = {
	{ BANDWIDTH_CTL_ENABLE, BANDWIDTH_CTL_MASK, disable_content},
	{ -1}
};

static struct port_qos_t port_mii_enable[] = {
	{ BANDWIDTH_CTL_ENABLE, BANDWIDTH_CTL_MASK, enable_content},
	{ DISCARD_MODE, DISCARD_MASK, enable_content},
	{ -1}
};

struct port_qos_t *port_mii_sw_array[] = {port_mii_disable, port_mii_enable};

static struct port_qos_t port_mii_addr[] = {
	{ PORT_CONFIG_1, PRIORITY_MASK, port_priority_content},//port_priority_1
	{ PORT_CONFIG_1, FLOW_CTL_MASK, port_flow_ctl_content},//port_flow_control_1
	//{ "port_frame_type_1", 0x3},
	{ BANDWIDTH_CTL_123, RATE_LIMIT_MASK_14, port_rate_limit_content_14},//port_rate_limit_1
	{ PORT_CONFIG_2, PRIORITY_MASK, port_priority_content},//port_priority_2
	{ PORT_CONFIG_2, FLOW_CTL_MASK, port_flow_ctl_content},//port_flow_control_2
	//{ "port_frame_type_2", 0x5},
	{ BANDWIDTH_CTL_123, RATE_LIMIT_MASK_2, port_rate_limit_content_2},//port_rate_limit_2
	{ PORT_CONFIG_3, PRIORITY_MASK, port_priority_content},//port_priority_3
	{ PORT_CONFIG_3, FLOW_CTL_MASK, port_flow_ctl_content},//port_flow_control_3
	//{ "port_frame_type_3", 0x7},
	{ BANDWIDTH_CTL_123, RATE_LIMIT_MASK_3, port_rate_limit_content_3},//port_rate_limit_3
	//{ "port_priority_4", 0x8, 0x380},
	{ PORT_CONFIG_4, PRIORITY_MASK, port_priority_content},//port_priority_4
	{ PORT_CONFIG_4, FLOW_CTL_MASK, port_flow_ctl_content},//port_flow_control_4
	//{ "port_frame_type_4", 0x8},
	{ BANDWIDTH_CTL_4, RATE_LIMIT_MASK_14, port_rate_limit_content_14},//port_rate_limit_4
	{ -1}
};

void WriteDataToRegister_(unsigned short reg_idx, unsigned short content_idx)
{
    short RegNumber;
    unsigned short data, hidata=0x0, lodata=0x0;
    int i;
    
    	RegNumber = port_mii_addr[reg_idx].addr;
	if (RegNumber == -1)//Disable or Enable
	{
		struct port_qos_t *port_mii_sw = port_mii_sw_array[content_idx];
	
    		printk("\nWriteDataToRegister_:reg_idx=%d content_idx=%d\n", reg_idx, content_idx);
		for (i=0; port_mii_sw[i].addr != -1; i++)
		{
    			RegNumber = port_mii_sw[i].addr;
				
			ReadDataFromRegister(RegNumber, &hidata, &lodata, 0);
        		
			if (!(RegNumber % 2)) /* even port number use lower word */
				hidata = lodata;
			 
		        data = (hidata & port_mii_sw[i].content_mask) | port_mii_sw[i].content_set[i];
	
			write_eeprom(RegNumber, &data, 1);
    			
   			ReadDataFromRegister(RegNumber, &hidata, &lodata, 0);
			printk("\n============== %s===============\n", (content_idx==0)?"disable":"enable");
		}
	}
	else
	{
    		ReadDataFromRegister(RegNumber, &hidata, &lodata, 0);

        	if (!(RegNumber % 2)) /* even port number use lower word */
			hidata = lodata;

	        data = (hidata & port_mii_addr[reg_idx].content_mask) | port_mii_addr[reg_idx].content_set[content_idx];
	
		write_eeprom(RegNumber, &data, 1);
   		ReadDataFromRegister(RegNumber, &hidata, &lodata, 0);
	}
}

static int dev_do_ioctl(struct net_device *dev, struct ifreq *req, int cmd)
{
    struct mii_ioctl_data *data = (struct mii_ioctl_data *)req->ifr_data;
    
    switch (cmd)
    {
    case SIOCGMIIPHY:		/* Get address of MII PHY in use. */
    case SIOCDEVPRIVATE:	/* for binary compat, remove in 2.5 */

	/* Fall through to the SIOCGMIIREG, taken from eepro100 and rtl
	 * drivers */
    case SIOCGMIIREG:		/* Read MII PHY register. */
    case SIOCDEVPRIVATE+1:	/* for binary compat, remove in 2.5 */
    case SIOCSMIIREG:		/* Write MII PHY register. */
	{
	printk("\n x phy_id=%x\n", data->phy_id);
	printk("\n x reg_num=%x\n", data->reg_num);
	printk("\n x val_in=%x\n", data->val_in);
	printk("\n x val_out=%x\n", data->val_out);
		
   	WriteDataToRegister_(data->phy_id, data->val_in); 
	return 0;
	}
    case SIOCDEVPRIVATE+2:	/* for binary compat, remove in 2.5 */
    default:
	return -EOPNOTSUPP;
    }
}

static int __devinit qos_eth_probe(struct net_device *dev)
{
    
    SET_MODULE_OWNER(dev);

    ether_setup(dev);

    strcpy(dev->name, DEVICE_NAME "0");

    dev->do_ioctl = dev_do_ioctl;

    return 0;
}

static char *port_option_name[] = {
 	"port_priority_1",
	"port_flow_control_1",
	//{ "port_frame_type_1",
	"port_rate_limit_1",
	"port_priority_2",
	"port_flow_control_2",
	//{ "port_frame_type_2",
	"port_rate_limit_2",
	"port_priority_3",
	"port_flow_control_3",
	//{ "port_frame_type_3",
	"port_rate_limit_3",
	"port_priority_4",
	//{ "port_priority_4", PORT_CONFIG_4, PRIORITY_MASK, port_priority_content},
	"port_flow_control_4",
	//{ "port_frame_type_4",
	"port_rate_limit_4",
	"sel_QoSport",
	NULL
};

static int set_port_option(struct net_device *dev, unsigned short port_addr, char *option_content)
{
    struct ifreq ifr;
    struct mii_ioctl_data stats;
	
    stats.phy_id=port_addr;
    stats.val_in=bcm_atoi(option_content);

    ifr.ifr_data = (void *)&stats;
    
    return dev_do_ioctl(dev, &ifr, SIOCSMIIREG);
}

void
restore_default_from_NV(struct net_device *dev)
{
	unsigned short i;
	
	for (i = 0; port_option_name[i]; i++)
	{
		set_port_option(dev, i, nvram_get(port_option_name[i]));
	}
	return;
}

static struct net_device qos_devices;

/* Module initialization and cleanup */
int init_module(void)
{
    int res;
    struct net_device *dev;

    printk("Initializing " MODULE_NAME " driver " MODULE_VERSION "\n");

	dev = &qos_devices;

	dev->init = qos_eth_probe;

	if ((res = register_netdev(dev)))
	    printk("Failed to register netdev. res = %d\n", res);

	restore_default_from_NV(dev);
    return 0;
}

void cleanup_module(void)
{
	struct net_device *dev = &qos_devices;
	if (dev->priv != NULL)
	{
	    unregister_netdev(dev);
	    kfree(dev->priv);
	    dev->priv = NULL;
	}
}

