/*
  File autogenerated by gengetopt version 2.8
  generated with the following command:
  gengetopt --conf-parser 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Usage: %s [OPTIONS]...\n", PACKAGE);
  printf("   -h         --help                       Print help and exit\n");
  printf("   -V         --version                    Print version and exit\n");
  printf("   -f         --fg                         Run in foreground (default=off)\n");
  printf("   -d         --debug                      Run in debug mode (default=off)\n");
  printf("   -cSTRING   --conf=STRING                Read configuration file (default='/etc/chilli.conf')\n");
  printf("              --pidfile=STRING             Filename of process id file (default='/var/run/chilli.pid')\n");
  printf("              --statedir=STRING            Directory of nonvolatile data (default='/var/lib/chilli/')\n");
  printf("   -nSTRING   --net=STRING                 Network (default='192.168.182.0/24')\n");
  printf("              --dynip=STRING               Dynamic IP address pool\n");
  printf("              --dns1=STRING                Primary DNS server IP address\n");
  printf("              --dns2=STRING                Secondary DNS server IP address\n");
  printf("              --domain=STRING              Domain to use for DNS lookups (default='key.chillispot.org')\n");
  printf("              --ipup=STRING                Script to run after link-up\n");
  printf("              --ipdown=STRING              Script to run after link-down\n");
  printf("              --radiuslisten=STRING        IP address to send from\n");
  printf("              --radiusserver1=STRING       IP address of radius server 1 (default='rad01.hotradius.com')\n");
  printf("              --radiusserver2=STRING       IP address of radius server 2 (default='rad02.hotradius.com')\n");
  printf("              --radiusauthport=INT         Authentication UDP port of radius server (default='1812')\n");
  printf("              --radiusacctport=INT         Accounting UDP port of radius server (default='1813')\n");
  printf("              --radiussecret=STRING        Radius shared secret\n");
  printf("              --radiusnasid=STRING         Radius NAS-Identifier (default='nas01')\n");
  printf("              --radiuslocationid=STRING    WISPr Location ID\n");
  printf("              --radiuslocationname=STRING  WISPr Location Name\n");
  printf("              --proxylisten=STRING         IP address to listen to\n");
  printf("              --proxyport=INT              UDP port to listen to (default='0')\n");
  printf("              --proxyclient=STRING         IP address of proxy client(s)\n");
  printf("              --proxysecret=STRING         Radius proxy shared secret\n");
  printf("              --dhcpif=STRING              Local Ethernet interface\n");
  printf("              --dhcpmac=STRING             Interface MAC address\n");
  printf("              --lease=INT                  Lease time to allocate to clients (default='600')\n");
  printf("              --uamserver=STRING           URL of authentication web server (default='https://login.hotradius.com')\n");
  printf("              --uamsecret=STRING           Shared secret between uamserver and chilli\n");
  printf("              --uamlisten=STRING           IP address to listen to for authentication requests\n");
  printf("              --uamport=INT                TCP port to bind to for authentication requests (default='3990')\n");
  printf("              --uamallowed=STRING          Domain names exempt from access check \n");
}


#ifndef HAVE_STRDUP
/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}
#endif /* HAVE_STRDUP */

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->fg_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->conf_given = 0 ;
  args_info->pidfile_given = 0 ;
  args_info->statedir_given = 0 ;
  args_info->net_given = 0 ;
  args_info->dynip_given = 0 ;
  args_info->dns1_given = 0 ;
  args_info->dns2_given = 0 ;
  args_info->domain_given = 0 ;
  args_info->ipup_given = 0 ;
  args_info->ipdown_given = 0 ;
  args_info->radiuslisten_given = 0 ;
  args_info->radiusserver1_given = 0 ;
  args_info->radiusserver2_given = 0 ;
  args_info->radiusauthport_given = 0 ;
  args_info->radiusacctport_given = 0 ;
  args_info->radiussecret_given = 0 ;
  args_info->radiusnasid_given = 0 ;
  args_info->radiuslocationid_given = 0 ;
  args_info->radiuslocationname_given = 0 ;
  args_info->proxylisten_given = 0 ;
  args_info->proxyport_given = 0 ;
  args_info->proxyclient_given = 0 ;
  args_info->proxysecret_given = 0 ;
  args_info->dhcpif_given = 0 ;
  args_info->dhcpmac_given = 0 ;
  args_info->lease_given = 0 ;
  args_info->uamserver_given = 0 ;
  args_info->uamsecret_given = 0 ;
  args_info->uamlisten_given = 0 ;
  args_info->uamport_given = 0 ;
  args_info->uamallowed_given = 0 ;
#define clear_args() { \
  args_info->fg_flag = 0;\
  args_info->debug_flag = 0;\
  args_info->conf_arg = strdup("/etc/chilli.conf") ;\
  args_info->pidfile_arg = strdup("/var/run/chilli.pid") ;\
  args_info->statedir_arg = strdup("/var/lib/chilli/") ;\
  args_info->net_arg = strdup("192.168.182.0/24") ;\
  args_info->dynip_arg = NULL; \
  args_info->dns1_arg = NULL; \
  args_info->dns2_arg = NULL; \
  args_info->domain_arg = strdup("key.chillispot.org") ;\
  args_info->ipup_arg = NULL; \
  args_info->ipdown_arg = NULL; \
  args_info->radiuslisten_arg = NULL; \
  args_info->radiusserver1_arg = strdup("rad01.hotradius.com") ;\
  args_info->radiusserver2_arg = strdup("rad02.hotradius.com") ;\
  args_info->radiusauthport_arg = 1812 ;\
  args_info->radiusacctport_arg = 1813 ;\
  args_info->radiussecret_arg = NULL; \
  args_info->radiusnasid_arg = strdup("nas01") ;\
  args_info->radiuslocationid_arg = NULL; \
  args_info->radiuslocationname_arg = NULL; \
  args_info->proxylisten_arg = NULL; \
  args_info->proxyport_arg = 0 ;\
  args_info->proxyclient_arg = NULL; \
  args_info->proxysecret_arg = NULL; \
  args_info->dhcpif_arg = NULL; \
  args_info->dhcpmac_arg = NULL; \
  args_info->lease_arg = 600 ;\
  args_info->uamserver_arg = strdup("https://login.hotradius.com") ;\
  args_info->uamsecret_arg = NULL; \
  args_info->uamlisten_arg = NULL; \
  args_info->uamport_arg = 3990 ;\
  args_info->uamallowed_arg = NULL; \
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "fg",	0, NULL, 'f' },
        { "debug",	0, NULL, 'd' },
        { "conf",	1, NULL, 'c' },
        { "pidfile",	1, NULL, 0 },
        { "statedir",	1, NULL, 0 },
        { "net",	1, NULL, 'n' },
        { "dynip",	1, NULL, 0 },
        { "dns1",	1, NULL, 0 },
        { "dns2",	1, NULL, 0 },
        { "domain",	1, NULL, 0 },
        { "ipup",	1, NULL, 0 },
        { "ipdown",	1, NULL, 0 },
        { "radiuslisten",	1, NULL, 0 },
        { "radiusserver1",	1, NULL, 0 },
        { "radiusserver2",	1, NULL, 0 },
        { "radiusauthport",	1, NULL, 0 },
        { "radiusacctport",	1, NULL, 0 },
        { "radiussecret",	1, NULL, 0 },
        { "radiusnasid",	1, NULL, 0 },
        { "radiuslocationid",	1, NULL, 0 },
        { "radiuslocationname",	1, NULL, 0 },
        { "proxylisten",	1, NULL, 0 },
        { "proxyport",	1, NULL, 0 },
        { "proxyclient",	1, NULL, 0 },
        { "proxysecret",	1, NULL, 0 },
        { "dhcpif",	1, NULL, 0 },
        { "dhcpmac",	1, NULL, 0 },
        { "lease",	1, NULL, 0 },
        { "uamserver",	1, NULL, 0 },
        { "uamsecret",	1, NULL, 0 },
        { "uamlisten",	1, NULL, 0 },
        { "uamport",	1, NULL, 0 },
        { "uamallowed",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVfdc:n:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'f':	/* Run in foreground.  */
          if (args_info->fg_given)
            {
              fprintf (stderr, "%s: `--fg' (`-f') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->fg_given = 1;
          args_info->fg_flag = !(args_info->fg_flag);
          break;

        case 'd':	/* Run in debug mode.  */
          if (args_info->debug_given)
            {
              fprintf (stderr, "%s: `--debug' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->debug_given = 1;
          args_info->debug_flag = !(args_info->debug_flag);
          break;

        case 'c':	/* Read configuration file.  */
          if (args_info->conf_given)
            {
              fprintf (stderr, "%s: `--conf' (`-c') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->conf_given = 1;
          args_info->conf_arg = strdup (optarg);
          break;

        case 'n':	/* Network.  */
          if (args_info->net_given)
            {
              fprintf (stderr, "%s: `--net' (`-n') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->net_given = 1;
          args_info->net_arg = strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* Filename of process id file.  */
          if (strcmp (long_options[option_index].name, "pidfile") == 0)
          {
            if (args_info->pidfile_given)
              {
                fprintf (stderr, "%s: `--pidfile' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pidfile_given = 1;
            args_info->pidfile_arg = strdup (optarg);
            break;
          }
          /* Directory of nonvolatile data.  */
          else if (strcmp (long_options[option_index].name, "statedir") == 0)
          {
            if (args_info->statedir_given)
              {
                fprintf (stderr, "%s: `--statedir' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->statedir_given = 1;
            args_info->statedir_arg = strdup (optarg);
            break;
          }
          /* Dynamic IP address pool.  */
          else if (strcmp (long_options[option_index].name, "dynip") == 0)
          {
            if (args_info->dynip_given)
              {
                fprintf (stderr, "%s: `--dynip' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->dynip_given = 1;
            args_info->dynip_arg = strdup (optarg);
            break;
          }
          /* Primary DNS server IP address.  */
          else if (strcmp (long_options[option_index].name, "dns1") == 0)
          {
            if (args_info->dns1_given)
              {
                fprintf (stderr, "%s: `--dns1' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->dns1_given = 1;
            args_info->dns1_arg = strdup (optarg);
            break;
          }
          /* Secondary DNS server IP address.  */
          else if (strcmp (long_options[option_index].name, "dns2") == 0)
          {
            if (args_info->dns2_given)
              {
                fprintf (stderr, "%s: `--dns2' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->dns2_given = 1;
            args_info->dns2_arg = strdup (optarg);
            break;
          }
          /* Domain to use for DNS lookups.  */
          else if (strcmp (long_options[option_index].name, "domain") == 0)
          {
            if (args_info->domain_given)
              {
                fprintf (stderr, "%s: `--domain' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->domain_given = 1;
            args_info->domain_arg = strdup (optarg);
            break;
          }
          /* Script to run after link-up.  */
          else if (strcmp (long_options[option_index].name, "ipup") == 0)
          {
            if (args_info->ipup_given)
              {
                fprintf (stderr, "%s: `--ipup' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ipup_given = 1;
            args_info->ipup_arg = strdup (optarg);
            break;
          }
          /* Script to run after link-down.  */
          else if (strcmp (long_options[option_index].name, "ipdown") == 0)
          {
            if (args_info->ipdown_given)
              {
                fprintf (stderr, "%s: `--ipdown' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ipdown_given = 1;
            args_info->ipdown_arg = strdup (optarg);
            break;
          }
          /* IP address to send from.  */
          else if (strcmp (long_options[option_index].name, "radiuslisten") == 0)
          {
            if (args_info->radiuslisten_given)
              {
                fprintf (stderr, "%s: `--radiuslisten' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiuslisten_given = 1;
            args_info->radiuslisten_arg = strdup (optarg);
            break;
          }
          /* IP address of radius server 1.  */
          else if (strcmp (long_options[option_index].name, "radiusserver1") == 0)
          {
            if (args_info->radiusserver1_given)
              {
                fprintf (stderr, "%s: `--radiusserver1' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiusserver1_given = 1;
            args_info->radiusserver1_arg = strdup (optarg);
            break;
          }
          /* IP address of radius server 2.  */
          else if (strcmp (long_options[option_index].name, "radiusserver2") == 0)
          {
            if (args_info->radiusserver2_given)
              {
                fprintf (stderr, "%s: `--radiusserver2' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiusserver2_given = 1;
            args_info->radiusserver2_arg = strdup (optarg);
            break;
          }
          /* Authentication UDP port of radius server.  */
          else if (strcmp (long_options[option_index].name, "radiusauthport") == 0)
          {
            if (args_info->radiusauthport_given)
              {
                fprintf (stderr, "%s: `--radiusauthport' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiusauthport_given = 1;
            args_info->radiusauthport_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Accounting UDP port of radius server.  */
          else if (strcmp (long_options[option_index].name, "radiusacctport") == 0)
          {
            if (args_info->radiusacctport_given)
              {
                fprintf (stderr, "%s: `--radiusacctport' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiusacctport_given = 1;
            args_info->radiusacctport_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Radius shared secret.  */
          else if (strcmp (long_options[option_index].name, "radiussecret") == 0)
          {
            if (args_info->radiussecret_given)
              {
                fprintf (stderr, "%s: `--radiussecret' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiussecret_given = 1;
            args_info->radiussecret_arg = strdup (optarg);
            break;
          }
          /* Radius NAS-Identifier.  */
          else if (strcmp (long_options[option_index].name, "radiusnasid") == 0)
          {
            if (args_info->radiusnasid_given)
              {
                fprintf (stderr, "%s: `--radiusnasid' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiusnasid_given = 1;
            args_info->radiusnasid_arg = strdup (optarg);
            break;
          }
          /* WISPr Location ID.  */
          else if (strcmp (long_options[option_index].name, "radiuslocationid") == 0)
          {
            if (args_info->radiuslocationid_given)
              {
                fprintf (stderr, "%s: `--radiuslocationid' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiuslocationid_given = 1;
            args_info->radiuslocationid_arg = strdup (optarg);
            break;
          }
          /* WISPr Location Name.  */
          else if (strcmp (long_options[option_index].name, "radiuslocationname") == 0)
          {
            if (args_info->radiuslocationname_given)
              {
                fprintf (stderr, "%s: `--radiuslocationname' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->radiuslocationname_given = 1;
            args_info->radiuslocationname_arg = strdup (optarg);
            break;
          }
          /* IP address to listen to.  */
          else if (strcmp (long_options[option_index].name, "proxylisten") == 0)
          {
            if (args_info->proxylisten_given)
              {
                fprintf (stderr, "%s: `--proxylisten' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->proxylisten_given = 1;
            args_info->proxylisten_arg = strdup (optarg);
            break;
          }
          /* UDP port to listen to.  */
          else if (strcmp (long_options[option_index].name, "proxyport") == 0)
          {
            if (args_info->proxyport_given)
              {
                fprintf (stderr, "%s: `--proxyport' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->proxyport_given = 1;
            args_info->proxyport_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* IP address of proxy client(s).  */
          else if (strcmp (long_options[option_index].name, "proxyclient") == 0)
          {
            if (args_info->proxyclient_given)
              {
                fprintf (stderr, "%s: `--proxyclient' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->proxyclient_given = 1;
            args_info->proxyclient_arg = strdup (optarg);
            break;
          }
          /* Radius proxy shared secret.  */
          else if (strcmp (long_options[option_index].name, "proxysecret") == 0)
          {
            if (args_info->proxysecret_given)
              {
                fprintf (stderr, "%s: `--proxysecret' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->proxysecret_given = 1;
            args_info->proxysecret_arg = strdup (optarg);
            break;
          }
          /* Local Ethernet interface.  */
          else if (strcmp (long_options[option_index].name, "dhcpif") == 0)
          {
            if (args_info->dhcpif_given)
              {
                fprintf (stderr, "%s: `--dhcpif' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->dhcpif_given = 1;
            args_info->dhcpif_arg = strdup (optarg);
            break;
          }
          /* Interface MAC address.  */
          else if (strcmp (long_options[option_index].name, "dhcpmac") == 0)
          {
            if (args_info->dhcpmac_given)
              {
                fprintf (stderr, "%s: `--dhcpmac' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->dhcpmac_given = 1;
            args_info->dhcpmac_arg = strdup (optarg);
            break;
          }
          /* Lease time to allocate to clients.  */
          else if (strcmp (long_options[option_index].name, "lease") == 0)
          {
            if (args_info->lease_given)
              {
                fprintf (stderr, "%s: `--lease' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->lease_given = 1;
            args_info->lease_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* URL of authentication web server.  */
          else if (strcmp (long_options[option_index].name, "uamserver") == 0)
          {
            if (args_info->uamserver_given)
              {
                fprintf (stderr, "%s: `--uamserver' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->uamserver_given = 1;
            args_info->uamserver_arg = strdup (optarg);
            break;
          }
          /* Shared secret between uamserver and chilli.  */
          else if (strcmp (long_options[option_index].name, "uamsecret") == 0)
          {
            if (args_info->uamsecret_given)
              {
                fprintf (stderr, "%s: `--uamsecret' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->uamsecret_given = 1;
            args_info->uamsecret_arg = strdup (optarg);
            break;
          }
          /* IP address to listen to for authentication requests.  */
          else if (strcmp (long_options[option_index].name, "uamlisten") == 0)
          {
            if (args_info->uamlisten_given)
              {
                fprintf (stderr, "%s: `--uamlisten' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->uamlisten_given = 1;
            args_info->uamlisten_arg = strdup (optarg);
            break;
          }
          /* TCP port to bind to for authentication requests.  */
          else if (strcmp (long_options[option_index].name, "uamport") == 0)
          {
            if (args_info->uamport_given)
              {
                fprintf (stderr, "%s: `--uamport' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->uamport_given = 1;
            args_info->uamport_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Domain names exempt from access check .  */
          else if (strcmp (long_options[option_index].name, "uamallowed") == 0)
          {
            if (args_info->uamallowed_given)
              {
                fprintf (stderr, "%s: `--uamallowed' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->uamallowed_given = 1;
            args_info->uamallowed_arg = strdup (optarg);
            break;
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}

#define CONFIGPARSERBUFSIZE 1024

int
cmdline_parser_configfile (char * const filename, struct gengetopt_args_info *args_info, int override)
{
  FILE* file;
  char linebuf[CONFIGPARSERBUFSIZE];
  int line_num = 0;
  int len;
  int fnum;
  char fopt[CONFIGPARSERBUFSIZE], farg[CONFIGPARSERBUFSIZE];
  char *stop_char;

  if ((file = fopen(filename, "r")) == NULL)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               PACKAGE, filename);
      exit (EXIT_FAILURE);
    }

  while ((fgets(linebuf, CONFIGPARSERBUFSIZE, file)) != NULL)
    {
      ++line_num;
      len = strlen(linebuf);
      if (len == CONFIGPARSERBUFSIZE-1)
        {
          fprintf (stderr, "%s: Line longer than %d characters found in configuration file '%s'\n",
                   PACKAGE, CONFIGPARSERBUFSIZE, filename);
          exit (EXIT_FAILURE);
        }

      if (linebuf[0] == '#')
        continue; /* Line was a comment */
    
      /* Get the option */
      if ((fnum = sscanf(linebuf, "%s %s", fopt, farg)) > 0)
        {
          if (!strcmp(fopt, "help"))
            {
              if (override || !args_info->help_given)
                {
                  args_info->help_given = 1;
                  
                }
              continue;
            }
          if (!strcmp(fopt, "version"))
            {
              if (override || !args_info->version_given)
                {
                  args_info->version_given = 1;
                  
                }
              continue;
            }
          if (!strcmp(fopt, "fg"))
            {
              if (override || !args_info->fg_given)
                {
                  args_info->fg_given = 1;
                  args_info->fg_flag = !(args_info->fg_flag);
                }
              continue;
            }
          if (!strcmp(fopt, "debug"))
            {
              if (override || !args_info->debug_given)
                {
                  args_info->debug_given = 1;
                  args_info->debug_flag = !(args_info->debug_flag);
                }
              continue;
            }
          if (!strcmp(fopt, "conf"))
            {
              if (override || !args_info->conf_given)
                {
                  args_info->conf_given = 1;
                  if (fnum == 2)
                    args_info->conf_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pidfile"))
            {
              if (override || !args_info->pidfile_given)
                {
                  args_info->pidfile_given = 1;
                  if (fnum == 2)
                    args_info->pidfile_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "statedir"))
            {
              if (override || !args_info->statedir_given)
                {
                  args_info->statedir_given = 1;
                  if (fnum == 2)
                    args_info->statedir_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "net"))
            {
              if (override || !args_info->net_given)
                {
                  args_info->net_given = 1;
                  if (fnum == 2)
                    args_info->net_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "dynip"))
            {
              if (override || !args_info->dynip_given)
                {
                  args_info->dynip_given = 1;
                  if (fnum == 2)
                    args_info->dynip_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "dns1"))
            {
              if (override || !args_info->dns1_given)
                {
                  args_info->dns1_given = 1;
                  if (fnum == 2)
                    args_info->dns1_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "dns2"))
            {
              if (override || !args_info->dns2_given)
                {
                  args_info->dns2_given = 1;
                  if (fnum == 2)
                    args_info->dns2_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "domain"))
            {
              if (override || !args_info->domain_given)
                {
                  args_info->domain_given = 1;
                  if (fnum == 2)
                    args_info->domain_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "ipup"))
            {
              if (override || !args_info->ipup_given)
                {
                  args_info->ipup_given = 1;
                  if (fnum == 2)
                    args_info->ipup_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "ipdown"))
            {
              if (override || !args_info->ipdown_given)
                {
                  args_info->ipdown_given = 1;
                  if (fnum == 2)
                    args_info->ipdown_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiuslisten"))
            {
              if (override || !args_info->radiuslisten_given)
                {
                  args_info->radiuslisten_given = 1;
                  if (fnum == 2)
                    args_info->radiuslisten_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiusserver1"))
            {
              if (override || !args_info->radiusserver1_given)
                {
                  args_info->radiusserver1_given = 1;
                  if (fnum == 2)
                    args_info->radiusserver1_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiusserver2"))
            {
              if (override || !args_info->radiusserver2_given)
                {
                  args_info->radiusserver2_given = 1;
                  if (fnum == 2)
                    args_info->radiusserver2_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiusauthport"))
            {
              if (override || !args_info->radiusauthport_given)
                {
                  args_info->radiusauthport_given = 1;
                  if (fnum == 2)
                    args_info->radiusauthport_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiusacctport"))
            {
              if (override || !args_info->radiusacctport_given)
                {
                  args_info->radiusacctport_given = 1;
                  if (fnum == 2)
                    args_info->radiusacctport_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiussecret"))
            {
              if (override || !args_info->radiussecret_given)
                {
                  args_info->radiussecret_given = 1;
                  if (fnum == 2)
                    args_info->radiussecret_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiusnasid"))
            {
              if (override || !args_info->radiusnasid_given)
                {
                  args_info->radiusnasid_given = 1;
                  if (fnum == 2)
                    args_info->radiusnasid_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiuslocationid"))
            {
              if (override || !args_info->radiuslocationid_given)
                {
                  args_info->radiuslocationid_given = 1;
                  if (fnum == 2)
                    args_info->radiuslocationid_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "radiuslocationname"))
            {
              if (override || !args_info->radiuslocationname_given)
                {
                  args_info->radiuslocationname_given = 1;
                  if (fnum == 2)
                    args_info->radiuslocationname_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "proxylisten"))
            {
              if (override || !args_info->proxylisten_given)
                {
                  args_info->proxylisten_given = 1;
                  if (fnum == 2)
                    args_info->proxylisten_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "proxyport"))
            {
              if (override || !args_info->proxyport_given)
                {
                  args_info->proxyport_given = 1;
                  if (fnum == 2)
                    args_info->proxyport_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "proxyclient"))
            {
              if (override || !args_info->proxyclient_given)
                {
                  args_info->proxyclient_given = 1;
                  if (fnum == 2)
                    args_info->proxyclient_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "proxysecret"))
            {
              if (override || !args_info->proxysecret_given)
                {
                  args_info->proxysecret_given = 1;
                  if (fnum == 2)
                    args_info->proxysecret_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "dhcpif"))
            {
              if (override || !args_info->dhcpif_given)
                {
                  args_info->dhcpif_given = 1;
                  if (fnum == 2)
                    args_info->dhcpif_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "dhcpmac"))
            {
              if (override || !args_info->dhcpmac_given)
                {
                  args_info->dhcpmac_given = 1;
                  if (fnum == 2)
                    args_info->dhcpmac_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "lease"))
            {
              if (override || !args_info->lease_given)
                {
                  args_info->lease_given = 1;
                  if (fnum == 2)
                    args_info->lease_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "uamserver"))
            {
              if (override || !args_info->uamserver_given)
                {
                  args_info->uamserver_given = 1;
                  if (fnum == 2)
                    args_info->uamserver_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "uamsecret"))
            {
              if (override || !args_info->uamsecret_given)
                {
                  args_info->uamsecret_given = 1;
                  if (fnum == 2)
                    args_info->uamsecret_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "uamlisten"))
            {
              if (override || !args_info->uamlisten_given)
                {
                  args_info->uamlisten_given = 1;
                  if (fnum == 2)
                    args_info->uamlisten_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "uamport"))
            {
              if (override || !args_info->uamport_given)
                {
                  args_info->uamport_given = 1;
                  if (fnum == 2)
                    args_info->uamport_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "uamallowed"))
            {
              if (override || !args_info->uamallowed_given)
                {
                  args_info->uamallowed_given = 1;
                  if (fnum == 2)
                    args_info->uamallowed_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          

          /* Tried all known options. This one is unknown! */
          fprintf (stderr, "%s: Unknown option '%s' found in %s\n",
                   PACKAGE, fopt, filename);
          exit (EXIT_FAILURE);
        }
    } /* while */
  fclose(file); /* No error checking on close */

  return 0;
}
