#ifndef __MATRIXSSL_XFACE_H__
#define __MATRIXSSL_XFACE_H__

#include <stdio.h>
#include <matrixSsl.h>

#define DEBUG_MATRIXSSL 1

#define msslAssert(C)		if (C) ; else {fprintf(stderr, "%s:%d myAssert(%s)\n",\
						__FILE__, __LINE__, #C); abort(); }

extern ssl_t* ssl;
char * matrixssl_gets(FILE* fp, char* buf, int len);
int    matrixssl_puts(FILE* fp, char* buf);
int    matrixssl_printf(FILE* fp, char* fmt, char* buf);
int    matrixssl_write(FILE* fp, char* buf , int size);
int    matrixssl_read(FILE* fp, char* buf , int size);
int    matrixssl_flush(FILE* fp);
int    matrixssl_free_all(FILE* fp);
int    do_matrixssl_recv(FILE* fp, char* buf, int bufsize);
int    do_matrixssl_send(FILE* fp, char* buf, int bufsize);

#endif /* __MATRIXSSL_XFACE_H__ */

