
/*
 *********************************************************
 *   Copyright 2003, 2004 Sveasoft AB                    *
 *   All Rights Reserved                                 *
 *********************************************************

 This is SOURCE CODE developed by Sveasoft AB

 THIS SOFTWARE IS OFFERED "AS IS", AND SVEASOFT GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  SVEASOFT
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <sys/time.h>
#include <syslog.h>
#include <wait.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <wlutils.h>
#include <wlioctl.h>
#include <rc.h>

#include <cy_conf.h>
#include <utils.h>
#include <sveasoft.h>

#define WLAND_INTERVAL 15


static char* get_wdev()
{
//	if(check_hw_type() == BCM4702_CHIP)
//	  return "eth2";
//	else
	  return "eth1";

}


static int do_ap_check(void)
{

  //do_wds_check();

  /* AP Watchdog - experimental check and fix for hung AP */

  struct stat s;

  system("/usr/sbin/wl assoclist 2>&1 > /tmp/.assoclist");
  stat("/tmp/.assoclist", &s);
  unlink("/tmp/.assoclist");

  if( 	s.st_size <= 0 &&
  	nvram_match("apwatchdog_enable", "1") &&
	nvram_invmatch("wl_net_mode", "disabled")){

	int val = 0;

	cprintf("resetting ap radio\n");
	eval("/usr/sbin/wlconf", get_wdev(), "down");

	val = atoi(nvram_safe_get("wl0_channel"));
	if(val <=0 || val >= 14)
	 val = 2;

	wl_ioctl(get_wdev(), WLC_SET_CHANNEL, &val, sizeof(val));
	wl_ioctl(get_wdev(), WLC_UP, NULL, 0);

	eval("/usr/sbin/wlconf", get_wdev(), "down");
	eval("/usr/sbin/wlconf", get_wdev(), "up");

  }

  return 0;

}

/* for Client/Wet mode */
static int do_client_check(void)
{
	wlc_ssid_t ssid;
	int assoc=0;

	if(nvram_safe_get("wl0_ssid") == (void*)0)
	  return 0;

	memset(&ssid,0,sizeof(wlc_ssid_t));
	wl_ioctl(get_wdev(), WLC_GET_SSID, &ssid, sizeof(ssid));

	assoc = (ssid.SSID_len > 0) ? 1 : 0;

	if(!assoc){
	  /* let wl do this for us (no use in reinventing the wheel) */
          eval("wl", "join", nvram_safe_get("wl0_ssid"));
	}

	return 0;
}

static void do_wlan_check(void)
{

  if(nvram_match("wl0_mode", "wet"))
    do_client_check();
  else
    do_ap_check();

}


int wland_main(int argc, char **argv)
{
	/* Run it in the background */
	switch (fork()) {
	case -1:
		// can't fork
		exit(0);
		break;
	case 0:
		/* child process */
		// fork ok
		(void) setsid();
		break;
	default:
		/* parent process should just die */
		_exit(0);
	}

	/* Most of time it goes to sleep */
	while(1)
	{
	  int interval = atoi(nvram_safe_get("apwatchdog_interval")) > WLAND_INTERVAL ? atoi(nvram_safe_get("apwatchdog_interval")) : WLAND_INTERVAL;
	  do_wlan_check();
	  sleep(interval);
	}

	return 0;
} // end main

int stop_wland(void)
{
        int ret = eval("killall","-9", "wland");

        dprintf("done\n");
        return ret;
}

int start_wland(void)
{
	int ret;
	pid_t pid;
	char *wland_argv[] = { "wland",
		                NULL
		              };

	stop_wland();

	if( nvram_match("apwatchdog_enable", "0") )
	    return 0;

        ret = _eval(wland_argv, NULL, 0, &pid);
        dprintf("done\n");
        return ret;
}
