/* 
 * HTTP redirection functions.
 * Copyright (C) 2004 Mondru AB.
 * 
 * The contents of this file may be used under the terms of the GNU
 * General Public License Version 2, provided that the above copyright
 * notice and this permission notice is included in all copies or
 * substantial portions of the software.
 * 
 */

/*
 * This file was born and grown as part of chillispot.org.
 */


#ifndef _REDIR_H
#define _REDIR_H

#define REDIR_MAXLISTEN 3

#define REDIR_MAXTIME 100 /* Seconds */
#define REDIR_IDLETIME 5  /* Seconds */
#define REDIR_CHALLEN 16
#define REDIR_MD5LEN 16

#define REDIR_MAXCHAR 256

#define REDIR_MAXCONN 16

#define REDIR_CHALLENGETIMEOUT1 300 /* Seconds */
#define REDIR_CHALLENGETIMEOUT2 600 /* Seconds */

#define REDIR_SESSIONID_LEN 17

#define REDIR_URL_LEN 250

#define REDIR_LOGOFF     1
#define REDIR_LOGON      2
#define REDIR_CHALLENGE  3
#define REDIR_MSDOWNLOAD 25


struct redir_conn_t {

  /* Parameters from HTTP request */
  int type; /* REDIR_LOGOFF, LOGON, CHALLENGE, MSDOWNLOAD */
  char username[REDIR_MAXCHAR];
  char userurl[REDIR_MAXCHAR];
  int chap; /* 0 if using normal password; 1 if using CHAP */
  uint8_t chappassword[REDIR_MAXCHAR];
  uint8_t password[REDIR_MAXCHAR];
  
  /* Challenge as sent to web server */
  uint8_t uamchal[REDIR_MD5LEN];
  int uamtime;

  int authenticated;           /* 1 if user was authenticated */  
  struct in_addr nasip;
  uint32_t nasport;
  uint8_t hismac[ETH_ALEN];    /* His MAC address */
  uint8_t ourmac[ETH_ALEN];    /* Our MAC address */
  struct in_addr ourip;        /* IP address to listen to */
  struct in_addr hisip;        /* Client IP address */
  char sessionid[REDIR_SESSIONID_LEN]; /* Accounting session ID */
  int response; /* 0: No adius response yet; 1:Reject; 2:Accept; 3:Timeout */
  long int sessiontimeout;
  long int idletimeout;
  long int interim_interval;  /* Interim accounting */
  uint8_t redirurlbuf[RADIUS_ATTR_VLEN+1];
  int redirurllen;
  char replybuf[RADIUS_ATTR_VLEN+1];
  uint8_t statebuf[RADIUS_ATTR_VLEN+1];
  int statelen;
  uint8_t classbuf[RADIUS_ATTR_VLEN+1];
  int classlen;
  int bandwidthmaxup;
  int bandwidthmaxdown;
  time_t sessionterminatetime;
};

struct redir_t {
  int fd;                /* File descriptor */
  int msgid;             /* Message Queue */
  struct in_addr addr;
  int port;
  char *url;
  char *secret;
  struct in_addr radiuslisten;
  struct in_addr radiusserver0;
  struct in_addr radiusserver1;
  uint16_t radiusauthport;
  uint16_t radiusacctport;
  char *radiussecret;
  char *radiusnasid;
  char* radiuslocationid;
  char* radiuslocationname;
  int starttime;
  int (*cb_getstate) (struct redir_t *redir, struct in_addr *addr,
		      struct redir_conn_t *conn);
};


struct redir_msg_t {
  long int type;
  long int interim_interval;
  long int sessiontimeout;
  long int idletimeout;
  struct in_addr addr;
  char username[REDIR_MAXCHAR];
  char userurl[REDIR_MAXCHAR];
  uint8_t uamchal[REDIR_MD5LEN];
  uint8_t statebuf[RADIUS_ATTR_VLEN];
  int statelen;
  uint8_t classbuf[RADIUS_ATTR_VLEN];
  int classlen;
  int bandwidthmaxup;
  int bandwidthmaxdown;
  int sessionterminatetime;
};


extern int redir_new(struct redir_t **redir, struct in_addr *addr, int port,
		     char *url, char *secret,
		     struct in_addr *radiuslisten, 
		     struct in_addr *radiusserver0, 
		     struct in_addr *radiusserver1,
		     uint16_t radiusauthport, uint16_t radiusacctport,
		     char* radiussecret, char* radiusnasid,
		     char* radiuslocationid, char* radiuslocationname);

extern int redir_free(struct redir_t *redir);


extern int redir_accept(struct redir_t *redir);


extern int redir_setchallenge(struct redir_t *redir, struct in_addr *addr,
			      unsigned char *challenge);

extern int redir_set_cb_getstate(struct redir_t *redir,
  int (*cb_getstate) (struct redir_t *redir, struct in_addr *addr,
		      struct redir_conn_t *conn));


#endif	/* !_REDIR_H */
