#ifndef lint
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.28 2000/01/17 02:04:06 bde Exp $";
#endif
#include <stdlib.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
static int yygrowstack();
#define yyparse knparse
#define yylex knlex
#define yyerror knerror
#define yychar knchar
#define yyval knval
#define yylval knlval
#define yydebug kndebug
#define yynerrs knnerrs
#define yyerrflag knerrflag
#define yyss knss
#define yyssp knssp
#define yyvs knvs
#define yyvsp knvsp
#define yylhs knlhs
#define yylen knlen
#define yydefred kndefred
#define yydgoto kndgoto
#define yysindex knsindex
#define yyrindex knrindex
#define yygindex kngindex
#define yytable kntable
#define yycheck kncheck
#define yyname knname
#define yyrule knrule
#define yysslim knsslim
#define yystacksize knstacksize
#define YYPREFIX "kn"
#line 20 "keynote.y"
typedef union {
    char   *string;
    double  doubval;
    int     intval;
    int     bool;
} YYSTYPE;
#line 45 "keynote.y"
#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>

#if STDC_HEADERS
#include <string.h>
#endif /* STDC_HEADERS */

#include "header.h"
#include "keynote.h"
#include "assertion.h"

static int *keynote_kth_array = (int *) NULL;
static int keylistcount = 0;

static int   resolve_assertion(char *);
static int   keynote_init_kth(void);
static int   isfloatstring(char *);
static int   checkexception(int);
static char *my_lookup(char *);
static int   intpow(int, int);
static int   get_kth(int);
#line 79 "k.tab.c"
#define YYERRCODE 256
#define NUM 257
#define KOF 258
#define FLOAT 259
#define STRING 260
#define VARIABLE 261
#define TRUE 262
#define FALSE 263
#define OPENPAREN 264
#define CLOSEPAREN 265
#define EQQ 266
#define COMMA 267
#define ACTSTR 268
#define LOCINI 269
#define KEYPRE 270
#define KNVERSION 271
#define DOTT 272
#define SIGNERKEY 273
#define HINT 274
#define OPENBLOCK 275
#define CLOSEBLOCK 276
#define SIGNATUREENTRY 277
#define PRIVATEKEY 278
#define SEMICOLON 279
#define EQ 280
#define NE 281
#define LT 282
#define GT 283
#define LE 284
#define GE 285
#define REGEXP 286
#define OR 287
#define AND 288
#define NOT 289
#define PLUS 290
#define MINUS 291
#define MULT 292
#define DIV 293
#define MOD 294
#define EXP 295
#define UNARYMINUS 296
#define DEREF 297
#define OPENNUM 298
#define OPENFLT 299
const short knlhs[] = {                                        -1,
   17,    0,   19,    0,   21,    0,   22,    0,   23,    0,
   24,    0,   25,    0,   20,   20,    8,    8,   26,   11,
   27,   11,   11,   28,   29,   11,   12,   12,   10,   16,
   16,   30,   31,   30,   18,    9,   32,    9,    7,    7,
    6,    6,    3,   33,    3,   34,    3,    3,    3,    3,
    3,    3,    3,    2,    2,    2,    2,    2,    2,    4,
    4,    4,    4,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,   13,   13,   13,   13,   13,   13,   13,
   13,   13,    1,    1,    1,    1,    1,    1,    1,   14,
   14,   15,   15,   15,   15,
};
const short knlen[] = {                                         2,
    0,    3,    0,    3,    0,    3,    0,    3,    0,    3,
    0,    3,    0,    3,    0,    1,    1,    1,    0,    4,
    0,    4,    3,    0,    0,    6,    1,    3,    1,    0,
    1,    3,    0,    5,    1,    0,    0,    4,    3,    1,
    1,    3,    3,    0,    4,    0,    4,    2,    1,    1,
    1,    1,    1,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    2,
    3,    1,    2,    3,    3,    3,    3,    3,    2,    3,
    1,    2,    3,    3,    3,    3,    3,    3,    3,    3,
    1,    1,    3,    1,    2,
};
const short kndefred[] = {                                      0,
    3,    1,    5,   11,    7,    9,   13,    0,    0,    0,
    0,    0,    0,    0,    0,   72,   81,   92,   94,   52,
   53,    0,    0,    0,    0,    0,    0,   51,   49,    0,
   50,    0,   37,   35,    0,    0,   91,    4,    0,    2,
   31,   24,    0,    0,   17,   18,    0,    6,   12,    0,
    8,   10,   14,    0,    0,    0,    0,   48,    0,   70,
   79,   95,   73,   82,    0,   46,   44,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   21,   19,    0,   43,   71,   80,   93,    0,
    0,    0,   39,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   69,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   78,   90,    0,    0,    0,    0,    0,    0,    0,
    0,   25,   23,    0,    0,    0,    0,   45,   38,    0,
    0,    0,   20,   42,   34,    0,    0,    0,   26,   28,
};
const short kndgoto[] = {                                       8,
   28,   29,   30,   31,   32,  113,   33,   44,   34,   45,
   46,  167,   35,   47,   37,   40,   10,   38,    9,   48,
   11,   13,   14,   12,   15,  155,  154,   99,  161,   41,
  160,   80,  116,  115,
};
const short knsindex[] = {                                    254,
    0,    0,    0,    0,    0,    0,    0,    0, -240, -236,
 -147, -249, -133, -133, -214,    0,    0,    0,    0,    0,
    0, -240, -240, -231, -133, -133, -133,    0,    0, -113,
    0,  205,    0,    0,  226,  221,    0,    0, -216,    0,
    0,    0, -147, -233,    0,    0, -241,    0,    0, -133,
    0,    0,    0, -250, -114, -100,  198,    0, -231,    0,
    0,    0,    0,    0, -135,    0,    0, -149, -149, -149,
 -149, -149, -149, -149, -149, -149, -149, -149, -149, -174,
 -155, -155, -155, -155, -155, -155, -155, -155, -155, -133,
 -133, -133, -133, -133, -133, -133, -133, -150, -152, -233,
 -141, -230,    0,    0, -230,    0,    0,    0,    0, -229,
  -93, -240,    0, -241, -240, -240, -149, -149,  243,  243,
  243,  243,  243,  243, -106, -106, -179, -179, -179,    0,
 -240, -155, -155,  249,  249,  249,  249,  -88,  -88, -165,
 -165,    0,    0, -241, -241, -241, -241, -241, -241, -241,
    0,    0,    0, -147, -147, -143, -153,    0,    0, -236,
 -133, -136,    0,    0,    0, -126, -118, -133,    0,    0,
};
const short knrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,  163,  173,
  196,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  -78,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  206,    0,    0,    1,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -209, -129,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -58,    0,  -54,    0,    0,    0,    0, -235, -142,
 -131,   -2,    5,  118,  -29,   67,  -71,  -50,   16,    0,
    2,    0,    0,  124,  130,  134,  136,   88,  103,   37,
   52,    0,    0,  151,  154,  161,  171,  178,  181,  188,
    3,    0,    0,    0,    0,    0, -247,    0,    0,    0,
    0,    4,    0,    0,    0,  -39,    0,    0,    0,    0,
};
const short kngindex[] = {                                      0,
    0,    0,  -14,    0,   21,    0,    0,  -36,  -83,   -8,
  184,   60,  -12,   -9,  128,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
    0,    0,    0,    0,
};
#define YYTABLESIZE 544
const short kntable[] = {                                      36,
   29,   36,   32,   22,   51,   52,  100,   54,   58,   56,
   49,   61,   57,   36,  106,   62,   16,   47,   17,   18,
   19,   20,   21,   22,   39,   16,   47,   17,  156,   56,
   90,   47,   59,  102,  109,  107,   66,   67,   56,   47,
  105,   90,   55,   56,   60,   53,  111,  159,   23,   98,
   24,   56,   56,  103,  104,  114,   25,   26,   27,   24,
   74,   75,   76,   77,   78,   79,   26,   27,  134,  135,
  136,  137,  138,  139,  140,  141,  142,   18,   18,  110,
  143,  144,  145,  146,  147,  148,  149,  150,  119,  120,
  121,  122,  123,  124,  125,  126,  127,  128,  129,  130,
  157,  158,   36,   17,  131,   36,   36,   16,  132,  151,
   42,  152,   18,   19,  117,   79,   43,  162,  163,  111,
   61,   36,   59,  153,   18,   19,   18,   19,   50,   89,
   50,   59,  164,   54,   67,  133,   59,  110,   60,  112,
  168,  118,   54,   27,   59,   59,  169,   54,   26,   25,
  107,  104,  166,   63,   64,   54,   54,   29,   29,  166,
   65,   25,   36,   25,  108,   68,   69,   70,   71,   72,
   73,  108,   30,   66,   67,   74,   75,   76,   77,   78,
   79,   81,   82,   83,   84,   76,   77,   78,   79,   85,
   86,   87,   88,   66,   89,   15,   85,   86,   87,   88,
   40,   89,   66,   87,   88,   16,   89,   66,   66,   66,
   66,   66,   66,   66,   67,   66,   66,   36,   66,   66,
   66,   66,   66,   67,   41,   27,  101,  170,   67,   67,
   67,   67,   67,   67,   67,   64,   67,   67,  165,   67,
   67,   67,   67,   67,   64,    0,    0,    0,    0,   64,
   64,   64,   64,   64,   64,   64,    0,   64,   64,    0,
   64,   64,   55,   33,    0,   29,    0,   29,   22,   57,
    0,   55,    0,    0,    0,    0,   55,   36,   57,    0,
   68,    0,    0,   57,   55,   55,    0,   29,   29,   68,
   22,   57,   57,    0,   68,   68,   68,   68,   68,   68,
   68,   76,   68,   68,    0,   68,   68,   68,   68,   68,
   76,    0,    0,    0,    0,   76,   77,    0,   76,   76,
   76,   76,    0,   76,   76,   77,   76,   76,   76,   76,
   77,   65,    0,   77,   77,   77,   77,    0,   77,   77,
   65,   77,   77,   77,   77,   65,   65,   65,   65,   65,
   65,   65,   74,   65,   65,    0,   65,   65,    0,    0,
    0,   74,    0,    0,    0,    0,   74,   75,    0,   74,
   74,   74,   74,    0,   74,   74,   75,   74,   74,    0,
    0,   75,   58,    0,   75,   75,   75,   75,   60,   75,
   75,   58,   75,   75,   61,    0,   58,   60,   62,    0,
   63,    0,   60,   61,   58,   58,    0,   62,   61,   63,
   60,   60,   62,    0,   63,   83,   61,   61,   84,    0,
   62,   62,   63,   63,   83,   85,    0,   84,    0,   83,
    0,    0,   84,    0,   85,   86,    0,   83,   83,   85,
   84,   84,   87,    0,   86,   88,    0,   85,   85,   86,
    0,   87,   89,    0,   88,    0,   87,   86,   86,   88,
    0,   89,  109,    0,   87,   87,   89,   88,   88,   90,
    0,    0,    0,    0,   89,   89,    0,   91,   92,   93,
   94,   95,   96,   97,   68,   69,   70,   71,   72,   73,
    0,    0,   90,    0,   74,   75,   76,   77,   78,   79,
   91,   92,   93,   94,   95,   96,   97,   81,   82,   83,
   84,    0,    0,    0,    0,   85,   86,   87,   88,    0,
   89,    1,    2,    3,    4,    0,    5,    0,    0,    0,
    6,    7,   74,   75,   76,   77,   78,   79,   85,   86,
   87,   88,    0,   89,
};
const short kncheck[] = {                                       9,
    0,    0,    0,    0,   13,   14,   43,   22,   23,   22,
  260,   24,   22,   23,  265,   25,  257,  265,  259,  260,
  261,  262,  263,  264,  261,  257,  274,  259,  112,  265,
  272,  279,  264,   43,  265,  265,  287,  288,  274,  287,
   50,  272,   22,  279,   24,  260,   59,  131,  289,  266,
  291,  287,  288,  287,  288,   65,  297,  298,  299,  291,
  290,  291,  292,  293,  294,  295,  298,  299,   81,   82,
   83,   84,   85,   86,   87,   88,   89,  287,  288,   59,
   90,   91,   92,   93,   94,   95,   96,   97,   68,   69,
   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
  115,  116,  112,  259,  279,  115,  116,  257,  264,  260,
  258,  264,  260,  261,  264,  295,  264,  154,  155,  132,
  133,  131,  265,  265,  260,  261,  260,  261,  264,  295,
  264,  274,  276,  265,  288,  291,  279,  117,  118,  275,
  267,  291,  274,  299,  287,  288,  265,  279,  298,  297,
  265,  288,  161,   26,   27,  287,  288,  287,  288,  168,
  274,  297,    0,  297,  265,  280,  281,  282,  283,  284,
  285,  265,    0,  287,  288,  290,  291,  292,  293,  294,
  295,  282,  283,  284,  285,  292,  293,  294,  295,  290,
  291,  292,  293,  265,  295,    0,  290,  291,  292,  293,
  279,  295,  274,  292,  293,    0,  295,  279,  280,  281,
  282,  283,  284,  285,  265,  287,  288,  276,  290,  291,
  292,  293,  294,  274,  279,  265,   43,  168,  279,  280,
  281,  282,  283,  284,  285,  265,  287,  288,  160,  290,
  291,  292,  293,  294,  274,   -1,   -1,   -1,   -1,  279,
  280,  281,  282,  283,  284,  285,   -1,  287,  288,   -1,
  290,  291,  265,  261,   -1,  265,   -1,  267,  265,  265,
   -1,  274,   -1,   -1,   -1,   -1,  279,  276,  274,   -1,
  265,   -1,   -1,  279,  287,  288,   -1,  287,  288,  274,
  287,  287,  288,   -1,  279,  280,  281,  282,  283,  284,
  285,  265,  287,  288,   -1,  290,  291,  292,  293,  294,
  274,   -1,   -1,   -1,   -1,  279,  265,   -1,  282,  283,
  284,  285,   -1,  287,  288,  274,  290,  291,  292,  293,
  279,  265,   -1,  282,  283,  284,  285,   -1,  287,  288,
  274,  290,  291,  292,  293,  279,  280,  281,  282,  283,
  284,  285,  265,  287,  288,   -1,  290,  291,   -1,   -1,
   -1,  274,   -1,   -1,   -1,   -1,  279,  265,   -1,  282,
  283,  284,  285,   -1,  287,  288,  274,  290,  291,   -1,
   -1,  279,  265,   -1,  282,  283,  284,  285,  265,  287,
  288,  274,  290,  291,  265,   -1,  279,  274,  265,   -1,
  265,   -1,  279,  274,  287,  288,   -1,  274,  279,  274,
  287,  288,  279,   -1,  279,  265,  287,  288,  265,   -1,
  287,  288,  287,  288,  274,  265,   -1,  274,   -1,  279,
   -1,   -1,  279,   -1,  274,  265,   -1,  287,  288,  279,
  287,  288,  265,   -1,  274,  265,   -1,  287,  288,  279,
   -1,  274,  265,   -1,  274,   -1,  279,  287,  288,  279,
   -1,  274,  265,   -1,  287,  288,  279,  287,  288,  272,
   -1,   -1,   -1,   -1,  287,  288,   -1,  280,  281,  282,
  283,  284,  285,  286,  280,  281,  282,  283,  284,  285,
   -1,   -1,  272,   -1,  290,  291,  292,  293,  294,  295,
  280,  281,  282,  283,  284,  285,  286,  282,  283,  284,
  285,   -1,   -1,   -1,   -1,  290,  291,  292,  293,   -1,
  295,  268,  269,  270,  271,   -1,  273,   -1,   -1,   -1,
  277,  278,  290,  291,  292,  293,  294,  295,  290,  291,
  292,  293,   -1,  295,
};
#define YYFINAL 8
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 299
#if YYDEBUG
const char * const knname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NUM","KOF","FLOAT","STRING",
"VARIABLE","TRUE","FALSE","OPENPAREN","CLOSEPAREN","EQQ","COMMA","ACTSTR",
"LOCINI","KEYPRE","KNVERSION","DOTT","SIGNERKEY","HINT","OPENBLOCK",
"CLOSEBLOCK","SIGNATUREENTRY","PRIVATEKEY","SEMICOLON","EQ","NE","LT","GT","LE",
"GE","REGEXP","OR","AND","NOT","PLUS","MINUS","MULT","DIV","MOD","EXP",
"UNARYMINUS","DEREF","OPENNUM","OPENFLT",
};
const char * const knrule[] = {
"$accept : grammarswitch",
"$$1 :",
"grammarswitch : LOCINI $$1 localinit",
"$$2 :",
"grammarswitch : ACTSTR $$2 program",
"$$3 :",
"grammarswitch : KEYPRE $$3 keypredicate",
"$$4 :",
"grammarswitch : SIGNERKEY $$4 key",
"$$5 :",
"grammarswitch : SIGNATUREENTRY $$5 key",
"$$6 :",
"grammarswitch : KNVERSION $$6 STRING",
"$$7 :",
"grammarswitch : PRIVATEKEY $$7 STRING",
"keypredicate :",
"keypredicate : notemptykeypredicate",
"notemptykeypredicate : key",
"notemptykeypredicate : keyexp",
"$$8 :",
"keyexp : notemptykeypredicate AND $$8 notemptykeypredicate",
"$$9 :",
"keyexp : notemptykeypredicate OR $$9 notemptykeypredicate",
"keyexp : OPENPAREN keyexp CLOSEPAREN",
"$$10 :",
"$$11 :",
"keyexp : KOF $$10 OPENPAREN $$11 keylist CLOSEPAREN",
"keylist : key",
"keylist : key COMMA keylist",
"key : str",
"localinit :",
"localinit : localconstants",
"localconstants : VARIABLE EQQ STRING",
"$$12 :",
"localconstants : VARIABLE EQQ STRING $$12 localconstants",
"program : prog",
"prog :",
"$$13 :",
"prog : notemptyprog $$13 SEMICOLON prog",
"notemptyprog : expr HINT afterhint",
"notemptyprog : expr",
"afterhint : str",
"afterhint : OPENBLOCK prog CLOSEBLOCK",
"expr : OPENPAREN expr CLOSEPAREN",
"$$14 :",
"expr : expr AND $$14 expr",
"$$15 :",
"expr : expr OR $$15 expr",
"expr : NOT expr",
"expr : numexp",
"expr : floatexp",
"expr : stringexp",
"expr : TRUE",
"expr : FALSE",
"numexp : numex LT numex",
"numexp : numex GT numex",
"numexp : numex EQ numex",
"numexp : numex LE numex",
"numexp : numex GE numex",
"numexp : numex NE numex",
"floatexp : floatex LT floatex",
"floatexp : floatex GT floatex",
"floatexp : floatex LE floatex",
"floatexp : floatex GE floatex",
"numex : numex PLUS numex",
"numex : numex MINUS numex",
"numex : numex MULT numex",
"numex : numex DIV numex",
"numex : numex MOD numex",
"numex : numex EXP numex",
"numex : MINUS numex",
"numex : OPENPAREN numex CLOSEPAREN",
"numex : NUM",
"numex : OPENNUM strnotconcat",
"floatex : floatex PLUS floatex",
"floatex : floatex MINUS floatex",
"floatex : floatex MULT floatex",
"floatex : floatex DIV floatex",
"floatex : floatex EXP floatex",
"floatex : MINUS floatex",
"floatex : OPENPAREN floatex CLOSEPAREN",
"floatex : FLOAT",
"floatex : OPENFLT strnotconcat",
"stringexp : str EQ str",
"stringexp : str NE str",
"stringexp : str LT str",
"stringexp : str GT str",
"stringexp : str LE str",
"stringexp : str GE str",
"stringexp : str REGEXP str",
"str : str DOTT str",
"str : strnotconcat",
"strnotconcat : STRING",
"strnotconcat : OPENPAREN str CLOSEPAREN",
"strnotconcat : VARIABLE",
"strnotconcat : DEREF str",
};
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
#line 664 "keynote.y"

/*
 * Find all assertions signed by s and give us the one with the highest
 * return value.
 */
static int
resolve_assertion(char *s)
{
    int i, alg = KEYNOTE_ALGORITHM_NONE, p = 0;
    void *key = (void *) s;
    struct assertion *as;
    struct keylist *kl;

    kl = keynote_keylist_find(keynote_current_assertion->as_keylist, s);
    if (kl != (struct keylist *) NULL)
    {
	alg = kl->key_alg;
	key = kl->key_key;
    }

    for (i = 0;; i++)
    {
	as = keynote_find_assertion(key, i, alg);
	if (as == (struct assertion *) NULL)  /* Gone through all of them */
	  return p;

	if (as->as_kresult == KRESULT_DONE)
	  if (p < as->as_result)
	    p = as->as_result;

	/* Short circuit if we find an assertion with maximum return value */
	if (p == (keynote_current_session->ks_values_num - 1))
	  return p;
    }

    return 0;
}

/* 
 * Environment variable lookup. 
 */
static char *
my_lookup(char *s)
{
    struct keynote_session *ks = keynote_current_session;
    char *ret;

    if (!strcmp(s, "_MIN_TRUST"))
    {
	keynote_used_variable = 1;
	return ks->ks_values[0];
    }
    else
    {
	if (!strcmp(s, "_MAX_TRUST"))
	{
	    keynote_used_variable = 1;
	    return ks->ks_values[ks->ks_values_num - 1];
	}
	else
	{
	    if (!strcmp(s, "_VALUES"))
	    {
		keynote_used_variable = 1;
		return keynote_env_lookup("_VALUES", ks->ks_env_table,
					  HASHTABLESIZE);
	    }
	    else
	    {
		if (!strcmp(s, "_ACTION_AUTHORIZERS"))
		{
		    keynote_used_variable = 1;
		    return keynote_env_lookup("_ACTION_AUTHORIZERS",
					      ks->ks_env_table, HASHTABLESIZE);
		}
	    }
	}
    }

    /* Temporary list (regexp results) */
    ret = keynote_env_lookup(s, &keynote_temp_list, 1);
    if (ret != (char *) NULL)
      return ret;
    else
      if (keynote_errno != 0)
	return (char *) NULL;

    /* Local-Constants */
    ret = keynote_env_lookup(s, &keynote_init_list, 1);
    if (ret != (char *) NULL)
      return ret;
    else
      if (keynote_errno != 0)
	return (char *) NULL;

    keynote_used_variable = 1;

    /* Action environment */
    ret = keynote_env_lookup(s, ks->ks_env_table, HASHTABLESIZE);
    if (ret != (char *) NULL)
      return ret;
    else
      if (keynote_errno != 0)
	return (char *) NULL;

    /* Regex table */
    return keynote_env_lookup(s, &(ks->ks_env_regex), 1);
}

/*
 * If we had an exception, the boolean expression should return false.
 * Otherwise, return the result of the expression (the argument).
 */
static int
checkexception(int i)
{
    if (keynote_exceptionflag)
    {
	keynote_exceptionflag = 0;
	return 0;
    }
    else
      return i;
}


/* 
 * Integer exponentation -- copied from Schneier's AC2, page 244. 
 */
static int
intpow(int x, int y)
{
    int s = 1;
    
    /* 
     * x^y with y < 0 is equivalent to 1/(x^y), which for
     * integer arithmetic is 0.
     */
    if (y < 0)
      return 0;

    while (y)
    {
	if (y & 1)
	  s *= x;
	
	y >>= 1;
	x *= x;
    }

    return s;
}

/* 
 * Check whether the string is a floating point number. 
 */
static int
isfloatstring(char *s)
{
    int i, point = 0;
    
    for (i = strlen(s) - 1; i >= 0; i--)
      if (!isdigit((int) s[i]))
      {
	  if (s[i] == '.')
	  {
	      if (point == 1)
	        return 0;
	      else
	        point = 1;
	  }
	  else
	    return 0;
      }

    return 1;
}

/*
 * Initialize array for threshold search.
 */
static int
keynote_init_kth(void)
{
    int i = keynote_current_session->ks_values_num;
    
    if (i == -1)
      return -1;
    
    keynote_kth_array = (int *) calloc(i, sizeof(int));
    if (keynote_kth_array == (int *) NULL)
    {
	keynote_errno = ERROR_MEMORY;
	return -1;
    }

    return RESULT_TRUE;
}

/*
 * Get the k-th best return value.
 */
static int
get_kth(int k)
{
    int i;

    for (i = keynote_current_session->ks_values_num - 1; i >= 0; i--)
    {
	k -= keynote_kth_array[i];
	
	if (k <= 0)
	  return i;
    }

    return 0;
}

/*
 * Cleanup array.
 */
void
keynote_cleanup_kth(void)
{
    if (keynote_kth_array != (int *) NULL)
    {
	free(keynote_kth_array);
	keynote_kth_array = (int *) NULL;
    }
}

void
knerror(char *s)
{}
#line 713 "k.tab.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack()
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 76 "keynote.y"
{ keynote_exceptionflag = keynote_donteval = 0; }
break;
case 3:
#line 78 "keynote.y"
{ keynote_exceptionflag = keynote_donteval = 0; }
break;
case 5:
#line 79 "keynote.y"
{ keynote_exceptionflag = keynote_donteval = 0; }
break;
case 7:
#line 81 "keynote.y"
{ keynote_exceptionflag = keynote_donteval = 0; }
break;
case 9:
#line 82 "keynote.y"
{ keynote_exceptionflag = keynote_donteval = 0; }
break;
case 11:
#line 84 "keynote.y"
{ keynote_exceptionflag = keynote_donteval = 0; }
break;
case 12:
#line 85 "keynote.y"
{ keynote_lex_remove(yyvsp[0].string);
				 if (strcmp(yyvsp[0].string, KEYNOTE_VERSION_STRING))
				   keynote_errno = ERROR_SYNTAX;
				 free(yyvsp[0].string);
			       }
break;
case 13:
#line 90 "keynote.y"
{ keynote_exceptionflag = keynote_donteval = 0; }
break;
case 14:
#line 91 "keynote.y"
{ keynote_lex_remove(yyvsp[0].string);
			         keynote_privkey = yyvsp[0].string;
			       }
break;
case 15:
#line 95 "keynote.y"
{ keynote_returnvalue = 0;
                                return 0; 
                              }
break;
case 16:
#line 98 "keynote.y"
{ keynote_returnvalue = yyvsp[0].intval;
				return 0;
                              }
break;
case 17:
#line 102 "keynote.y"
{ yyval.intval = yyvsp[0].intval; }
break;
case 18:
#line 103 "keynote.y"
{ yyval.intval = yyvsp[0].intval; }
break;
case 19:
#line 105 "keynote.y"
{ if ((yyvsp[-1].intval == 0) && !keynote_justrecord)
                                     keynote_donteval = 1;
                                 }
break;
case 20:
#line 108 "keynote.y"
{ if (yyvsp[-3].intval > yyvsp[0].intval)
		     yyval.intval = yyvsp[0].intval;
		   else
	       	     yyval.intval = yyvsp[-3].intval;
		   keynote_donteval = 0;
                 }
break;
case 21:
#line 114 "keynote.y"
{ if ((yyvsp[-1].intval == (keynote_current_session->ks_values_num - 1)) && !keynote_justrecord)
	                             keynote_donteval = 1;
       	                         }
break;
case 22:
#line 117 "keynote.y"
{ if (yyvsp[-3].intval >= yyvsp[0].intval)
		     yyval.intval = yyvsp[-3].intval;
		   else
		     yyval.intval = yyvsp[0].intval;
		   keynote_donteval = 0;
                 }
break;
case 23:
#line 123 "keynote.y"
{ yyval.intval = yyvsp[-1].intval; }
break;
case 24:
#line 124 "keynote.y"
{ keylistcount = 0; }
break;
case 25:
#line 124 "keynote.y"
{
			 if (!keynote_justrecord && !keynote_donteval)
 	                   if (keynote_init_kth() == -1)
			     return -1;
                       }
break;
case 26:
#line 129 "keynote.y"
{
			      if (keylistcount < yyvsp[-5].intval)
			      {
				  keynote_errno = ERROR_SYNTAX;
				  return -1;
			      }

			    if (!keynote_justrecord && !keynote_donteval)
			      yyval.intval = get_kth(yyvsp[-5].intval);
			    else
			      yyval.intval = 0;
			  }
break;
case 27:
#line 143 "keynote.y"
{ /* Don't do anything if we're just recording */ 
              if (!keynote_justrecord && !keynote_donteval)
		if ((yyvsp[0].intval < keynote_current_session->ks_values_num) && (yyvsp[0].intval >= 0))
		  keynote_kth_array[yyvsp[0].intval]++;

	      keylistcount++;
            }
break;
case 28:
#line 151 "keynote.y"
{ /* Don't do anything if we're just recording */ 
	      if (!keynote_justrecord && !keynote_donteval)
		if ((yyvsp[-2].intval < keynote_current_session->ks_values_num) && (yyvsp[-2].intval >= 0))
		  keynote_kth_array[yyvsp[-2].intval]++;

	      keylistcount++;
            }
break;
case 29:
#line 159 "keynote.y"
{
		   if (keynote_donteval)
		     yyval.intval = 0;
		   else
		   {
		       keynote_lex_remove(yyvsp[0].string);
		       if (keynote_justrecord)
		       {
			   if (keynote_keylist_add(&keynote_keypred_keylist,
						   yyvsp[0].string) == -1)
			   {
			       free(yyvsp[0].string);
			       return -1;
			   }

			   yyval.intval = 0;
		       }
		       else
			 switch (keynote_in_action_authorizers(yyvsp[0].string, KEYNOTE_ALGORITHM_UNSPEC))
			 {
			     case -1:
				 free(yyvsp[0].string);
				 return -1;
				 
			     case RESULT_TRUE:
				 free(yyvsp[0].string);
				 yyval.intval = keynote_current_session->ks_values_num -
				      1;
				 break;
				 
			     default:
				 yyval.intval = resolve_assertion(yyvsp[0].string);
				 free(yyvsp[0].string);
				 break;
			 }
		   }
                 }
break;
case 32:
#line 201 "keynote.y"
{
            int i;

            keynote_lex_remove(yyvsp[-2].string);
	    keynote_lex_remove(yyvsp[0].string);
 
	    /*
	     * Variable names starting with underscores are illegal here.
	     */
	    if (yyvsp[-2].string[0] == '_')
	    {
		free(yyvsp[-2].string);
		free(yyvsp[0].string);
		keynote_errno = ERROR_SYNTAX;
		return -1;
	    }
	    
	    /* If the identifier already exists, report error. */
	    if (keynote_env_lookup(yyvsp[-2].string, &keynote_init_list, 1) != (char *) NULL)
	    {
		free(yyvsp[-2].string);
		free(yyvsp[0].string);
		keynote_errno = ERROR_SYNTAX;
		return -1;
	    }

	    i = keynote_env_add(yyvsp[-2].string, yyvsp[0].string, &keynote_init_list, 1, 0);
	    free(yyvsp[-2].string);
	    free(yyvsp[0].string);

	    if (i != RESULT_TRUE)
	      return -1;
	  }
break;
case 33:
#line 235 "keynote.y"
{
            int i;

	    keynote_lex_remove(yyvsp[-2].string);
	    keynote_lex_remove(yyvsp[0].string);

	    /*
	     * Variable names starting with underscores are illegal here.
	     */
	    if (yyvsp[-2].string[0] == '_')
	    {
		free(yyvsp[-2].string);
		free(yyvsp[0].string);
		keynote_errno = ERROR_SYNTAX;
		return -1;
	    }
	 
	    /* If the identifier already exists, report error. */
	    if (keynote_env_lookup(yyvsp[-2].string, &keynote_init_list, 1) != (char *) NULL)
	    {
		free(yyvsp[-2].string);
		free(yyvsp[0].string);
		keynote_errno = ERROR_SYNTAX;
		return -1;
	    }

	    i = keynote_env_add(yyvsp[-2].string, yyvsp[0].string, &keynote_init_list, 1, 0);
	    free(yyvsp[-2].string);
	    free(yyvsp[0].string);

	    if (i != RESULT_TRUE)
	      return -1;
	  }
break;
case 35:
#line 269 "keynote.y"
{ 
	        keynote_returnvalue = yyvsp[0].intval;
		return 0;
	      }
break;
case 36:
#line 274 "keynote.y"
{ yyval.intval = 0; }
break;
case 37:
#line 275 "keynote.y"
{
			  /* 
			   * Cleanup envlist of additions such as 
			   * regexp results
			   */
			  keynote_env_cleanup(&keynote_temp_list, 1);
                    }
break;
case 38:
#line 282 "keynote.y"
{
		      if (yyvsp[-3].intval > yyvsp[0].intval)
			yyval.intval = yyvsp[-3].intval;
		      else
			yyval.intval = yyvsp[0].intval;
                    }
break;
case 39:
#line 290 "keynote.y"
{
		if (checkexception(yyvsp[-2].bool))
		  yyval.intval = yyvsp[0].intval;
		else
		  yyval.intval = 0;
	      }
break;
case 40:
#line 297 "keynote.y"
{
		if (checkexception(yyvsp[0].bool))
		  yyval.intval = keynote_current_session->ks_values_num - 1;
		else
		  yyval.intval = 0;
	      }
break;
case 41:
#line 304 "keynote.y"
{  if (keynote_exceptionflag || keynote_donteval)
		    yyval.intval = 0;
		  else
		  {
		      keynote_lex_remove(yyvsp[0].string);

		      yyval.intval = keynote_retindex(yyvsp[0].string);
		      if (yyval.intval == -1)   /* Invalid return value */
			yyval.intval = 0;

		      free(yyvsp[0].string);
		  }
                }
break;
case 42:
#line 317 "keynote.y"
{ yyval.intval = yyvsp[-1].intval; }
break;
case 43:
#line 320 "keynote.y"
{ yyval.bool = yyvsp[-1].bool; }
break;
case 44:
#line 321 "keynote.y"
{ if (yyvsp[-1].bool == 0)
	               keynote_donteval = 1;
	           }
break;
case 45:
#line 323 "keynote.y"
{ yyval.bool = (yyvsp[-3].bool && yyvsp[0].bool);
		                          keynote_donteval = 0;
		                        }
break;
case 46:
#line 326 "keynote.y"
{ if (yyvsp[-1].bool)
	              keynote_donteval = 1; 
	          }
break;
case 47:
#line 328 "keynote.y"
{ yyval.bool = (yyvsp[-3].bool || yyvsp[0].bool);
		                          keynote_donteval = 0;
                                        }
break;
case 48:
#line 331 "keynote.y"
{ yyval.bool = !(yyvsp[0].bool); }
break;
case 49:
#line 332 "keynote.y"
{ yyval.bool = yyvsp[0].bool; }
break;
case 50:
#line 333 "keynote.y"
{ yyval.bool = yyvsp[0].bool; }
break;
case 51:
#line 334 "keynote.y"
{ yyval.bool = yyvsp[0].bool; }
break;
case 52:
#line 335 "keynote.y"
{ yyval.bool = 1; }
break;
case 53:
#line 336 "keynote.y"
{ yyval.bool = 0; }
break;
case 54:
#line 338 "keynote.y"
{ yyval.bool = yyvsp[-2].intval < yyvsp[0].intval; }
break;
case 55:
#line 339 "keynote.y"
{ yyval.bool = yyvsp[-2].intval > yyvsp[0].intval; }
break;
case 56:
#line 340 "keynote.y"
{ yyval.bool = yyvsp[-2].intval == yyvsp[0].intval; }
break;
case 57:
#line 341 "keynote.y"
{ yyval.bool = yyvsp[-2].intval <= yyvsp[0].intval; }
break;
case 58:
#line 342 "keynote.y"
{ yyval.bool = yyvsp[-2].intval >= yyvsp[0].intval; }
break;
case 59:
#line 343 "keynote.y"
{ yyval.bool = yyvsp[-2].intval != yyvsp[0].intval; }
break;
case 60:
#line 345 "keynote.y"
{ yyval.bool = yyvsp[-2].doubval < yyvsp[0].doubval; }
break;
case 61:
#line 346 "keynote.y"
{ yyval.bool = yyvsp[-2].doubval > yyvsp[0].doubval; }
break;
case 62:
#line 347 "keynote.y"
{ yyval.bool = yyvsp[-2].doubval <= yyvsp[0].doubval; }
break;
case 63:
#line 348 "keynote.y"
{ yyval.bool = yyvsp[-2].doubval >= yyvsp[0].doubval; }
break;
case 64:
#line 350 "keynote.y"
{ yyval.intval = yyvsp[-2].intval + yyvsp[0].intval; }
break;
case 65:
#line 351 "keynote.y"
{ yyval.intval = yyvsp[-2].intval - yyvsp[0].intval; }
break;
case 66:
#line 352 "keynote.y"
{ yyval.intval = yyvsp[-2].intval * yyvsp[0].intval; }
break;
case 67:
#line 353 "keynote.y"
{ if (yyvsp[0].intval == 0)
	                      {
				  if (!keynote_donteval)
				    keynote_exceptionflag = 1;
			      }
	                      else
			        yyval.intval = (yyvsp[-2].intval / yyvsp[0].intval);
			    }
break;
case 68:
#line 361 "keynote.y"
{ if (yyvsp[0].intval == 0)
	                      {
				  if (!keynote_donteval)
				    keynote_exceptionflag = 1;
			      }
	                      else
			        yyval.intval = yyvsp[-2].intval % yyvsp[0].intval;
			    }
break;
case 69:
#line 369 "keynote.y"
{ yyval.intval = intpow(yyvsp[-2].intval, yyvsp[0].intval); }
break;
case 70:
#line 370 "keynote.y"
{ yyval.intval = -(yyvsp[0].intval); }
break;
case 71:
#line 371 "keynote.y"
{ yyval.intval = yyvsp[-1].intval; }
break;
case 72:
#line 372 "keynote.y"
{ yyval.intval = yyvsp[0].intval; }
break;
case 73:
#line 373 "keynote.y"
{ if (keynote_exceptionflag ||
					      keynote_donteval)
	                                    yyval.intval = 0;
 	                                  else
					  {
					      keynote_lex_remove(yyvsp[0].string);

					      if (!isfloatstring(yyvsp[0].string))
						yyval.intval = 0;
					      else
						yyval.intval = (int) floor(atof(yyvsp[0].string));
					      free(yyvsp[0].string);
					  }
					}
break;
case 74:
#line 388 "keynote.y"
{ yyval.doubval = (yyvsp[-2].doubval + yyvsp[0].doubval); }
break;
case 75:
#line 389 "keynote.y"
{ yyval.doubval = (yyvsp[-2].doubval - yyvsp[0].doubval); }
break;
case 76:
#line 390 "keynote.y"
{ yyval.doubval = (yyvsp[-2].doubval * yyvsp[0].doubval); }
break;
case 77:
#line 391 "keynote.y"
{ if (yyvsp[0].doubval == 0)
	                                  {
					      if (!keynote_donteval)
						keynote_exceptionflag = 1;
					  }
	                                  else
			        	   yyval.doubval = (yyvsp[-2].doubval / yyvsp[0].doubval);
					}
break;
case 78:
#line 399 "keynote.y"
{ if (!keynote_exceptionflag &&
						      !keynote_donteval)
	                                            yyval.doubval = pow(yyvsp[-2].doubval, yyvsp[0].doubval);
	                                        }
break;
case 79:
#line 403 "keynote.y"
{ yyval.doubval = -(yyvsp[0].doubval); }
break;
case 80:
#line 404 "keynote.y"
{ yyval.doubval = yyvsp[-1].doubval; }
break;
case 81:
#line 405 "keynote.y"
{ yyval.doubval = yyvsp[0].doubval; }
break;
case 82:
#line 406 "keynote.y"
{
	                                  if (keynote_exceptionflag ||
					      keynote_donteval)
					    yyval.doubval = 0.0;
					  else
					  {
					      keynote_lex_remove(yyvsp[0].string);
					  
					      if (!isfloatstring(yyvsp[0].string))
						yyval.doubval = 0.0;
					      else
						yyval.doubval = atof(yyvsp[0].string);
					      free(yyvsp[0].string);
					  }
	                                }
break;
case 83:
#line 422 "keynote.y"
{
                        if (keynote_exceptionflag || keynote_donteval)
			  yyval.bool = 0;
			else
			{
			    yyval.bool = strcmp(yyvsp[-2].string, yyvsp[0].string) == 0 ? 1 : 0;
			    keynote_lex_remove(yyvsp[-2].string);
			    keynote_lex_remove(yyvsp[0].string);
			    free(yyvsp[-2].string);
			    free(yyvsp[0].string);
			}
		      }
break;
case 84:
#line 434 "keynote.y"
{
	                if (keynote_exceptionflag || keynote_donteval)
			  yyval.bool = 0;
			else
			{
			    yyval.bool = strcmp(yyvsp[-2].string, yyvsp[0].string) != 0 ? 1 : 0;
			    keynote_lex_remove(yyvsp[-2].string);
			    keynote_lex_remove(yyvsp[0].string);
			    free(yyvsp[-2].string);
			    free(yyvsp[0].string);
			}
		      }
break;
case 85:
#line 446 "keynote.y"
{
	                if (keynote_exceptionflag || keynote_donteval)
			  yyval.bool = 0;
			else
			{
			    yyval.bool = strcmp(yyvsp[-2].string, yyvsp[0].string) < 0 ? 1 : 0;
			    keynote_lex_remove(yyvsp[-2].string);
			    keynote_lex_remove(yyvsp[0].string);
			    free(yyvsp[-2].string);
			    free(yyvsp[0].string);
			}
		      }
break;
case 86:
#line 458 "keynote.y"
{
	                if (keynote_exceptionflag || keynote_donteval)
			  yyval.bool = 0;
			else
			{
			    yyval.bool = strcmp(yyvsp[-2].string, yyvsp[0].string) > 0 ? 1 : 0;
			    keynote_lex_remove(yyvsp[-2].string);
			    keynote_lex_remove(yyvsp[0].string);
			    free(yyvsp[-2].string);
			    free(yyvsp[0].string);
			}
		      }
break;
case 87:
#line 470 "keynote.y"
{
	                if (keynote_exceptionflag || keynote_donteval)
			  yyval.bool = 0;
			else
			{
			    yyval.bool = strcmp(yyvsp[-2].string, yyvsp[0].string) <= 0 ? 1 : 0;
			    keynote_lex_remove(yyvsp[-2].string);
			    keynote_lex_remove(yyvsp[0].string);
			    free(yyvsp[-2].string);
			    free(yyvsp[0].string);
			}
		      }
break;
case 88:
#line 482 "keynote.y"
{
	                if (keynote_exceptionflag || keynote_donteval)
			  yyval.bool = 0;
			else
			{
			    yyval.bool = strcmp(yyvsp[-2].string, yyvsp[0].string) >= 0 ? 1 : 0;
			    keynote_lex_remove(yyvsp[-2].string);
			    keynote_lex_remove(yyvsp[0].string);
			    free(yyvsp[-2].string);
			    free(yyvsp[0].string);
			}
		      }
break;
case 89:
#line 495 "keynote.y"
{
	      regmatch_t pmatch[32];
	      char grp[4], *gr;
	      regex_t preg;
	      int i;

	      if (keynote_exceptionflag || keynote_donteval)
		yyval.bool = 0;
	      else
	      {
		  keynote_lex_remove(yyvsp[-2].string);
		  keynote_lex_remove(yyvsp[0].string);

		  memset(pmatch, 0, sizeof(pmatch));
		  memset(grp, 0, sizeof(grp));

#if HAVE_REGCOMP
		  if (regcomp(&preg, yyvsp[0].string, REG_EXTENDED))
		  {
#else /* HAVE_REGCOMP */
#error "This system does not have regcomp()."
#endif /* HAVE_REGCOMP */
		      free(yyvsp[-2].string);
		      free(yyvsp[0].string);
		      keynote_exceptionflag = 1;
		  }
		  else
		  {
		      /* Clean-up residuals from previous regexps */
		      keynote_env_cleanup(&keynote_temp_list, 1);

		      free(yyvsp[0].string);
		      i = regexec(&preg, yyvsp[-2].string, 32, pmatch, 0);
		      yyval.bool = (i == 0 ? 1 : 0);
		      if (i == 0)
		      {
#if !defined(HAVE_SNPRINTF)
			  sprintf(grp, "%d", preg.re_nsub);
#else /* !HAVE_SNPRINTF */
			  snprintf(grp, 3, "%d", preg.re_nsub);
#endif /* !HAVE_SNPRINTF */
			  if (keynote_env_add("_0", grp, &keynote_temp_list,
					      1, 0) != RESULT_TRUE)
			  {
			      free(yyvsp[-2].string);
			      regfree(&preg);
			      return -1;
			  }

			  for (i = 1; i < 32 && pmatch[i].rm_so != -1; i++)
			  {
			      gr = calloc(pmatch[i].rm_eo - pmatch[i].rm_so +
					  1, sizeof(char));
			      if (gr == (char *) NULL)
			      {
				  free(yyvsp[-2].string);
				  regfree(&preg);
				  keynote_errno = ERROR_MEMORY;
				  return -1;
			      }

			      strncpy(gr, yyvsp[-2].string + pmatch[i].rm_so,
				      pmatch[i].rm_eo - pmatch[i].rm_so);
			      gr[pmatch[i].rm_eo - pmatch[i].rm_so] = '\0';
#if !defined(HAVE_SNPRINTF)
			      sprintf(grp, "_%d", i);
#else /* !HAVE_SNPRINTF */
			      snprintf(grp, 3, "_%d", i);
#endif /* !HAVE_SNPRINTF */
			      if (keynote_env_add(grp, gr, &keynote_temp_list,
						  1, 0) == -1)
			      {
				  free(yyvsp[-2].string);
				  regfree(&preg);
				  free(gr);
				  return -1;
			      }
			      else
				free(gr);
			  }
		      }

		      regfree(&preg);
		      free(yyvsp[-2].string);
		  }
	      }
	    }
break;
case 90:
#line 583 "keynote.y"
{  if (keynote_exceptionflag || keynote_donteval)
			  yyval.string = (char *) NULL;
			else
			{
			    yyval.string = calloc(strlen(yyvsp[-2].string) + strlen(yyvsp[0].string) + 1,
					sizeof(char));
			    keynote_lex_remove(yyvsp[-2].string);
			    keynote_lex_remove(yyvsp[0].string);
			    if (yyval.string == (char *) NULL)
			    {
				free(yyvsp[-2].string);
				free(yyvsp[0].string);
				keynote_errno = ERROR_MEMORY;
				return -1;
			    }
 
			    strcpy(yyval.string, yyvsp[-2].string);
			    strcpy(yyval.string + strlen(yyvsp[-2].string), yyvsp[0].string);
			    free(yyvsp[-2].string);
			    free(yyvsp[0].string);
			    if (keynote_lex_add(yyval.string, LEXTYPE_CHAR) == -1)
			      return -1;
			}
		      }
break;
case 91:
#line 607 "keynote.y"
{ yyval.string = yyvsp[0].string; }
break;
case 92:
#line 609 "keynote.y"
{ yyval.string = yyvsp[0].string; }
break;
case 93:
#line 610 "keynote.y"
{ yyval.string = yyvsp[-1].string; }
break;
case 94:
#line 611 "keynote.y"
{  if (keynote_exceptionflag || keynote_donteval)
	                     yyval.string = (char *) NULL;
 	                   else
			   {
			       yyval.string = my_lookup(yyvsp[0].string);
			       keynote_lex_remove(yyvsp[0].string);
			       free(yyvsp[0].string);
			       if (yyval.string == (char *) NULL)
			       {
				   if (keynote_errno)
				     return -1;
				   yyval.string = strdup("");
			       }
			       else
				 yyval.string = strdup(yyval.string);

			       if (yyval.string == (char *) NULL)
			       {
				   keynote_errno = ERROR_MEMORY;
				   return -1;
			       }

			       if (keynote_lex_add(yyval.string, LEXTYPE_CHAR) == -1)
				 return -1;
			   }
	                 }
break;
case 95:
#line 637 "keynote.y"
{  if (keynote_exceptionflag || keynote_donteval)
			      yyval.string = (char *) NULL;
			    else
			    {
				yyval.string = my_lookup(yyvsp[0].string);
				keynote_lex_remove(yyvsp[0].string);
				free(yyvsp[0].string);
				if (yyval.string == (char *) NULL)
				{
				    if (keynote_errno)
				      return -1;
				    yyval.string = strdup("");
				}
				else
				  yyval.string = strdup(yyval.string);

				if (yyval.string == (char *) NULL)
				{
				    keynote_errno = ERROR_MEMORY;
				    return -1;
				}

				if (keynote_lex_add(yyval.string, LEXTYPE_CHAR) == -1)
				  return -1;
			    }
			 }
break;
#line 1727 "k.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
