#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <bcmnvram.h>
#include <utils.h>

#define PASSWD_DIR	"/tmp/etc"
#define SSH_DIR		"/tmp/.ssh"
#define PASSWD_FILE	"/tmp/etc/passwd"
#define GROUP_FILE	"/tmp/etc/group"


void to64(char *s, long v, int n)
{

  unsigned char itoa64[] = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

  while (--n >= 0)
  {
	*s++ = itoa64[v&0x3f];
        v >>= 6;
  }
}

char *zencrypt (char *passwd)
{
	char salt[6];
	struct timeval tv;
	char *crypt (const char *, const char *);

	gettimeofday(&tv,0);

	to64(&salt[0], random(), 3);
	to64(&salt[3], tv.tv_usec, 3);
	salt[5] = '\0';

	return crypt (passwd, salt);
}


int mkfiles(void)
{
	FILE *fp ;
        struct stat buf;
        char *http_passwd = nvram_safe_get("http_passwd");
        char *cp ;


#ifdef HAVE_SSHD
	if( stat(SSH_DIR, &buf) != 0 ){
		mkdir(SSH_DIR, 0700);
	}
#endif

	/* Create password's and group's database directory */
	if( stat(PASSWD_DIR, &buf) != 0 ){
		mkdir(PASSWD_DIR, 0700);
	}

	cp = (char *) zencrypt(http_passwd); /* encrypt password*/
	/* Write password file with username root and password */
	if (!(fp = fopen(PASSWD_FILE, "w"))) {
		perror(PASSWD_FILE);
		return errno;
	}
	fprintf(fp, "root:%s:0:0:Root User,,,:/tmp:/bin/sh\n",cp) ;
	fclose (fp) ;

	/* Write group file with group 'root' */
	if (!(fp = fopen(GROUP_FILE, "w"))) {
		perror(GROUP_FILE);
		return errno;
	}
	fprintf(fp, "root:x:0:\n") ;
	fclose (fp) ;

	system("/bin/mkdir /var/spool");
	system("/bin/mkdir /var/spool/cron");
	system("/bin/mkdir /var/spool/cron/crontabs");
	system("/bin/touch /var/spool/cron/crontabs/root");

	system("/bin/mkdir /var/log");
	system("/bin/touch /var/log/messages");

#ifdef HAVE_SNMP
	system("/bin/mkdir /var/snmp");
#endif
	
	dns_to_resolv();
	
	return 0;
}
