
/*
 *********************************************************
 *   Copyright 2003, 2004 Sveasoft AB                    *
 *   All Rights Reserved                                 *
 *********************************************************

 This is PROPRIETARY SOURCE CODE developed by Sveasoft AB

 THIS SOFTWARE IS OFFERED "AS IS", AND SVEASOFT GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  SVEASOFT
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
 
 COPYRIGHT 2004 Sveasoft AB

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <sys/time.h>
#include <syslog.h>
#include <wait.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <wlutils.h>
#include <wlioctl.h>
#include <rc.h>

#include <cy_conf.h>
#include <utils.h>
#include <sveasoft.h>

#define WLAND_INTERVAL 15

#define sin_addr(s) (((struct sockaddr_in *)(s))->sin_addr)

static char* get_wdev()
{
	if(check_hw_type() == BCM4702_CHIP)
	  return "eth2";
	else
	  return "eth1";

}

static int
notify_wdsnas(char *type, char *ifname, char *action)
{
	char *argv[] = {"nas4wds", type, ifname, action, NULL};
	char *str = NULL;
	int pid;
	int retries = 10;

	if (nvram_match("nas_enable", "0") || nvram_match("wl0_auth_mode", "disabled"))
		return 0;

	while (retries -- > 0 && !(str = file2str("/tmp/nas.lan.pid")))
		sleep(1);
	if (str) {
		free(str);
		return _eval(argv, ">/dev/console", 0, &pid);
	}
	return -1;
}

static int do_wds_check(void)
{
	int s=0;

	/* Sveasoft - Bring up and configure wds interfaces */
	/* logic - if separate ip defined bring it up */
	/*         else if flagged for br1 and br1 is enabled add to br1 */
	/*         else add it to the br0 bridge */
	for(s=1;s<=MAX_WDS_DEVS;s++)
	{
		char wdsvarname[32] = {0};
		char wdsdevname[32] = {0};
		char *dev;
		struct ifreq ifr;


		sprintf(wdsvarname, "wl_wds%d_enable", s);
		sprintf(wdsdevname, "wl_wds%d_if", s);
		dev = nvram_safe_get(wdsdevname);

		if(nvram_invmatch(wdsvarname, "1"))
		  continue;

    		memset(&ifr, 0, sizeof(struct ifreq));

    		snprintf(ifr.ifr_name, IFNAMSIZ, wdsdevname);
    		ioctl(s, SIOCGIFFLAGS, &ifr);

		if( (ifr.ifr_flags & IFF_RUNNING) && (ifr.ifr_flags & IFF_UP))
		  continue;

		if(nvram_match(wdsvarname, "1") ){
			char wdsip[32] 	    = {0};
			char wdsbc[32] 	    = {0};
			char wdsnm[32] 	    = {0};

			snprintf(wdsip, 31,"wl_wds%d_ipaddr", s);
			snprintf(wdsnm, 31, "wl_wds%d_netmask", s);

			snprintf(wdsbc,31, "%s", nvram_safe_get(wdsip));
			get_broadcast(wdsbc, nvram_safe_get(wdsnm));
			eval("ifconfig", dev, nvram_safe_get(wdsip), "broadcast", wdsbc, "netmask", nvram_safe_get(wdsnm), "up");
		}
		else if(nvram_match(wdsvarname, "2") && nvram_match("wl_br1_enable", "1")){
			eval("ifconfig", dev, "up");
			eval("brctl", "addif", "br1", dev);
		}
		else if(nvram_match(wdsvarname, "3")){
			eval("ifconfig", dev, "up");
			eval("brctl", "addif", "br0", dev);
		}
		
		notify_wdsnas("lan", dev, "up");		
	}

	return 0;
}

static int do_ap_check(void)
{

  if(nvram_match("apwatchdog_enable", "1"))
    do_ap_watchdog();

  do_wds_check();

  return 0;
}

static int do_ap_watchdog(void)
{

  /* AP Watchdog - experimental check and fix for hung AP */

  struct stat s;
  static time_t last;
  int interval = atoi(nvram_safe_get("apwatchdog_interval")) > WLAND_INTERVAL ? atoi(nvram_safe_get("apwatchdog_interval")) : WLAND_INTERVAL;

  system("/usr/sbin/wl assoclist 2>&1 > /tmp/.assoclist");
  stat("/tmp/.assoclist", &s);
  unlink("/tmp/.assoclist");

  if( 	s.st_size <= 0 &&
  	time(NULL) - last > interval &&
  	nvram_match("apwatchdog_enable", "1") &&
	nvram_invmatch("wl_net_mode", "disabled")){

	int val = 0;

	time(&last);
	cprintf("resetting ap radio\n");
	eval("/usr/sbin/wlconf", get_wdev(), "down");

	val = atoi(nvram_safe_get("wl0_channel")) + 1;
	if(val <=2 || val >= 14)
	 val = 2;

	wl_ioctl(get_wdev(), WLC_SET_CHANNEL, &val, sizeof(val));
	wl_ioctl(get_wdev(), WLC_UP, NULL, 0);

	eval("/usr/sbin/wlconf", get_wdev(), "down");
	eval("/usr/sbin/wlconf", get_wdev(), "up");

  }

  return 0;

}

/* for Client/Wet mode */
static int do_client_check(void)
{
	wlc_ssid_t ssid;
	int assoc=0;

	if(nvram_safe_get("wl0_ssid") == (void*)0)
	  return 0;

	memset(&ssid,0,sizeof(wlc_ssid_t));
	wl_ioctl(get_wdev(), WLC_GET_SSID, &ssid, sizeof(ssid));

	if(ssid.SSID_len > 0)
	  assoc = (memcmp(nvram_safe_get("wl0_ssid"), ssid.SSID, ssid.SSID_len) == 0) ? 1 : 0;
	else
	  assoc = 0;

	if(0 == assoc){
	  /* let wl do this for us (no use in reinventing the wheel) */
          eval("wl", "join", nvram_safe_get("wl0_ssid"));
	}

	return 0;
}

static void do_wlan_check(void)
{

  if(nvram_match("wl0_mode", "wet"))
    do_client_check();
  else
    do_ap_check();


}


int wland_main(int argc, char **argv)
{
	/* Run it in the background */
	switch (fork()) {
	case -1:
		// can't fork
		exit(0);
		break;
	case 0:
		/* child process */
		// fork ok
		(void) setsid();
		break;
	default:
		/* parent process should just die */
		_exit(0);
	}

	/* Most of time it goes to sleep */
	while(1)
	{
	  do_wlan_check();

	  sleep(WLAND_INTERVAL);
	}

	return 0;
} // end main

int stop_wland(void)
{
        int ret = eval("killall","-9", "wland");

        dprintf("done\n");
        return ret;
}

int start_wland(void)
{
	int ret;
	pid_t pid;
	char *wland_argv[] = { "/sbin/wland",
		                NULL
		              };

	stop_wland();

//	if( nvram_match("apwatchdog_enable", "0") )
//	    return 0;

        ret = _eval(wland_argv, NULL, 0, &pid);
        dprintf("done\n");
        return ret;
}
