#include "code_pattern.h"

#define CYBERTAN_VERSION	"Alchemy-pre5.3 v2.04.4.8sv"
#define MINOR_VERSION		""
#define SERIAL_NUMBER		"001"
#define PMON_BOOT_VERSION	"v1.8"
#define CFE_BOOT_VERSION	"v2.4"
#define CFES_BOOT_VERSION	"v3.3"

#define BOOT_IPADDR "192.168.1.1"
#define BOOT_NETMASK "255.255.255.0"

struct code_header {
	char magic[4];
	char res1[4];	// for extra magic
	char fwdate[3];
	char fwvern[3];
	char id[4];	// U2ND
	char hw_ver;	// 0: for 4702, 1: for 4712
	unsigned char res2[13];
} ;

struct boot_header {
	char magic[3];
	char res[29];
};

/***************************************
 * define upnp misc                    *
 ***************************************/
  #if LANGUAGE == ENGLISH
    #define URL			"http://www.linksys.com/"
  #else
    #define URL			"http://www.linksys.co.jp/"
  #endif
  #define DEV_FRIENDLY_NAME	MODEL_NAME
  #define DEV_MFR		"Linksys Inc."
  #define DEV_MFR_URL		URL
  #define DEV_MODEL_DESCRIPTION	"Internet Access Server"
  #define DEV_MODEL		MODEL_NAME
  #define DEV_MODEL_NO		CYBERTAN_VERSION
  #define DEV_MODEL_URL		URL
