
/*
 *********************************************************
 *   Copyright 2004, CyberTAN  Inc.  All Rights Reserved *
 *********************************************************

 This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
 the contents of this file may not be disclosed to third parties,
 copied or duplicated in any form without the prior written
 permission of CyberTAN Inc.

 This software should be used as a reference only, and it not
 intended for production use!


 THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <typedefs.h>
#include <bcmnvram.h>
#include <shutils.h>
#include <wlioctl.h>
#include <wlutils.h>

#define SITE_SUVERY_DB	"/tmp/site_suvery"
#define SITE_SUVERY_NUM	50

int write_site_suvery(void);
int open_site_suvery(void);
int write_site_suvery(void);

struct site_suvery_list {
	uint8		SSID[32];
	unsigned char   BSSID[18];
	uint8		channel;	/* Channel no. */
	int16		RSSI;		/* receive signal strength (in dBm) */
	int8		phy_noise;	/* noise (in dBm) */
	uint16		beacon_period;	/* units are Kusec */
	uint16		capability;	/* Capability information */
	uint		rate_count;	/* # rates in this set */
        uint8           dtim_period;    /* DTIM period */
} site_suvery_lists[SITE_SUVERY_NUM];

int
site_suvery_main(int argc, char *argv[])
{
	char *name = nvram_safe_get("wl0_ifname");
	unsigned char buf[10000];
	wl_scan_results_t *scan_res = (wl_scan_results_t *)buf;
	wl_bss_info_t *bss_info;
	unsigned char mac[20];
	int i;
	int ret;

	eval("wl", "radio", "on");
	eval("wl", "ap", "0");
	sleep(2);

	bzero(buf, sizeof(buf));
	bzero(site_suvery_lists, sizeof(site_suvery_lists));
	unlink(SITE_SUVERY_DB);

	if (wl_ioctl(name, WLC_SCAN, buf, sizeof(buf)) < 0)
		goto endss;
	sleep(1);
	scan_res->buflen = sizeof(buf);
	ret = wl_ioctl(name, WLC_SCAN_RESULTS, buf, sizeof(buf));

	cprintf("buflen=[%d] version=[%d] count=[%d]\n", scan_res->buflen, scan_res->version, scan_res->count);

	if(scan_res->count == 0){
		cprintf("Cann't found any wireless device\n");
		goto endss;
	}

	bss_info = &scan_res->bss_info[0];

	for(i=0 ; i<scan_res->count ; i++){
		strcpy(site_suvery_lists[i].SSID, bss_info->SSID);
		strcpy(site_suvery_lists[i].BSSID, ether_etoa(bss_info->BSSID.octet, mac));
		site_suvery_lists[i].channel = bss_info->channel;
		site_suvery_lists[i].RSSI = bss_info->RSSI;
		site_suvery_lists[i].phy_noise = bss_info->phy_noise;
		site_suvery_lists[i].beacon_period = bss_info->beacon_period;
		site_suvery_lists[i].capability = bss_info->capability;
		site_suvery_lists[i].rate_count = bss_info->rateset.count;
		site_suvery_lists[i].dtim_period = bss_info->dtim_period;

		bss_info =  (wl_bss_info_t *)((uint32)bss_info + bss_info->length);
	}

	write_site_suvery();
	open_site_suvery();
	for(i=0 ; i<SITE_SUVERY_NUM && site_suvery_lists[i].SSID[0] ; i++){
	cprintf("[%2d] SSID[%20s] BSSID[%s] channel[%2d] rssi[%d] noise[%d] beacon[%d] cap[%x] dtim[%d] rate[%d]\n",
		i,
		site_suvery_lists[i].SSID,
		site_suvery_lists[i].BSSID,
		site_suvery_lists[i].channel,
		site_suvery_lists[i].RSSI,
		site_suvery_lists[i].phy_noise,
		site_suvery_lists[i].beacon_period,
		site_suvery_lists[i].capability,
		site_suvery_lists[i].dtim_period,
		site_suvery_lists[i].rate_count);
	}

endss:
	if(!nvram_match("wl_mode", "sta") && !nvram_match("wl_mode", "wet")) {
		eval("wl", "ap", "1");
		stop_services();
		eval("wlconf", nvram_safe_get("wl0_ifname"), "up");
		// start_lan();
		C_led(1);
		start_services();
	}
	sleep(3);
	C_led(0);
	return 0;
}

int
write_site_suvery(void)
{
        FILE *fp;

        if((fp = fopen(SITE_SUVERY_DB, "w"))){
                fwrite(&site_suvery_lists[0], sizeof(site_suvery_lists), 1, fp);
                fclose(fp);
                return FALSE;
        }
        return TRUE;
}

int
open_site_suvery(void)
{
        FILE *fp;
	
	bzero(site_suvery_lists, sizeof(site_suvery_lists));

        if((fp = fopen(SITE_SUVERY_DB, "r"))){
                fread(&site_suvery_lists[0], sizeof(site_suvery_lists), 1, fp);
                fclose(fp);
                return TRUE;
        }
        return FALSE;
}
