/*
 *********************************************************
 *   Copyright 2003, CyberTAN  Inc.  All Rights Reserved *
 *********************************************************

 This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
 the contents of this file may not be disclosed to third parties,
 copied or duplicated in any form without the prior written
 permission of CyberTAN Inc.

 This software should be used as a reference only, and it not
 intended for production use!


 THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

/*
 * Router rc control script
 *
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 * 
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 *
 * $Id: rc.c,v 1.39 2004/01/06 10:41:29 honor Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <time.h>
#include <unistd.h>
#include <errno.h>
#include <syslog.h>
#include <signal.h>
#include <string.h>
#include <sys/klog.h>
#include <sys/types.h>
#include <sys/mount.h>
#include <sys/reboot.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <sys/time.h>
#include <sys/utsname.h>
#include <sys/wait.h>
#include <dirent.h>

#include <epivers.h>
#include <bcmnvram.h>
#include <mtd.h>
#include <shutils.h>
#include <rc.h>
#include <netconf.h>
#include <nvparse.h>
#include <bcmdevs.h>

#include <wlutils.h>
#include <utils.h>
#include <cyutils.h>
#include <code_pattern.h>
#include <cy_conf.h>
#include <support.h>
#include <mkfiles.h>

static void restore_defaults(void);
static void sysinit(void);
static void rc_signal(int sig);

static int check_cfe_nv(void);
static int check_pmon_nv(void);
static void unset_nvram(void);
static int init_nvram(void);
static int check_image(void);

extern struct nvram_tuple router_defaults[];

// begin Sveasoft addition
int create_rc_file(char* name)
{
	FILE *fp;
	char *p = nvram_safe_get(name);
	char tmp_file[100] = {0};

	if((void*)0 == name || 0 == p[0])
          return -1;

	snprintf(tmp_file, 100, "/tmp/.%s", name);
	unlink(tmp_file);

	fp = fopen(tmp_file,"w");
	if(fp){
		// filter Windows <cr>ud
		while(*p){
	  		if(*p != 0x0d)
			  fprintf(fp, "%c", *p);
	    		p++;
		}
	}
	fclose(fp);
	chmod(tmp_file, 0700);

	return 0;
}

// end Sveasoft addition

static void
restore_defaults(void)
{
	struct nvram_tuple generic[] = {
		{ "lan_ifname", "br0", 0 },
		{ "lan_ifnames", "eth0 eth2 eth3 eth4", 0 },
		{ "wan_ifname", "eth1", 0 },
		{ "wan_ifnames", "eth1", 0 },
		{ 0, 0, 0 }
	};
	struct nvram_tuple vlan[] = {
		{ "lan_ifname", "br0", 0 },
		{ "lan_ifnames", "vlan0 eth1 eth2 eth3", 0 },
		{ "wan_ifname", "vlan1", 0 },
		{ "wan_ifnames", "vlan1", 0 },
		{ 0, 0, 0 }
	};
	struct nvram_tuple *linux_overrides;
	struct nvram_tuple *t, *u;
	int restore_defaults = 0;
//	uint boardflags;

	/* Restore defaults if told to.

	Note: an intentional side effect is that when
	      upgrading from a firmware without the
	      sv_restore_defaults var, defaults will
	      also be restored.
	*/
	if(nvram_invmatch("sv_restore_defaults", "0")) // || nvram_invmatch("os_name", "linux"))
		restore_defaults = 1;

	if (restore_defaults)
		cprintf("Restoring defaults...");

	/* Delete dynamically generated variables */
	/* Choose default lan/wan i/f list. */
	if (check_vlan_support())
		linux_overrides = vlan;
	else
		linux_overrides = generic;

	/* Restore defaults */
	for (t = router_defaults; t->name; t++) {
		if (restore_defaults || !nvram_get(t->name)) {
			for (u = linux_overrides; u && u->name; u++) {
				if (!strcmp(t->name, u->name)) {
					nvram_set(u->name, u->value);
					break;
				}
			}
			if (!u || !u->name)
				nvram_set(t->name, t->value);
		}
	}

	if(!nvram_get("vlan0hwname")||nvram_match("vlan0hwname", ""))
		nvram_set("vlan0hwname", "et0");
	if(!nvram_get("vlan1hwname")||nvram_match("vlan1hwname", ""))
		nvram_set("vlan1hwname", "et0");
	if(!nvram_get("vlan0ports")||nvram_match("vlan0ports", ""))
		nvram_set("vlan0ports", "1 2 3 4 5*");
	if(!nvram_get("vlan1ports")||nvram_match("vlan1ports", ""))
		nvram_set("vlan1ports", "0 5");
	if(!nvram_get("aa0"))
		nvram_set("aa0", "3");
	if(!nvram_get("ag0"))
		nvram_set("ag0", "255");
	if(!nvram_get("gpio2"))
		nvram_set("gpio2", "adm_eecs");
	if(!nvram_get("gpio3"))
		nvram_set("gpio3", "adm_eesk");
	if(!nvram_get("gpio5"))
		nvram_set("gpio5", "adm_eedi");
	if(!nvram_get("gpio6"))
		nvram_set("gpio6", "adm_rc");
	if(!nvram_get("boardrev")||nvram_match("boardrev", ""))
		nvram_set("boardrev", "0x10");
	if(!nvram_get("boardflags")||nvram_match("boardflags", "")){
		char buf[100], var[80], *next;

		nvram_set("boardflags", "0x0188");

		/* fix for GS, boardflags should be 0x388, not 0x188 */
		wl_get_val(get_wdev(), "cap", (void *)buf, 100);
		/* search for "afterburner" string */
		foreach(var, buf, next) {
			if (strncmp(var, "afterburner", sizeof(var)) == 0)
				nvram_set("boardflags", "0x0388");
		}
	}

	if(!nvram_get("boardflags2"))
		nvram_set("boardflags2", "0");

	/* Always set OS defaults */
	nvram_set("os_name", "linux");
	nvram_set("os_version", EPI_VERSION_STR);

	if(check_now_boot() == CFE_BOOT)
		check_cfe_nv();
	else if(check_now_boot() == CFE_BOOT)
		check_pmon_nv();

	/* Commit values */
	if (restore_defaults) {
		unset_nvram();
		nvram_commit();
		cprintf("done\n");
	}
}

static int noconsole = 0;

static void
sysinit(void)
{
	char buf[PATH_MAX];
	struct utsname name;
	struct stat tmp_stat;
	time_t tm = 0;

	/* /proc */
	mount("proc", "/proc", "proc", MS_MGC_VAL, NULL);

	/* /tmp */
	mount("ramfs", "/tmp", "ramfs", MS_MGC_VAL, NULL);

	/* /var */
	mkdir("/tmp/var", 0777);
	mkdir("/var/lock", 0777);
	mkdir("/var/log", 0777);
	mkdir("/var/run", 0777);
	mkdir("/var/tmp", 0777);

	/* Setup console */
	if (console_init())
		noconsole = 1;
	klogctl(8, NULL, atoi(nvram_safe_get("console_loglevel")));

	/* Modules */
	uname(&name);
	snprintf(buf, sizeof(buf), "/lib/modules/%s", name.release);
	if (stat("/proc/modules", &tmp_stat) == 0 &&
	    stat(buf, &tmp_stat) == 0) {
		char module[80], *modules, *next;
		if(check_hw_type() == BCM4702_CHIP)
			modules = nvram_invmatch("ct_modules","") ? nvram_safe_get("ct_modules") : "et wl diag adm6996";
		else
			modules = nvram_invmatch("ct_modules","") ? nvram_safe_get("ct_modules") : "et wl adm6996";
		foreach(module, modules, next)
			eval("insmod", module);
	}

	/* Set a sane date */
	stime(&tm);

	dprintf("done\n");
}

/* States */
enum {
	RESTART,
	STOP,
	START,
	TIMER,
	USER,
	IDLE,
};
static int state = START;
static int signalled = -1;

/* Signal handling */
static void
rc_signal(int sig)
{
	if (state == IDLE) {
		if (sig == SIGHUP) {
			printf("signalling RESTART\n");
			signalled = RESTART;
		}
		else if (sig == SIGUSR2) {
			printf("signalling START\n");
			signalled = START;
		}
		else if (sig == SIGINT) {
			printf("signalling STOP\n");
			signalled = STOP;
		}
		else if (sig == SIGALRM) {
			printf("signalling TIMER\n");
			signalled = TIMER;
		}
		else if (sig == SIGUSR1) {		// Receive from WEB
			printf("signalling USER1\n");
			signalled = USER;
                }

	}
}

/* Timer procedure */
int
do_timer(void)
{
	//do_ntp();
	return 0;
}

/* Main loop */
static void
main_loop(void)
{
	sigset_t sigset;
	pid_t shell_pid = 0;
	uint boardflags;

	/* Basic initialization */
	sysinit();

	/* Setup signal handlers */
	signal_init();
	signal(SIGHUP, rc_signal);
	signal(SIGUSR1, rc_signal);	// Start single service from WEB, by honor
	signal(SIGUSR2, rc_signal);
	signal(SIGINT, rc_signal);
	signal(SIGALRM, rc_signal);
	sigemptyset(&sigset);

	/* Give user a chance to run a shell before bringing up the rest of the system */
	if (!noconsole)
		run_shell(1, 0);

	/* init nvram , by honor*/
        init_nvram();

	/* Restore defaults if necessary */
	restore_defaults();

	/* Add vlan */
	boardflags = strtoul(nvram_safe_get("boardflags"), NULL, 0);

	/* begin Sveasoft add */
	/* force afterburner even for older boards */
	boardflags |= BFL_AFTERBURNER;
	/* end Sveasoft add */

//	if (boardflags & BFL_ENETVLAN || check_hw_type() == BCM4712_CHIP)
	if (check_vlan_support())
		config_vlan();

	/* Update boot from embeded boot.bin. If we find that boot have serious bug, we need do this. by honor*/
        check_image();

	// Sveasoft add 2004-07-23 - set ip_forwarding, adjust ip_contrack limits, timeouts, enable Westwood+ congestion handling
	set_ip_forward('1');
	system("/bin/echo 4096 > /proc/sys/net/ipv4/ip_conntrack_max");
	system("/bin/echo 3600 > /proc/sys/net/ipv4/ip_conntrack_tcp_timeouts");
	system("/bin/echo 3600 > /proc/sys/net/ipv4/ip_conntrack_udp_timeouts");
	system("/bin/echo 1 > /proc/sys/net/ipv4/tcp_westwood");

	// Sveasoft add 2004-01-04 create passwd, groups, misc files
	mkfiles();

	/* set hostname to router_name */
	sethostname( nvram_safe_get("router_name"), strlen( nvram_safe_get("router_name") ));

	stop_httpd();
	/* Loop forever */
	for (;;) {
		switch (state) {
		case USER:		// Restart single service from WEB of tftpd, by honor
                        dprintf("USER1\n");
                        start_single_service();
                        state = IDLE;
                        break;
		case RESTART:
			dprintf("RESTART\n");
			/* Fall through */
		case STOP:
			dprintf("STOP\n");
			setenv("PATH", "/sbin:/bin:/usr/sbin:/usr/bin", 1);
			stop_wan();
			stop_services();
			stop_lan();
			stop_resetbutton();
			create_rc_file(RC_SHUTDOWN);
			system("/tmp/.rc_shutdown");
			if (state == STOP) {
				state = IDLE;
				break;
			}
			/* Fall through */
		case START:
			dprintf("START\n");
			setenv("PATH", "/sbin:/bin:/usr/sbin:/usr/bin", 1);
			start_ipv6();
			start_resetbutton();
			setup_vlans();
			start_lan();
			start_services();
			start_wan(BOOT);
			start_nas("wan");
			create_rc_file(RC_STARTUP);
			chmod("/tmp/.rc_startup", 0700);
			system("/tmp/.rc_startup");
			diag_led(DIAG, STOP_LED);
			/* Fall through */
		case TIMER:
			dprintf("TIMER\n");
			do_timer();
			/* Fall through */
		case IDLE:
			dprintf("IDLE\n");
			state = IDLE;
			/* Wait for user input or state change */
			while (signalled == -1) {
				if (!noconsole && (!shell_pid || kill(shell_pid, 0) != 0))
					shell_pid = run_shell(0, 1);
				else
					sigsuspend(&sigset);
			}
			state = signalled;
			signalled = -1;
			break;
		default:
			dprintf("UNKNOWN\n");
			return;
		}
	}

}


#define CONVERT_NV(old, new) \
	if(nvram_get(old)) \
		nvram_set(new, nvram_safe_get(old));


static int
init_nvram(void)
{	
	int i=0;
	
	/* broadcom 3.11.48.7 change some nvram name */
	CONVERT_NV("d11g_channel","wl_channel");
	CONVERT_NV("d11g_rateset","wl_rateset");
	CONVERT_NV("d11g_rts","wl_rts");
	CONVERT_NV("d11g_bcn","wl_bcn");
	CONVERT_NV("d11g_mode","wl_gmode");
	CONVERT_NV("d11g_rate","wl_rate");
	CONVERT_NV("d11g_frag","wl_frag");
	CONVERT_NV("d11g_dtim","wl_dtim");

	nvram_set("wl0_hwaddr","");	// When disbale wireless, we must get null wireless mac */

	nvram_set("wan_get_dns","");
	nvram_set("filter_id","1");
	nvram_set("wl_active_add_mac","0");
	nvram_set("ddns_change","");
	nvram_set("action_service","");
	nvram_set("ddns_interval","60");

	//if(!nvram_get("wl_macmode1")){
	//	if(nvram_match("wl_macmode","disabled"))
	//		nvram_set("wl_macmode1","disabled");
	//	else
	//		nvram_set("wl_macmode1","other");
	//}
	if(nvram_match("wl_gmode","5"))	// Mixed mode had been changed to 5
		nvram_set("wl_gmode","1");

	if(nvram_match("wl_gmode","4")) // G-ONLY mode had been changed to 2, after 1.40.1 for WiFi G certication
                nvram_set("wl_gmode","2");

//	nvram_set("wl_country","Worldwide");	// The country always Worldwide

#ifndef AOL_SUPPORT
	nvram_set("aol_block_traffic","0");
	nvram_set("aol_block_traffic1","0");
	nvram_set("aol_block_traffic2","0");
#endif
	nvram_set("ping_ip","");
	nvram_set("ping_times","");
	nvram_set("traceroute_ip","");

	nvram_set("filter_port", "");	// The name have been disbaled from 1.41.3

	if(nvram_invmatch("sv_restore_defaults", "1")){
		for (i = 0; i < MAX_NVPARSE; i++) {
			char name[] = "forward_portXXXXXXXXXX";
			snprintf(name, sizeof(name), "forward_port%d", i);
			if(nvram_get(name) && strstr(nvram_safe_get(name), "msmsgs")){
				cprintf("unset MSN value %d..........\n", i);
				nvram_unset(name);
			}
		}
	}

	/* The tkip and aes already are changed to wl_crypto from v3.63.3.0 */
	if(nvram_match("wl_wep", "tkip")) {
		nvram_set("wl_crypto", "tkip");
	}
	else if(nvram_match("wl_wep", "aes")) {
		nvram_set("wl_crypto", "aes");
	}
	else if(nvram_match("wl_wep", "tkip+aes")) {
		nvram_set("wl_crypto", "tkip+aes");
	}

	if(nvram_match("wl_wep", "restricted"))
		nvram_set("wl_wep", "enabled");	// the nas need this value, the "restricted" is no longer need. (20040624 by honor)


// begin Sveasoft additions
#ifdef HAVE_SET_BOOT
	if( !nvram_match("boot_wait_web", "0") )
	  nvram_set("boot_wait_web", "1");
#endif

#ifdef HAVE_SSHD
	if(!nvram_match("sshd_web", "0"))
	  nvram_set("sshd_web", "1");
#endif

	/* added 2003-12-24 Sveasoft - force board to 14 channels by setting locale to Japan */
	nvram_set("wl0_country_code", "JP");
	nvram_set("wl0_country", "Japan");

// end Sveasoft addition

	/* Let HW1.x users can communicate with WAP54G without setting to factory default */
//	nvram_safe_set("wl_lazywds", "1");

	return 0;
}

static void
unset_nvram(void)
{
#ifndef MPPPOE_SUPPORT
	nvram_safe_unset("ppp_username_1");
	nvram_safe_unset("ppp_passwd_1");
	nvram_safe_unset("ppp_idletime_1");
	nvram_safe_unset("ppp_demand_1");
	nvram_safe_unset("ppp_redialperiod_1");
	nvram_safe_unset("ppp_service_1");
	nvram_safe_unset("mpppoe_enable");
	nvram_safe_unset("mpppoe_dname");
#endif
#ifndef HTTPS_SUPPORT
        nvram_safe_unset("remote_mgt_https");
#endif
#ifndef HSIAB_SUPPORT
        nvram_safe_unset("hsiab_mode");
        nvram_safe_unset("hsiab_provider");
        nvram_safe_unset("hsiab_device_id");
        nvram_safe_unset("hsiab_device_password");
        nvram_safe_unset("hsiab_admin_url");
        nvram_safe_unset("hsiab_registered");
        nvram_safe_unset("hsiab_configured");
        nvram_safe_unset("hsiab_register_ops");
        nvram_safe_unset("hsiab_session_ops");
        nvram_safe_unset("hsiab_config_ops");
        nvram_safe_unset("hsiab_manual_reg_ops");
        nvram_safe_unset("hsiab_proxy_host");
        nvram_safe_unset("hsiab_proxy_port");
        nvram_safe_unset("hsiab_conf_time");
        nvram_safe_unset("hsiab_stats_time");
        nvram_safe_unset("hsiab_session_time");
        nvram_safe_unset("hsiab_sync");
        nvram_safe_unset("hsiab_config");
#endif

#ifndef HEARTBEAT_SUPPORT
        nvram_safe_unset("hb_server_ip");
        nvram_safe_unset("hb_server_domain");
#endif

#ifndef PARENTAL_CONTROL_SUPPORT
        nvram_safe_unset("artemis_enable");
        nvram_safe_unset("artemis_SVCGLOB");
        nvram_safe_unset("artemis_HB_DB");
        nvram_safe_unset("artemis_provisioned");
#endif

#ifndef WL_STA_SUPPORT
//        nvram_safe_unset("wl_ap_ssid");
//        nvram_safe_unset("wl_ap_ip");
#endif

#ifndef UPNP_FORWARD_SUPPORT
	{
	int i;
	for (i = 0; i < MAX_NVPARSE; i++) {
		del_forward_port(i);
	}
	}
#endif


//#ifndef SYSLOG_SUPPORT
	{
	struct support_list *s;
	char buf[80];
	for(s = supports ; s < &supports[SUPPORT_COUNT] ; s++) {
		snprintf(buf, sizeof(buf), "LOG_%s", s->name);
		if(nvram_get(buf)){
			nvram_safe_unset(buf);
		}
	}
	}
	nvram_safe_unset("log_show_all");
	nvram_safe_unset("log_show_type");
//#endif

}

static int
check_nv(char *name, char *value)
{
	int ret = 0;
	
	if(!nvram_get(name)){
		cprintf("ERR: Cann't find %s !.......................\n", name);
		nvram_set(name, value);
		ret ++; 
	}
	else if (nvram_invmatch(name, value)){
		cprintf("ERR: The %s is %s, not %s !.................\n", name, nvram_safe_get(name), value);
		nvram_set(name, value);
		ret ++;
	}

	return ret;
}

static int
check_cfe_nv(void)
{
	int ret = 0;
;
	ret += check_nv("boardtype", "0x0101");
//	ret += check_nv("boardflags", "0x0188");
//	ret += check_nv("boardflags", "0x0388");

	ret += check_nv("boardrev", "0x10");
	ret += check_nv("boardflags2", "0");
	ret += check_nv("sromrev", "2");

	ret += check_nv("aa0", "3");
	ret += check_nv("ag0", "255");
	ret += check_nv("pa0itssit", "62");
	ret += check_nv("pa0b0", "0x170c");
	ret += check_nv("pa0b1", "0xfa24");
	ret += check_nv("pa0b2", "0xfe70");
	ret += check_nv("pa0maxpwr", "0x48");

	ret += check_nv("gpio2", "adm_eecs");
	ret += check_nv("gpio3", "adm_eesk");
	ret += check_nv("gpio5", "adm_eedi");
	ret += check_nv("gpio6", "adm_rc");

	ret += check_nv("wl0gpio2", "0");
	ret += check_nv("wl0gpio3", "0");

	ret += check_nv("cctl", "0");
	ret += check_nv("ccode", "0");

	if(ret){
		cprintf("Some error found, we want to reboot!.....................\n");
		nvram_commit();
		kill(1, SIGTERM);
	}

	return ret;
}

static int
check_pmon_nv(void)
{
	return 0;
}

static int
check_image(void)
{
	int ret = 0;
	eval("insmod","writemac","flag=get_flash"); //Barry adds for set flash_type 2003 09 08
        nvram_set("firmware_version",CYBERTAN_VERSION);
        nvram_set("Intel_firmware_version",INTEL_FLASH_SUPPORT_VERSION_FROM);
        nvram_set("bcm4712_firmware_version",BCM4712_CHIP_SUPPORT_VERSION_FROM);
	eval("rmmod","writemac");

	return ret;
}

int
main(int argc, char **argv)
{
	char *base = strrchr(argv[0], '/');
	
	base = base ? base + 1 : argv[0];

	/* init */
	if (strstr(base, "init")) {
		main_loop();
		return 0;
	}

	/* Set TZ for all rc programs */
	setenv("TZ", nvram_safe_get("time_zone"), 1);

	/* ppp */
	if (strstr(base, "ip-up"))
		return ipup_main(argc, argv);
	else if (strstr(base, "ip-down"))
		return ipdown_main(argc, argv);

	/* udhcpc [ deconfig bound renew ] */
	else if (strstr(base, "udhcpc"))
		return udhcpc_main(argc, argv);
#ifdef HAVE_PPTPD
	/* poptop [ stop start restart ]  */
	else if (strstr(base, "poptop"))
		return pptpd_main(argc, argv);
#endif
	/* erase [device] */
	else if (strstr(base, "erase")) {
		if (argv[1])
			return mtd_erase(argv[1]);
		else {
			fprintf(stderr, "usage: erase [device]\n");
			return EINVAL;
		}
	}

	/* write [path] [device] */
	else if (strstr(base, "write")) {
		if (argc >= 3)
			return mtd_write(argv[1], argv[2]);
		else {
			fprintf(stderr, "usage: write [path] [device]\n");
			return EINVAL;
		}
	}
	/* hotplug [event] */
	else if (strstr(base, "hotplug")) {
		if (argc >= 2) {
			if (!strcmp(argv[1], "net"))
				return hotplug_net();
		} else {
			fprintf(stderr, "usage: hotplug [event]\n");
			return EINVAL;
		}
	}
	/* rc [stop|start|restart ] */
	else if (strstr(base, "rc")) {
		if (argv[1]) {
			if (strncmp(argv[1], "start", 5) == 0)
				return kill(1, SIGUSR2);
			else if (strncmp(argv[1], "stop", 4) == 0)
				return kill(1, SIGINT);
			else if (strncmp(argv[1], "restart", 7) == 0)
				return kill(1, SIGHUP);
		} else {
			fprintf(stderr, "usage: rc [start|stop|restart]\n");
			return EINVAL;
		}
	}

	//////////////////////////////////////////////////////
	//
	else if (strstr(base, "filtersync"))
		return filtersync_main();
        /* filter [add|del] number */
        else if (strstr(base, "filter")) {
                if (argv[1] && argv[2]) {
                        int num=0;
                        if( (num=atoi(argv[2])) > 0 ){
                                if (strcmp(argv[1], "add") == 0)
                                        return filter_add(num);
                                else if (strcmp(argv[1], "del") == 0)
                                        return filter_del(num);
                        }
                }
                else {
        	        fprintf(stderr, "usage: filter [add|del] number\n");
                        return EINVAL;
		}
        }
	else if (strstr(base, "redial"))
		return redial_main(argc, argv);

	else if (strstr(base, "resetbutton"))
                return resetbutton_main(argc, argv);

        else if (strstr(base, "wland"))
                return wland_main(argc, argv);

	else if (strstr(base, "write_boot"))
		return write_boot("/tmp/boot.bin","pmon");

#ifdef DEBUG_IPTABLE
        else if (strstr(base, "iptable_range"))
                return range_main(argc, argv);
        else if (strstr(base, "iptable_rule"))
                return rule_main(argc, argv);
#endif



	 else if (strstr(base, "hb_connect"))
                 return hb_connect_main(argc, argv);
         else if (strstr(base, "hb_disconnect"))
                 return hb_disconnect_main(argc, argv);

	else if (strstr(base, "gpio"))
		return gpio_main(argc, argv);
	else if (strstr(base, "listen"))
		return listen_main(argc, argv);
	else if (strstr(base, "check_ps"))
		return check_ps_main(argc, argv);
	else if (strstr(base, "ddns_success"))
		return ddns_success_main(argc, argv);
        else if (strstr(base, "process_monitor"))
                return process_monitor_main();
        else if (strstr(base, "site_survey"))
                return site_suvery_main();		
	else if (strstr(base, "setpasswd"))
		mkfiles();
#ifdef HAVE_WOL
	else if (strstr(base, "wol"))
		start_wol();
#endif		

	return EINVAL;
}
